/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.binfmt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataOutput;
import java.io.IOException;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.Decimal64;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.binfmt.AbstractNormalizedNodeDataOutput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.LithiumPathArgument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractLithiumDataOutput
extends AbstractNormalizedNodeDataOutput {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLithiumDataOutput.class);
    private static final TransformerFactory TF = TransformerFactory.newInstance();
    private static final ImmutableMap<Class<?>, Byte> KNOWN_TYPES = ImmutableMap.builder().put(String.class, (Object)9).put(Byte.class, (Object)2).put(Integer.class, (Object)3).put(Long.class, (Object)4).put(Boolean.class, (Object)5).put(QName.class, (Object)6).put(Short.class, (Object)1).put(BigInteger.class, (Object)10).put(BigDecimal.class, (Object)11).put(Decimal64.class, (Object)11).put(byte[].class, (Object)12).put(Empty.class, (Object)15).build();
    private final Map<String, Integer> stringCodeMap = new HashMap<String, Integer>();
    private QName lastLeafSetQName;
    private boolean inSimple;

    AbstractLithiumDataOutput(DataOutput output) {
        super(output);
    }

    public final void startLeafNode(YangInstanceIdentifier.NodeIdentifier name) throws IOException {
        LOG.trace("Starting a new leaf node");
        this.startNode((YangInstanceIdentifier.PathArgument)name, (byte)1);
        this.inSimple = true;
    }

    public final void startLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        LOG.trace("Starting a new leaf set");
        this.commonStartLeafSet(name, (byte)2);
    }

    public final void startOrderedLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        LOG.trace("Starting a new ordered leaf set");
        this.commonStartLeafSet(name, (byte)14);
    }

    private void commonStartLeafSet(YangInstanceIdentifier.NodeIdentifier name, byte nodeType) throws IOException {
        this.startNode((YangInstanceIdentifier.PathArgument)name, nodeType);
        this.lastLeafSetQName = name.getNodeType();
    }

    public final void startLeafSetEntryNode(YangInstanceIdentifier.NodeWithValue<?> name) throws IOException {
        LOG.trace("Starting a new leaf set entry node");
        this.output.writeByte(3);
        if (this.lastLeafSetQName == null) {
            this.writeQNameInternal(name.getNodeType());
        }
        this.inSimple = true;
    }

    public final void startContainerNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        LOG.trace("Starting a new container node");
        this.startNode((YangInstanceIdentifier.PathArgument)name, (byte)4);
    }

    public final void startUnkeyedList(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        LOG.trace("Starting a new unkeyed list");
        this.startNode((YangInstanceIdentifier.PathArgument)name, (byte)5);
    }

    public final void startUnkeyedListItem(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        LOG.trace("Starting a new unkeyed list item");
        this.startNode((YangInstanceIdentifier.PathArgument)name, (byte)6);
    }

    public final void startMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        LOG.trace("Starting a new map node");
        this.startNode((YangInstanceIdentifier.PathArgument)name, (byte)7);
    }

    public final void startMapEntryNode(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier, int childSizeHint) throws IOException {
        LOG.trace("Starting a new map entry node");
        this.startNode((YangInstanceIdentifier.PathArgument)identifier, (byte)8);
        this.writeKeyValueMap(identifier.entrySet());
    }

    public final void startOrderedMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        LOG.trace("Starting a new ordered map node");
        this.startNode((YangInstanceIdentifier.PathArgument)name, (byte)9);
    }

    public final void startChoiceNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        LOG.trace("Starting a new choice node");
        this.startNode((YangInstanceIdentifier.PathArgument)name, (byte)10);
    }

    public final void startAugmentationNode(YangInstanceIdentifier.AugmentationIdentifier identifier) throws IOException {
        Objects.requireNonNull(identifier, "Node identifier should not be null");
        LOG.trace("Starting a new augmentation node");
        this.output.writeByte(11);
        this.writeAugmentationIdentifier(identifier);
    }

    public final boolean startAnyxmlNode(YangInstanceIdentifier.NodeIdentifier name, Class<?> objectModel) throws IOException {
        if (DOMSource.class.isAssignableFrom(objectModel)) {
            LOG.trace("Starting anyxml node");
            this.startNode((YangInstanceIdentifier.PathArgument)name, (byte)12);
            this.inSimple = true;
            return true;
        }
        return false;
    }

    public final void scalarValue(Object value) throws IOException {
        this.writeObject(value);
    }

    public final void domSourceValue(DOMSource value) throws IOException {
        StringWriter writer = new StringWriter();
        try {
            TF.newTransformer().transform(value, new StreamResult(writer));
        }
        catch (TransformerException e) {
            throw new IOException("Error writing anyXml", e);
        }
        this.writeObject(writer.toString());
    }

    public final void endNode() throws IOException {
        LOG.trace("Ending the node");
        if (!this.inSimple) {
            this.lastLeafSetQName = null;
            this.output.writeByte(13);
        }
        this.inSimple = false;
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="The casts in the switch clauses are indirectly confirmed via the determination of 'type'.")
    final void writePathArgumentInternal(YangInstanceIdentifier.PathArgument pathArgument) throws IOException {
        byte type = LithiumPathArgument.getSerializablePathArgumentType(pathArgument);
        this.output.writeByte(type);
        switch (type) {
            case 2: {
                YangInstanceIdentifier.NodeIdentifier nodeIdentifier = (YangInstanceIdentifier.NodeIdentifier)pathArgument;
                this.writeQNameInternal(nodeIdentifier.getNodeType());
                break;
            }
            case 4: {
                YangInstanceIdentifier.NodeIdentifierWithPredicates nodeIdentifierWithPredicates = (YangInstanceIdentifier.NodeIdentifierWithPredicates)pathArgument;
                this.writeQNameInternal(nodeIdentifierWithPredicates.getNodeType());
                this.writeKeyValueMap(nodeIdentifierWithPredicates.entrySet());
                break;
            }
            case 3: {
                YangInstanceIdentifier.NodeWithValue nodeWithValue = (YangInstanceIdentifier.NodeWithValue)pathArgument;
                this.writeQNameInternal(nodeWithValue.getNodeType());
                this.writeObject(nodeWithValue.getValue());
                break;
            }
            case 1: {
                this.writeAugmentationIdentifier((YangInstanceIdentifier.AugmentationIdentifier)pathArgument);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown node identifier type is found : " + pathArgument.getClass().toString());
            }
        }
    }

    @Override
    final void writeYangInstanceIdentifierInternal(YangInstanceIdentifier identifier) throws IOException {
        List pathArguments = identifier.getPathArguments();
        this.output.writeInt(pathArguments.size());
        for (YangInstanceIdentifier.PathArgument pathArgument : pathArguments) {
            this.writePathArgumentInternal(pathArgument);
        }
    }

    final void defaultWriteAugmentationIdentifier(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.AugmentationIdentifier aid) throws IOException {
        Set qnames = aid.getPossibleChildNames();
        if (!qnames.isEmpty()) {
            this.output.writeInt(qnames.size());
            for (QName qname : qnames) {
                this.writeQNameInternal(qname);
            }
        } else {
            LOG.debug("augmentation node does not have any child");
            this.output.writeInt(0);
        }
    }

    final void defaultWriteQName(QName qname) throws IOException {
        this.writeString(qname.getLocalName());
        this.writeModule(qname.getModule());
    }

    final void defaultWriteModule(QNameModule module) throws IOException {
        this.writeString(module.getNamespace().toString());
        Optional revision = module.getRevision();
        if (revision.isPresent()) {
            this.writeString(((Revision)revision.orElseThrow()).toString());
        } else {
            this.writeByte(3);
        }
    }

    abstract void writeModule(QNameModule var1) throws IOException;

    abstract void writeAugmentationIdentifier(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.AugmentationIdentifier var1) throws IOException;

    private void startNode(YangInstanceIdentifier.PathArgument arg, byte nodeType) throws IOException {
        Objects.requireNonNull(arg, "Node identifier should not be null");
        Preconditions.checkState((!this.inSimple ? 1 : 0) != 0, (Object)"Attempted to start a child in a simple node");
        this.output.writeByte(nodeType);
        this.writeQNameInternal(arg.getNodeType());
    }

    private void writeObjSet(Set<?> set) throws IOException {
        this.output.writeInt(set.size());
        for (Object o : set) {
            Preconditions.checkArgument((boolean)(o instanceof String), (String)"Expected value type to be String but was %s (%s)", o.getClass(), o);
            this.writeString((String)o);
        }
    }

    private void writeObject(Object value) throws IOException {
        byte type = AbstractLithiumDataOutput.getSerializableType(value);
        this.output.writeByte(type);
        switch (type) {
            case 5: {
                this.output.writeBoolean((Boolean)value);
                break;
            }
            case 6: {
                this.writeQNameInternal((QName)value);
                break;
            }
            case 3: {
                this.output.writeInt((Integer)value);
                break;
            }
            case 2: {
                this.output.writeByte(((Byte)value).byteValue());
                break;
            }
            case 4: {
                this.output.writeLong((Long)value);
                break;
            }
            case 1: {
                this.output.writeShort(((Short)value).shortValue());
                break;
            }
            case 7: {
                this.writeObjSet((Set)value);
                break;
            }
            case 12: {
                byte[] bytes = (byte[])value;
                this.output.writeInt(bytes.length);
                this.output.write(bytes);
                break;
            }
            case 8: {
                this.writeYangInstanceIdentifierInternal((YangInstanceIdentifier)value);
                break;
            }
            case 15: {
                break;
            }
            case 14: {
                byte[] valueBytes = value.toString().getBytes(StandardCharsets.UTF_8);
                this.output.writeInt(valueBytes.length);
                this.output.write(valueBytes);
                break;
            }
            default: {
                this.output.writeUTF(value.toString());
            }
        }
    }

    private void writeKeyValueMap(Set<Map.Entry<QName, Object>> entrySet) throws IOException {
        if (!entrySet.isEmpty()) {
            this.output.writeInt(entrySet.size());
            for (Map.Entry<QName, Object> entry : entrySet) {
                this.writeQNameInternal(entry.getKey());
                this.writeObject(entry.getValue());
            }
        } else {
            this.output.writeInt(0);
        }
    }

    private void writeString(@NonNull String string) throws IOException {
        Integer value = this.stringCodeMap.get(Verify.verifyNotNull((Object)string));
        if (value == null) {
            this.stringCodeMap.put(string, this.stringCodeMap.size());
            this.writeByte(2);
            this.writeUTF(string);
        } else {
            this.writeByte(1);
            this.writeInt(value);
        }
    }

    @VisibleForTesting
    static final byte getSerializableType(Object node) {
        Byte type = (Byte)KNOWN_TYPES.get(Objects.requireNonNull(node).getClass());
        if (type != null) {
            if (type == 9 && ((String)node).length() >= 8191) {
                return 14;
            }
            return type;
        }
        if (node instanceof Set) {
            return 7;
        }
        if (node instanceof YangInstanceIdentifier) {
            return 8;
        }
        throw new IllegalArgumentException("Unknown value type " + node.getClass().getSimpleName());
    }
}

