/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.ChannelUri;
import io.aeron.CommonContext;
import io.aeron.ErrorCode;
import io.aeron.driver.AeronClient;
import io.aeron.driver.ClientCommandAdapter;
import io.aeron.driver.ClientProxy;
import io.aeron.driver.Configuration;
import io.aeron.driver.CongestionControl;
import io.aeron.driver.CounterLink;
import io.aeron.driver.DataPacketDispatcher;
import io.aeron.driver.DriverManagedResource;
import io.aeron.driver.DriverNameResolver;
import io.aeron.driver.FlowControl;
import io.aeron.driver.IpcPublication;
import io.aeron.driver.IpcSubscriptionLink;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.NameResolver;
import io.aeron.driver.NetworkPublication;
import io.aeron.driver.NetworkPublicationThreadLocals;
import io.aeron.driver.NetworkSubscriptionLink;
import io.aeron.driver.PublicationImage;
import io.aeron.driver.PublicationLink;
import io.aeron.driver.PublicationParams;
import io.aeron.driver.ReceiverProxy;
import io.aeron.driver.RetransmitHandler;
import io.aeron.driver.SenderProxy;
import io.aeron.driver.SessionKey;
import io.aeron.driver.SpySubscriptionLink;
import io.aeron.driver.SubscriberPosition;
import io.aeron.driver.SubscriptionLink;
import io.aeron.driver.SubscriptionParams;
import io.aeron.driver.buffer.LogFactory;
import io.aeron.driver.buffer.RawLog;
import io.aeron.driver.exceptions.InvalidChannelException;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.media.ReceiveDestinationTransport;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.status.ClientHeartbeatTimestamp;
import io.aeron.driver.status.PublisherLimit;
import io.aeron.driver.status.PublisherPos;
import io.aeron.driver.status.ReceiveChannelStatus;
import io.aeron.driver.status.ReceiveLocalSocketAddress;
import io.aeron.driver.status.ReceiverHwm;
import io.aeron.driver.status.ReceiverPos;
import io.aeron.driver.status.SendChannelStatus;
import io.aeron.driver.status.SendLocalSocketAddress;
import io.aeron.driver.status.SenderBpe;
import io.aeron.driver.status.SenderLimit;
import io.aeron.driver.status.SenderPos;
import io.aeron.driver.status.SubscriberPos;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.exceptions.AeronEvent;
import io.aeron.exceptions.ControlProtocolException;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.protocol.DataHeaderFlyweight;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.agrona.BitUtil;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayListUtil;
import org.agrona.collections.Object2ObjectHashMap;
import org.agrona.collections.ObjectHashSet;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.CachedEpochClock;
import org.agrona.concurrent.CachedNanoClock;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.ManyToOneConcurrentArrayQueue;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.ringbuffer.RingBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersManager;
import org.agrona.concurrent.status.Position;
import org.agrona.concurrent.status.ReadablePosition;
import org.agrona.concurrent.status.UnsafeBufferPosition;

public final class DriverConductor
implements Agent {
    private static final long CLOCK_UPDATE_INTERNAL_NS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final String[] INVALID_DESTINATION_KEYS = new String[]{"mtu", "rcv-wnd", "so-rcvbuf", "so-sndbuf"};
    private int nextSessionId = BitUtil.generateRandomisedId();
    private final long timerIntervalNs;
    private final long clientLivenessTimeoutNs;
    private long timeOfLastToDriverPositionChangeNs;
    private long lastConsumerCommandPosition;
    private long timerCheckDeadlineNs;
    private long clockUpdateDeadlineNs;
    private final MediaDriver.Context ctx;
    private final LogFactory logFactory;
    private final ReceiverProxy receiverProxy;
    private final SenderProxy senderProxy;
    private final ClientProxy clientProxy;
    private final RingBuffer toDriverCommands;
    private final ClientCommandAdapter clientCommandAdapter;
    private final ManyToOneConcurrentArrayQueue<Runnable> driverCmdQueue;
    private final Object2ObjectHashMap<String, SendChannelEndpoint> sendChannelEndpointByChannelMap = new Object2ObjectHashMap();
    private final Object2ObjectHashMap<String, ReceiveChannelEndpoint> receiveChannelEndpointByChannelMap = new Object2ObjectHashMap();
    private final ArrayList<NetworkPublication> networkPublications = new ArrayList();
    private final ArrayList<IpcPublication> ipcPublications = new ArrayList();
    private final ArrayList<PublicationImage> publicationImages = new ArrayList();
    private final ArrayList<PublicationLink> publicationLinks = new ArrayList();
    private final ArrayList<SubscriptionLink> subscriptionLinks = new ArrayList();
    private final ArrayList<CounterLink> counterLinks = new ArrayList();
    private final ArrayList<AeronClient> clients = new ArrayList();
    private final ObjectHashSet<SessionKey> activeSessionSet = new ObjectHashSet();
    private final EpochClock epochClock;
    private final NanoClock nanoClock;
    private final CachedEpochClock cachedEpochClock;
    private final CachedNanoClock cachedNanoClock;
    private final CountersManager countersManager;
    private final NetworkPublicationThreadLocals networkPublicationThreadLocals = new NetworkPublicationThreadLocals();
    private final MutableDirectBuffer tempBuffer;
    private final DataHeaderFlyweight defaultDataHeader = new DataHeaderFlyweight(DataHeaderFlyweight.createDefaultHeader((int)0, (int)0, (int)0));
    private NameResolver nameResolver;
    private DriverNameResolver driverNameResolver;
    private final AtomicCounter errorCounter;
    private final AtomicCounter maxCycleTime;
    private final AtomicCounter cycleTimeThresholdExceededCount;

    DriverConductor(MediaDriver.Context ctx) {
        this.ctx = ctx;
        this.timerIntervalNs = ctx.timerIntervalNs();
        this.clientLivenessTimeoutNs = ctx.clientLivenessTimeoutNs();
        this.driverCmdQueue = ctx.driverCommandQueue();
        this.receiverProxy = ctx.receiverProxy();
        this.senderProxy = ctx.senderProxy();
        this.logFactory = ctx.logFactory();
        this.epochClock = ctx.epochClock();
        this.nanoClock = ctx.nanoClock();
        this.cachedEpochClock = ctx.cachedEpochClock();
        this.cachedNanoClock = ctx.cachedNanoClock();
        this.toDriverCommands = ctx.toDriverCommands();
        this.clientProxy = ctx.clientProxy();
        this.tempBuffer = ctx.tempBuffer();
        this.errorCounter = ctx.systemCounters().get(SystemCounterDescriptor.ERRORS);
        this.countersManager = ctx.countersManager();
        this.clientCommandAdapter = new ClientCommandAdapter(this.errorCounter, ctx.errorHandler(), this.toDriverCommands, this.clientProxy, this);
        this.lastConsumerCommandPosition = this.toDriverCommands.consumerPosition();
        this.maxCycleTime = ctx.systemCounters().get(SystemCounterDescriptor.CONDUCTOR_MAX_CYCLE_TIME);
        this.cycleTimeThresholdExceededCount = ctx.systemCounters().get(SystemCounterDescriptor.CONDUCTOR_CYCLE_TIME_THRESHOLD_EXCEEDED);
    }

    public void onStart() {
        if (null == this.ctx.resolverInterface()) {
            this.driverNameResolver = null;
            this.nameResolver = this.ctx.nameResolver();
        } else {
            this.driverNameResolver = new DriverNameResolver(this.ctx);
            this.nameResolver = this.driverNameResolver;
        }
        this.ctx.systemCounters().get(SystemCounterDescriptor.RESOLUTION_CHANGES).appendToLabel(": driverName=" + this.ctx.resolverName() + " hostname=" + DriverNameResolver.getCanonicalName("<unresolved>"));
        this.ctx.systemCounters().get(SystemCounterDescriptor.CONDUCTOR_CYCLE_TIME_THRESHOLD_EXCEEDED).appendToLabel(": threshold=" + this.ctx.conductorCycleThresholdNs() + "ns");
        this.nameResolver.init(this.ctx);
        long nowNs = this.nanoClock.nanoTime();
        this.cachedNanoClock.update(nowNs);
        this.cachedEpochClock.update(this.epochClock.time());
        this.timerCheckDeadlineNs = nowNs + this.timerIntervalNs;
        this.clockUpdateDeadlineNs = nowNs + CLOCK_UPDATE_INTERNAL_NS;
        this.timeOfLastToDriverPositionChangeNs = nowNs;
    }

    public void onClose() {
        CloseHelper.close((ErrorHandler)this.ctx.errorHandler(), (AutoCloseable)this.driverNameResolver);
        this.publicationImages.forEach(PublicationImage::free);
        this.networkPublications.forEach(NetworkPublication::free);
        this.ipcPublications.forEach(IpcPublication::free);
        this.toDriverCommands.consumerHeartbeatTime(-1L);
        this.ctx.close();
    }

    public String roleName() {
        return "driver-conductor";
    }

    public int doWork() {
        long nowNs = this.nanoClock.nanoTime();
        this.trackTime(nowNs);
        int workCount = 0;
        workCount += this.processTimers(nowNs);
        workCount += this.clientCommandAdapter.receive();
        workCount += this.driverCmdQueue.drain(Runnable::run, 2);
        workCount += this.trackStreamPositions(workCount, nowNs);
        return workCount += this.nameResolver.doWork(this.cachedEpochClock.time());
    }

    void onCreatePublicationImage(int sessionId, int streamId, int initialTermId, int activeTermId, int initialTermOffset, int termBufferLength, int senderMtuLength, int transportIndex, InetSocketAddress controlAddress, InetSocketAddress sourceAddress, ReceiveChannelEndpoint channelEndpoint) {
        Configuration.validateMtuLength(senderMtuLength);
        UdpChannel subscriptionChannel = channelEndpoint.subscriptionUdpChannel();
        Configuration.validateInitialWindowLength(subscriptionChannel.receiverWindowLengthOrDefault(this.ctx.initialWindowLength()), senderMtuLength);
        long joinPosition = LogBufferDescriptor.computePosition((int)activeTermId, (int)initialTermOffset, (int)LogBufferDescriptor.positionBitsToShift((int)termBufferLength), (int)initialTermId);
        ArrayList<SubscriberPosition> subscriberPositions = this.createSubscriberPositions(sessionId, streamId, channelEndpoint, joinPosition);
        if (subscriberPositions.size() > 0) {
            RawLog rawLog = null;
            CongestionControl congestionControl = null;
            UnsafeBufferPosition hwmPos = null;
            UnsafeBufferPosition rcvPos = null;
            try {
                long registrationId = this.toDriverCommands.nextCorrelationId();
                rawLog = this.newPublicationImageLog(sessionId, streamId, initialTermId, termBufferLength, DriverConductor.isOldestSubscriptionSparse(subscriberPositions), senderMtuLength, registrationId);
                congestionControl = this.ctx.congestionControlSupplier().newInstance(registrationId, subscriptionChannel, streamId, sessionId, termBufferLength, senderMtuLength, controlAddress, sourceAddress, (NanoClock)this.ctx.receiverCachedNanoClock(), this.ctx, this.countersManager);
                SubscriptionLink subscription = subscriberPositions.get(0).subscription();
                String uri = subscription.channel();
                hwmPos = ReceiverHwm.allocate(this.tempBuffer, this.countersManager, registrationId, sessionId, streamId, uri);
                rcvPos = ReceiverPos.allocate(this.tempBuffer, this.countersManager, registrationId, sessionId, streamId, uri);
                boolean treatAsMulticast = subscription.group() == CommonContext.InferableBoolean.INFER ? channelEndpoint.udpChannel().isMulticast() : subscription.group() == CommonContext.InferableBoolean.FORCE_TRUE;
                PublicationImage image = new PublicationImage(registrationId, this.ctx, channelEndpoint, transportIndex, controlAddress, sessionId, streamId, initialTermId, activeTermId, initialTermOffset, rawLog, treatAsMulticast ? this.ctx.multicastFeedbackDelayGenerator() : this.ctx.unicastFeedbackDelayGenerator(), subscriberPositions, (Position)hwmPos, (Position)rcvPos, sourceAddress, congestionControl);
                this.publicationImages.add(image);
                this.receiverProxy.newPublicationImage(channelEndpoint, image);
                String sourceIdentity = Configuration.sourceIdentity(sourceAddress);
                int size = subscriberPositions.size();
                for (int i = 0; i < size; ++i) {
                    SubscriberPosition position = subscriberPositions.get(i);
                    position.addLink(image);
                    this.clientProxy.onAvailableImage(registrationId, streamId, sessionId, position.subscription().registrationId(), position.positionCounterId(), rawLog.fileName(), sourceIdentity);
                }
            }
            catch (Exception ex) {
                subscriberPositions.forEach(subscriberPosition -> subscriberPosition.position().close());
                CloseHelper.quietCloseAll((AutoCloseable[])new AutoCloseable[]{rawLog, congestionControl, hwmPos, rcvPos});
                throw ex;
            }
        }
    }

    void onChannelEndpointError(long statusIndicatorId, Exception ex) {
        String errorMessage = ex.getClass().getName() + " : " + ex.getMessage();
        this.clientProxy.onError(statusIndicatorId, ErrorCode.CHANNEL_ENDPOINT_ERROR, errorMessage);
    }

    void onReResolveEndpoint(String endpoint, SendChannelEndpoint channelEndpoint, InetSocketAddress address) {
        try {
            InetSocketAddress newAddress = UdpChannel.resolve(endpoint, "endpoint", true, this.nameResolver);
            if (newAddress.isUnresolved()) {
                this.ctx.errorHandler().onError((Throwable)new AeronEvent("could not re-resolve: endpoint=" + endpoint));
                this.errorCounter.increment();
            } else if (!address.equals(newAddress)) {
                this.senderProxy.onResolutionChange(channelEndpoint, endpoint, newAddress);
            }
        }
        catch (Exception ex) {
            this.ctx.errorHandler().onError((Throwable)ex);
            this.errorCounter.increment();
        }
    }

    void onReResolveControl(String control, UdpChannel udpChannel, ReceiveChannelEndpoint channelEndpoint, InetSocketAddress address) {
        try {
            InetSocketAddress newAddress = UdpChannel.resolve(control, "control", true, this.nameResolver);
            if (newAddress.isUnresolved()) {
                this.ctx.errorHandler().onError((Throwable)new AeronEvent("could not re-resolve: control=" + control));
                this.errorCounter.increment();
            } else if (!address.equals(newAddress)) {
                this.receiverProxy.onResolutionChange(channelEndpoint, udpChannel, newAddress);
            }
        }
        catch (Exception ex) {
            this.ctx.errorHandler().onError((Throwable)ex);
            this.errorCounter.increment();
        }
    }

    IpcPublication getSharedIpcPublication(long streamId) {
        return DriverConductor.findSharedIpcPublication(this.ipcPublications, streamId);
    }

    IpcPublication getIpcPublication(long registrationId) {
        int size = this.ipcPublications.size();
        for (int i = 0; i < size; ++i) {
            IpcPublication publication = this.ipcPublications.get(i);
            if (publication.registrationId() != registrationId) continue;
            return publication;
        }
        return null;
    }

    NetworkPublication findNetworkPublicationByTag(long tag) {
        int size = this.networkPublications.size();
        for (int i = 0; i < size; ++i) {
            NetworkPublication publication = this.networkPublications.get(i);
            long publicationTag = publication.tag();
            if (publicationTag != tag || publicationTag == -1L) continue;
            return publication;
        }
        return null;
    }

    IpcPublication findIpcPublicationByTag(long tag) {
        int size = this.ipcPublications.size();
        for (int i = 0; i < size; ++i) {
            IpcPublication publication = this.ipcPublications.get(i);
            long publicationTag = publication.tag();
            if (publicationTag != tag || publicationTag == -1L) continue;
            return publication;
        }
        return null;
    }

    void onAddNetworkPublication(String channel, int streamId, long correlationId, long clientId, boolean isExclusive) {
        UdpChannel udpChannel = UdpChannel.parse(channel, this.nameResolver);
        ChannelUri channelUri = udpChannel.channelUri();
        PublicationParams params = PublicationParams.getPublicationParams(channelUri, this.ctx, this, false);
        DriverConductor.validateEndpointForPublication(udpChannel);
        PublicationParams.validateMtuForMaxMessage(params, channel);
        SendChannelEndpoint channelEndpoint = this.getOrCreateSendChannelEndpoint(params, udpChannel, correlationId);
        NetworkPublication publication = null;
        if (!isExclusive) {
            publication = DriverConductor.findPublication(this.networkPublications, streamId, channelEndpoint);
        }
        boolean isNewPublication = false;
        if (null == publication) {
            if (params.hasSessionId) {
                this.checkForSessionClash(params.sessionId, streamId, udpChannel.canonicalForm(), channel);
            }
            publication = this.newNetworkPublication(correlationId, clientId, streamId, channel, udpChannel, channelEndpoint, params, isExclusive);
            isNewPublication = true;
        } else {
            PublicationParams.confirmMatch(channelUri, params, publication.rawLog(), publication.sessionId(), publication.channel(), publication.initialTermId(), publication.startingTermId(), publication.startingTermOffset());
            PublicationParams.validateSpiesSimulateConnection(params, publication.spiesSimulateConnection(), channel, publication.channel());
        }
        this.publicationLinks.add(new PublicationLink(correlationId, this.getOrAddClient(clientId), publication));
        this.clientProxy.onPublicationReady(correlationId, publication.registrationId(), streamId, publication.sessionId(), publication.rawLog().fileName(), publication.publisherLimitId(), channelEndpoint.statusIndicatorCounterId(), isExclusive);
        if (isNewPublication) {
            this.linkSpies(this.subscriptionLinks, publication);
        }
    }

    void cleanupSpies(NetworkPublication publication) {
        int size = this.subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            SubscriptionLink link = this.subscriptionLinks.get(i);
            if (!link.isLinked(publication)) continue;
            this.clientProxy.onUnavailableImage(publication.registrationId(), link.registrationId(), publication.streamId(), publication.channel());
            this.subscriptionLinks.get(i).unlink(publication);
        }
    }

    void notifyUnavailableImageLink(long resourceId, SubscriptionLink link) {
        this.clientProxy.onUnavailableImage(resourceId, link.registrationId(), link.streamId(), link.channel());
    }

    void notifyAvailableImageLink(long resourceId, int sessionId, SubscriptionLink link, int positionCounterId, long joinPosition, String logFileName, String sourceIdentity) {
        this.countersManager.setCounterValue(positionCounterId, joinPosition);
        int streamId = link.streamId();
        this.clientProxy.onAvailableImage(resourceId, streamId, sessionId, link.registrationId(), positionCounterId, logFileName, sourceIdentity);
    }

    void cleanupPublication(NetworkPublication publication) {
        this.senderProxy.removeNetworkPublication(publication);
        SendChannelEndpoint channelEndpoint = publication.channelEndpoint();
        if (channelEndpoint.shouldBeClosed()) {
            this.senderProxy.closeSendChannelEndpoint(channelEndpoint);
            this.sendChannelEndpointByChannelMap.remove((Object)channelEndpoint.udpChannel().canonicalForm());
            channelEndpoint.closeIndicators();
        }
        String channel = channelEndpoint.udpChannel().canonicalForm();
        this.activeSessionSet.remove((Object)new SessionKey(publication.sessionId(), publication.streamId(), channel));
    }

    void cleanupSubscriptionLink(SubscriptionLink subscription) {
        ReceiveChannelEndpoint channelEndpoint = subscription.channelEndpoint();
        if (null != channelEndpoint) {
            if (subscription.hasSessionId()) {
                if (0L == channelEndpoint.decRefToStreamAndSession(subscription.streamId(), subscription.sessionId())) {
                    this.receiverProxy.removeSubscription(channelEndpoint, subscription.streamId());
                }
            } else if (0 == channelEndpoint.decRefToStream(subscription.streamId())) {
                this.receiverProxy.removeSubscription(channelEndpoint, subscription.streamId());
            }
            if (channelEndpoint.shouldBeClosed()) {
                this.receiverProxy.closeReceiveChannelEndpoint(channelEndpoint);
                this.receiveChannelEndpointByChannelMap.remove((Object)channelEndpoint.udpChannel().canonicalForm());
                channelEndpoint.closeIndicators();
            }
        }
    }

    void transitionToLinger(PublicationImage image) {
        boolean rejoin = true;
        int size = this.subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            SubscriptionLink link = this.subscriptionLinks.get(i);
            if (!link.isLinked(image)) continue;
            rejoin = link.isRejoin();
            this.clientProxy.onUnavailableImage(image.correlationId(), link.registrationId(), image.streamId(), image.channel());
        }
        if (rejoin) {
            this.receiverProxy.removeCoolDown(image.channelEndpoint(), image.sessionId(), image.streamId());
        }
    }

    void transitionToLinger(IpcPublication publication) {
        this.activeSessionSet.remove((Object)new SessionKey(publication.sessionId(), publication.streamId(), "ipc"));
        int size = this.subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            SubscriptionLink link = this.subscriptionLinks.get(i);
            if (!link.isLinked(publication)) continue;
            this.clientProxy.onUnavailableImage(publication.registrationId(), link.registrationId(), publication.streamId(), "aeron:ipc");
        }
    }

    void cleanupImage(PublicationImage image) {
        int size = this.subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            this.subscriptionLinks.get(i).unlink(image);
        }
    }

    void cleanupIpcPublication(IpcPublication publication) {
        int size = this.subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            this.subscriptionLinks.get(i).unlink(publication);
        }
    }

    void clientTimeout(long clientId) {
        this.clientProxy.onClientTimeout(clientId);
    }

    void unavailableCounter(long registrationId, int counterId) {
        this.clientProxy.onUnavailableCounter(registrationId, counterId);
    }

    void onAddIpcPublication(String channel, int streamId, long correlationId, long clientId, boolean isExclusive) {
        IpcPublication publication = null;
        ChannelUri channelUri = ChannelUri.parse((CharSequence)channel);
        PublicationParams params = PublicationParams.getPublicationParams(channelUri, this.ctx, this, true);
        if (!isExclusive) {
            publication = DriverConductor.findSharedIpcPublication(this.ipcPublications, streamId);
        }
        boolean isNewPublication = false;
        if (null == publication) {
            if (params.hasSessionId) {
                this.checkForSessionClash(params.sessionId, streamId, "ipc", channel);
            }
            PublicationParams.validateMtuForMaxMessage(params, channel);
            publication = this.addIpcPublication(correlationId, clientId, streamId, channel, isExclusive, params);
            isNewPublication = true;
        } else {
            PublicationParams.confirmMatch(channelUri, params, publication.rawLog(), publication.sessionId(), publication.channel(), publication.initialTermId(), publication.startingTermId(), publication.startingTermOffset());
        }
        this.publicationLinks.add(new PublicationLink(correlationId, this.getOrAddClient(clientId), publication));
        this.clientProxy.onPublicationReady(correlationId, publication.registrationId(), streamId, publication.sessionId(), publication.rawLog().fileName(), publication.publisherLimitId(), -1, isExclusive);
        if (isNewPublication) {
            this.linkIpcSubscriptions(publication);
        }
    }

    void onRemovePublication(long registrationId, long correlationId) {
        PublicationLink publicationLink = null;
        ArrayList<PublicationLink> publicationLinks = this.publicationLinks;
        int size = publicationLinks.size();
        for (int i = 0; i < size; ++i) {
            PublicationLink publication = publicationLinks.get(i);
            if (registrationId != publication.registrationId()) continue;
            publicationLink = publication;
            ArrayListUtil.fastUnorderedRemove(publicationLinks, (int)i);
            break;
        }
        if (null == publicationLink) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_PUBLICATION, "unknown publication: " + registrationId);
        }
        publicationLink.close();
        this.clientProxy.operationSucceeded(correlationId);
    }

    void onAddSendDestination(long registrationId, String destinationChannel, long correlationId) {
        ChannelUri channelUri = ChannelUri.parse((CharSequence)destinationChannel);
        DriverConductor.validateDestinationUri(channelUri, destinationChannel);
        DriverConductor.validateSendDestinationUri(channelUri, destinationChannel);
        SendChannelEndpoint sendChannelEndpoint = null;
        int size = this.networkPublications.size();
        for (int i = 0; i < size; ++i) {
            NetworkPublication publication = this.networkPublications.get(i);
            if (registrationId != publication.registrationId()) continue;
            sendChannelEndpoint = publication.channelEndpoint();
            break;
        }
        if (null == sendChannelEndpoint) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_PUBLICATION, "unknown publication: " + registrationId);
        }
        sendChannelEndpoint.validateAllowsManualControl();
        InetSocketAddress dstAddress = UdpChannel.destinationAddress(channelUri, this.nameResolver);
        this.senderProxy.addDestination(sendChannelEndpoint, channelUri, dstAddress);
        this.clientProxy.operationSucceeded(correlationId);
    }

    void onRemoveSendDestination(long registrationId, String destinationChannel, long correlationId) {
        SendChannelEndpoint sendChannelEndpoint = null;
        int size = this.networkPublications.size();
        for (int i = 0; i < size; ++i) {
            NetworkPublication publication = this.networkPublications.get(i);
            if (registrationId != publication.registrationId()) continue;
            sendChannelEndpoint = publication.channelEndpoint();
            break;
        }
        if (null == sendChannelEndpoint) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_PUBLICATION, "unknown publication: " + registrationId);
        }
        sendChannelEndpoint.validateAllowsManualControl();
        ChannelUri channelUri = ChannelUri.parse((CharSequence)destinationChannel);
        InetSocketAddress dstAddress = UdpChannel.destinationAddress(channelUri, this.nameResolver);
        this.senderProxy.removeDestination(sendChannelEndpoint, channelUri, dstAddress);
        this.clientProxy.operationSucceeded(correlationId);
    }

    void onAddNetworkSubscription(String channel, int streamId, long registrationId, long clientId) {
        UdpChannel udpChannel = UdpChannel.parse(channel, this.nameResolver);
        DriverConductor.validateControlForSubscription(udpChannel);
        DriverConductor.validateTimestampConfiguration(udpChannel);
        SubscriptionParams params = SubscriptionParams.getSubscriptionParams(udpChannel.channelUri(), this.ctx);
        this.checkForClashingSubscription(params, udpChannel, streamId);
        ReceiveChannelEndpoint channelEndpoint = this.getOrCreateReceiveChannelEndpoint(params, udpChannel, registrationId);
        NetworkSubscriptionLink subscription = new NetworkSubscriptionLink(registrationId, channelEndpoint, streamId, channel, this.getOrAddClient(clientId), params);
        this.subscriptionLinks.add(subscription);
        if (params.hasSessionId) {
            if (1L == channelEndpoint.incRefToStreamAndSession(streamId, params.sessionId)) {
                this.receiverProxy.addSubscription(channelEndpoint, streamId, params.sessionId);
            }
        } else if (1 == channelEndpoint.incRefToStream(streamId)) {
            this.receiverProxy.addSubscription(channelEndpoint, streamId);
        }
        this.clientProxy.onSubscriptionReady(registrationId, channelEndpoint.statusIndicatorCounter().id());
        this.linkMatchingImages(subscription);
    }

    void onAddIpcSubscription(String channel, int streamId, long registrationId, long clientId) {
        SubscriptionParams params = SubscriptionParams.getSubscriptionParams(ChannelUri.parse((CharSequence)channel), this.ctx);
        IpcSubscriptionLink subscriptionLink = new IpcSubscriptionLink(registrationId, streamId, channel, this.getOrAddClient(clientId), params);
        this.subscriptionLinks.add(subscriptionLink);
        this.clientProxy.onSubscriptionReady(registrationId, -1);
        int size = this.ipcPublications.size();
        for (int i = 0; i < size; ++i) {
            IpcPublication publication = this.ipcPublications.get(i);
            if (!subscriptionLink.matches(publication) || !publication.isAcceptingSubscriptions()) continue;
            this.clientProxy.onAvailableImage(publication.registrationId(), streamId, publication.sessionId(), registrationId, this.linkIpcSubscription(publication, subscriptionLink).id(), publication.rawLog().fileName(), "aeron:ipc");
        }
    }

    void onAddSpySubscription(String channel, int streamId, long registrationId, long clientId) {
        UdpChannel udpChannel = UdpChannel.parse(channel, this.nameResolver);
        SubscriptionParams params = SubscriptionParams.getSubscriptionParams(udpChannel.channelUri(), this.ctx);
        SpySubscriptionLink subscriptionLink = new SpySubscriptionLink(registrationId, udpChannel, streamId, this.getOrAddClient(clientId), params);
        this.subscriptionLinks.add(subscriptionLink);
        this.clientProxy.onSubscriptionReady(registrationId, -1);
        int size = this.networkPublications.size();
        for (int i = 0; i < size; ++i) {
            NetworkPublication publication = this.networkPublications.get(i);
            if (!subscriptionLink.matches(publication) || !publication.isAcceptingSubscriptions()) continue;
            this.clientProxy.onAvailableImage(publication.registrationId(), streamId, publication.sessionId(), registrationId, this.linkSpy(publication, subscriptionLink).id(), publication.rawLog().fileName(), "aeron:ipc");
        }
    }

    void onRemoveSubscription(long registrationId, long correlationId) {
        int lastIndex;
        boolean isAnySubscriptionFound = false;
        for (int i = lastIndex = this.subscriptionLinks.size() - 1; i >= 0; --i) {
            SubscriptionLink subscription = this.subscriptionLinks.get(i);
            if (subscription.registrationId() != registrationId) continue;
            ArrayListUtil.fastUnorderedRemove(this.subscriptionLinks, (int)i, (int)lastIndex--);
            subscription.close();
            this.cleanupSubscriptionLink(subscription);
            isAnySubscriptionFound = true;
        }
        if (!isAnySubscriptionFound) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_SUBSCRIPTION, "unknown subscription: " + registrationId);
        }
        this.clientProxy.operationSucceeded(correlationId);
    }

    void onClientKeepalive(long clientId) {
        AeronClient client = DriverConductor.findClient(this.clients, clientId);
        if (null != client) {
            client.timeOfLastKeepaliveMs(this.cachedEpochClock.time());
        }
    }

    void onAddCounter(int typeId, DirectBuffer keyBuffer, int keyOffset, int keyLength, DirectBuffer labelBuffer, int labelOffset, int labelLength, long correlationId, long clientId) {
        AeronClient client = this.getOrAddClient(clientId);
        AtomicCounter counter = this.countersManager.newCounter(typeId, keyBuffer, keyOffset, keyLength, labelBuffer, labelOffset, labelLength);
        this.countersManager.setCounterOwnerId(counter.id(), clientId);
        this.countersManager.setCounterRegistrationId(counter.id(), correlationId);
        this.counterLinks.add(new CounterLink(counter, correlationId, client));
        this.clientProxy.onCounterReady(correlationId, counter.id());
    }

    void onRemoveCounter(long registrationId, long correlationId) {
        CounterLink counterLink = null;
        ArrayList<CounterLink> counterLinks = this.counterLinks;
        int size = counterLinks.size();
        for (int i = 0; i < size; ++i) {
            CounterLink link = counterLinks.get(i);
            if (registrationId != link.registrationId()) continue;
            counterLink = link;
            ArrayListUtil.fastUnorderedRemove(counterLinks, (int)i);
            break;
        }
        if (null == counterLink) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_COUNTER, "unknown counter: " + registrationId);
        }
        this.clientProxy.operationSucceeded(correlationId);
        this.clientProxy.onUnavailableCounter(registrationId, counterLink.counterId());
        counterLink.close();
    }

    void onClientClose(long clientId) {
        AeronClient client = DriverConductor.findClient(this.clients, clientId);
        if (null != client) {
            client.onClosedByCommand();
        }
    }

    void onAddRcvDestination(long registrationId, String destinationChannel, long correlationId) {
        if (destinationChannel.startsWith("aeron:ipc")) {
            this.onAddRcvIpcDestination(registrationId, destinationChannel, correlationId);
        } else if (destinationChannel.startsWith("aeron-spy")) {
            this.onAddRcvSpyDestination(registrationId, destinationChannel, correlationId);
        } else {
            this.onAddRcvNetworkDestination(registrationId, destinationChannel, correlationId);
        }
    }

    void onAddRcvIpcDestination(long registrationId, String destinationChannel, long correlationId) {
        SubscriptionParams params = SubscriptionParams.getSubscriptionParams(ChannelUri.parse((CharSequence)destinationChannel), this.ctx);
        SubscriptionLink mdsSubscriptionLink = DriverConductor.findMdsSubscriptionLink(this.subscriptionLinks, registrationId);
        if (null == mdsSubscriptionLink) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_SUBSCRIPTION, "unknown MDS subscription: " + registrationId);
        }
        IpcSubscriptionLink subscriptionLink = new IpcSubscriptionLink(registrationId, mdsSubscriptionLink.streamId(), destinationChannel, mdsSubscriptionLink.aeronClient(), params);
        this.subscriptionLinks.add(subscriptionLink);
        this.clientProxy.operationSucceeded(correlationId);
        int size = this.ipcPublications.size();
        for (int i = 0; i < size; ++i) {
            IpcPublication publication = this.ipcPublications.get(i);
            if (!subscriptionLink.matches(publication) || !publication.isAcceptingSubscriptions()) continue;
            this.clientProxy.onAvailableImage(publication.registrationId(), mdsSubscriptionLink.streamId(), publication.sessionId(), registrationId, this.linkIpcSubscription(publication, subscriptionLink).id(), publication.rawLog().fileName(), "aeron:ipc");
        }
    }

    void onAddRcvSpyDestination(long registrationId, String destinationChannel, long correlationId) {
        UdpChannel udpChannel = UdpChannel.parse(destinationChannel, this.nameResolver);
        SubscriptionParams params = SubscriptionParams.getSubscriptionParams(udpChannel.channelUri(), this.ctx);
        SubscriptionLink mdsSubscriptionLink = DriverConductor.findMdsSubscriptionLink(this.subscriptionLinks, registrationId);
        if (null == mdsSubscriptionLink) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_SUBSCRIPTION, "unknown MDS subscription: " + registrationId);
        }
        SpySubscriptionLink subscriptionLink = new SpySubscriptionLink(registrationId, udpChannel, mdsSubscriptionLink.streamId(), mdsSubscriptionLink.aeronClient(), params);
        this.subscriptionLinks.add(subscriptionLink);
        this.clientProxy.operationSucceeded(correlationId);
        int size = this.networkPublications.size();
        for (int i = 0; i < size; ++i) {
            NetworkPublication publication = this.networkPublications.get(i);
            if (!subscriptionLink.matches(publication) || !publication.isAcceptingSubscriptions()) continue;
            this.clientProxy.onAvailableImage(publication.registrationId(), mdsSubscriptionLink.streamId(), publication.sessionId(), registrationId, this.linkSpy(publication, subscriptionLink).id(), publication.rawLog().fileName(), "aeron:ipc");
        }
    }

    void onAddRcvNetworkDestination(long registrationId, String destinationChannel, long correlationId) {
        UdpChannel udpChannel = UdpChannel.parse(destinationChannel, this.nameResolver, true);
        DriverConductor.validateDestinationUri(udpChannel.channelUri(), destinationChannel);
        SubscriptionLink mdsSubscriptionLink = DriverConductor.findMdsSubscriptionLink(this.subscriptionLinks, registrationId);
        if (null == mdsSubscriptionLink) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_SUBSCRIPTION, "unknown MDS subscription: " + registrationId);
        }
        ReceiveChannelEndpoint receiveChannelEndpoint = mdsSubscriptionLink.channelEndpoint();
        AtomicCounter localSocketAddressIndicator = ReceiveLocalSocketAddress.allocate(this.tempBuffer, this.countersManager, registrationId, receiveChannelEndpoint.statusIndicatorCounter().id());
        ReceiveDestinationTransport transport = new ReceiveDestinationTransport(udpChannel, this.ctx, localSocketAddressIndicator, receiveChannelEndpoint);
        this.receiverProxy.addDestination(receiveChannelEndpoint, transport);
        this.clientProxy.operationSucceeded(correlationId);
    }

    void onRemoveRcvDestination(long registrationId, String destinationChannel, long correlationId) {
        if (destinationChannel.startsWith("aeron:ipc") || destinationChannel.startsWith("aeron-spy")) {
            this.onRemoveRcvIpcOrSpyDestination(registrationId, destinationChannel, correlationId);
        } else {
            this.onRemoveRcvNetworkDestination(registrationId, destinationChannel, correlationId);
        }
    }

    void onRemoveRcvIpcOrSpyDestination(long registrationId, String destinationChannel, long correlationId) {
        SubscriptionLink subscription = DriverConductor.removeSubscriptionLink(this.subscriptionLinks, registrationId, destinationChannel);
        if (null == subscription) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_SUBSCRIPTION, "unknown subscription: " + registrationId);
        }
        subscription.close();
        this.cleanupSubscriptionLink(subscription);
        this.clientProxy.operationSucceeded(correlationId);
        subscription.notifyUnavailableImages(this);
    }

    void onRemoveRcvNetworkDestination(long registrationId, String destinationChannel, long correlationId) {
        ReceiveChannelEndpoint receiveChannelEndpoint = null;
        int size = this.subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            SubscriptionLink subscriptionLink = this.subscriptionLinks.get(i);
            if (registrationId != subscriptionLink.registrationId()) continue;
            receiveChannelEndpoint = subscriptionLink.channelEndpoint();
            break;
        }
        if (null == receiveChannelEndpoint) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_SUBSCRIPTION, "unknown subscription: " + registrationId);
        }
        receiveChannelEndpoint.validateAllowsDestinationControl();
        this.receiverProxy.removeDestination(receiveChannelEndpoint, UdpChannel.parse(destinationChannel, this.nameResolver, true));
        this.clientProxy.operationSucceeded(correlationId);
    }

    void onTerminateDriver(DirectBuffer tokenBuffer, int tokenOffset, int tokenLength) {
        if (this.ctx.terminationValidator().allowTermination(this.ctx.aeronDirectory(), tokenBuffer, tokenOffset, tokenLength)) {
            this.ctx.terminationHook().run();
        }
    }

    private void heartbeatAndCheckTimers(long nowNs) {
        long nowMs = this.cachedEpochClock.time();
        this.toDriverCommands.consumerHeartbeatTime(nowMs);
        this.checkManagedResources(this.clients, nowNs, nowMs);
        this.checkManagedResources(this.publicationLinks, nowNs, nowMs);
        this.checkManagedResources(this.networkPublications, nowNs, nowMs);
        this.checkManagedResources(this.subscriptionLinks, nowNs, nowMs);
        this.checkManagedResources(this.publicationImages, nowNs, nowMs);
        this.checkManagedResources(this.ipcPublications, nowNs, nowMs);
        this.checkManagedResources(this.counterLinks, nowNs, nowMs);
    }

    private void checkForBlockedToDriverCommands(long nowNs) {
        long consumerPosition = this.toDriverCommands.consumerPosition();
        if (consumerPosition == this.lastConsumerCommandPosition) {
            if (this.toDriverCommands.producerPosition() > consumerPosition && this.timeOfLastToDriverPositionChangeNs + this.clientLivenessTimeoutNs - nowNs < 0L && this.toDriverCommands.unblock()) {
                this.ctx.systemCounters().get(SystemCounterDescriptor.UNBLOCKED_COMMANDS).incrementOrdered();
            }
        } else {
            this.timeOfLastToDriverPositionChangeNs = nowNs;
            this.lastConsumerCommandPosition = consumerPosition;
        }
    }

    private ArrayList<SubscriberPosition> createSubscriberPositions(int sessionId, int streamId, ReceiveChannelEndpoint channelEndpoint, long joinPosition) {
        ArrayList<SubscriberPosition> subscriberPositions = new ArrayList<SubscriberPosition>();
        int size = this.subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            SubscriptionLink subscription = this.subscriptionLinks.get(i);
            if (!subscription.matches(channelEndpoint, streamId, sessionId)) continue;
            UnsafeBufferPosition position = SubscriberPos.allocate(this.tempBuffer, this.countersManager, subscription.aeronClient().clientId(), subscription.registrationId(), sessionId, streamId, subscription.channel(), joinPosition);
            position.setOrdered(joinPosition);
            subscriberPositions.add(new SubscriberPosition(subscription, null, (Position)position));
        }
        return subscriberPositions;
    }

    private static NetworkPublication findPublication(ArrayList<NetworkPublication> publications, int streamId, SendChannelEndpoint channelEndpoint) {
        int size = publications.size();
        for (int i = 0; i < size; ++i) {
            NetworkPublication publication = publications.get(i);
            if (streamId != publication.streamId() || channelEndpoint != publication.channelEndpoint() || NetworkPublication.State.ACTIVE != publication.state() || publication.isExclusive()) continue;
            return publication;
        }
        return null;
    }

    private NetworkPublication newNetworkPublication(long registrationId, long clientId, int streamId, String channel, UdpChannel udpChannel, SendChannelEndpoint channelEndpoint, PublicationParams params, boolean isExclusive) {
        String canonicalForm = udpChannel.canonicalForm();
        int sessionId = params.hasSessionId ? params.sessionId : this.nextAvailableSessionId(streamId, canonicalForm);
        int initialTermId = params.hasPosition ? params.initialTermId : BitUtil.generateRandomisedId();
        FlowControl flowControl = udpChannel.isMulticast() || udpChannel.isMultiDestination() ? this.ctx.multicastFlowControlSupplier().newInstance(udpChannel, streamId, registrationId) : this.ctx.unicastFlowControlSupplier().newInstance(udpChannel, streamId, registrationId);
        flowControl.initialize(this.ctx, udpChannel, initialTermId, params.termLength);
        RawLog rawLog = this.newNetworkPublicationLog(sessionId, streamId, initialTermId, registrationId, params);
        UnsafeBufferPosition publisherPos = null;
        UnsafeBufferPosition publisherLmt = null;
        UnsafeBufferPosition senderPos = null;
        UnsafeBufferPosition senderLmt = null;
        AtomicCounter senderBpe = null;
        try {
            publisherPos = PublisherPos.allocate(this.tempBuffer, this.countersManager, registrationId, sessionId, streamId, channel);
            publisherLmt = PublisherLimit.allocate(this.tempBuffer, this.countersManager, registrationId, sessionId, streamId, channel);
            senderPos = SenderPos.allocate(this.tempBuffer, this.countersManager, registrationId, sessionId, streamId, channel);
            senderLmt = SenderLimit.allocate(this.tempBuffer, this.countersManager, registrationId, sessionId, streamId, channel);
            senderBpe = SenderBpe.allocate(this.tempBuffer, this.countersManager, registrationId, sessionId, streamId, channel);
            this.countersManager.setCounterOwnerId(publisherLmt.id(), clientId);
            if (params.hasPosition) {
                int bits = LogBufferDescriptor.positionBitsToShift((int)params.termLength);
                long position = LogBufferDescriptor.computePosition((int)params.termId, (int)params.termOffset, (int)bits, (int)initialTermId);
                publisherPos.setOrdered(position);
                publisherLmt.setOrdered(position);
                senderPos.setOrdered(position);
                senderLmt.setOrdered(position);
            }
            RetransmitHandler retransmitHandler = new RetransmitHandler((NanoClock)this.ctx.senderCachedNanoClock(), this.ctx.systemCounters().get(SystemCounterDescriptor.INVALID_PACKETS), this.ctx.retransmitUnicastDelayGenerator(), this.ctx.retransmitUnicastLingerGenerator());
            NetworkPublication publication = new NetworkPublication(registrationId, this.ctx, params, channelEndpoint, rawLog, Configuration.producerWindowLength(params.termLength, this.ctx.publicationTermWindowLength()), (Position)publisherPos, (Position)publisherLmt, (Position)senderPos, (Position)senderLmt, senderBpe, sessionId, streamId, initialTermId, flowControl, retransmitHandler, this.networkPublicationThreadLocals, isExclusive);
            channelEndpoint.incRef();
            this.networkPublications.add(publication);
            this.senderProxy.newNetworkPublication(publication);
            this.activeSessionSet.add((Object)new SessionKey(sessionId, streamId, canonicalForm));
            return publication;
        }
        catch (Exception ex) {
            CloseHelper.quietCloseAll((AutoCloseable[])new AutoCloseable[]{rawLog, publisherPos, publisherLmt, senderPos, senderLmt, senderBpe});
            throw ex;
        }
    }

    private RawLog newNetworkPublicationLog(int sessionId, int streamId, int initialTermId, long registrationId, PublicationParams params) {
        RawLog rawLog = this.logFactory.newPublication(registrationId, params.termLength, params.isSparse);
        this.initLogMetadata(sessionId, streamId, initialTermId, params.mtuLength, registrationId, rawLog);
        DriverConductor.initialisePositionCounters(initialTermId, params, rawLog.metaData());
        return rawLog;
    }

    private RawLog newIpcPublicationLog(int sessionId, int streamId, int initialTermId, long registrationId, PublicationParams params) {
        RawLog rawLog = this.logFactory.newPublication(registrationId, params.termLength, params.isSparse);
        this.initLogMetadata(sessionId, streamId, initialTermId, params.mtuLength, registrationId, rawLog);
        DriverConductor.initialisePositionCounters(initialTermId, params, rawLog.metaData());
        return rawLog;
    }

    private void initLogMetadata(int sessionId, int streamId, int initialTermId, int mtuLength, long registrationId, RawLog rawLog) {
        UnsafeBuffer logMetaData = rawLog.metaData();
        this.defaultDataHeader.sessionId(sessionId).streamId(streamId).termId(initialTermId);
        LogBufferDescriptor.storeDefaultFrameHeader((UnsafeBuffer)logMetaData, (DirectBuffer)this.defaultDataHeader);
        LogBufferDescriptor.initialTermId((UnsafeBuffer)logMetaData, (int)initialTermId);
        LogBufferDescriptor.mtuLength((UnsafeBuffer)logMetaData, (int)mtuLength);
        LogBufferDescriptor.termLength((UnsafeBuffer)logMetaData, (int)rawLog.termLength());
        LogBufferDescriptor.pageSize((UnsafeBuffer)logMetaData, (int)this.ctx.filePageSize());
        LogBufferDescriptor.correlationId((UnsafeBuffer)logMetaData, (long)registrationId);
        LogBufferDescriptor.endOfStreamPosition((UnsafeBuffer)logMetaData, (long)Long.MAX_VALUE);
    }

    private static void initialisePositionCounters(int initialTermId, PublicationParams params, UnsafeBuffer logMetaData) {
        if (params.hasPosition) {
            int termId = params.termId;
            int termCount = termId - initialTermId;
            int activeIndex = LogBufferDescriptor.indexByTerm((int)initialTermId, (int)termId);
            LogBufferDescriptor.rawTail((UnsafeBuffer)logMetaData, (int)activeIndex, (long)LogBufferDescriptor.packTail((int)termId, (int)params.termOffset));
            for (int i = 1; i < 3; ++i) {
                int expectedTermId = termId + i - 3;
                activeIndex = LogBufferDescriptor.nextPartitionIndex((int)activeIndex);
                LogBufferDescriptor.initialiseTailWithTermId((UnsafeBuffer)logMetaData, (int)activeIndex, (int)expectedTermId);
            }
            LogBufferDescriptor.activeTermCount((UnsafeBuffer)logMetaData, (int)termCount);
        } else {
            LogBufferDescriptor.initialiseTailWithTermId((UnsafeBuffer)logMetaData, (int)0, (int)initialTermId);
            for (int i = 1; i < 3; ++i) {
                int expectedTermId = initialTermId + i - 3;
                LogBufferDescriptor.initialiseTailWithTermId((UnsafeBuffer)logMetaData, (int)i, (int)expectedTermId);
            }
        }
    }

    private RawLog newPublicationImageLog(int sessionId, int streamId, int initialTermId, int termBufferLength, boolean isSparse, int senderMtuLength, long correlationId) {
        RawLog rawLog = this.logFactory.newImage(correlationId, termBufferLength, isSparse);
        this.initLogMetadata(sessionId, streamId, initialTermId, senderMtuLength, correlationId, rawLog);
        return rawLog;
    }

    private SendChannelEndpoint getOrCreateSendChannelEndpoint(PublicationParams params, UdpChannel udpChannel, long registrationId) {
        SendChannelEndpoint channelEndpoint = this.findExistingSendChannelEndpoint(udpChannel);
        if (null == channelEndpoint) {
            AtomicCounter statusIndicator = null;
            AtomicCounter localSocketAddressIndicator = null;
            try {
                statusIndicator = SendChannelStatus.allocate(this.tempBuffer, this.countersManager, registrationId, udpChannel.originalUriString());
                channelEndpoint = this.ctx.sendChannelEndpointSupplier().newInstance(udpChannel, statusIndicator, this.ctx);
                localSocketAddressIndicator = SendLocalSocketAddress.allocate(this.tempBuffer, this.countersManager, registrationId, channelEndpoint.statusIndicatorCounterId());
                channelEndpoint.localSocketAddressIndicator(localSocketAddressIndicator);
                PublicationParams.validateMtuForSndbuf(params, channelEndpoint.socketSndbufLength(), this.ctx, udpChannel.originalUriString(), null);
                this.sendChannelEndpointByChannelMap.put((Object)udpChannel.canonicalForm(), (Object)channelEndpoint);
                this.senderProxy.registerSendChannelEndpoint(channelEndpoint);
            }
            catch (Exception ex) {
                CloseHelper.closeAll((AutoCloseable[])new AutoCloseable[]{statusIndicator, localSocketAddressIndicator, channelEndpoint});
                throw ex;
            }
        } else {
            this.validateChannelSendTimestampOffset(udpChannel, channelEndpoint);
            PublicationParams.validateMtuForSndbuf(params, channelEndpoint.socketSndbufLength(), this.ctx, udpChannel.originalUriString(), channelEndpoint.originalUriString());
            DriverConductor.validateChannelBufferLength("so-rcvbuf", udpChannel.socketRcvbufLength(), channelEndpoint.socketRcvbufLength(), udpChannel.originalUriString(), channelEndpoint.originalUriString());
            DriverConductor.validateChannelBufferLength("so-sndbuf", udpChannel.socketSndbufLength(), channelEndpoint.socketSndbufLength(), udpChannel.originalUriString(), channelEndpoint.originalUriString());
        }
        return channelEndpoint;
    }

    private void validateChannelSendTimestampOffset(UdpChannel udpChannel, SendChannelEndpoint channelEndpoint) {
        if (udpChannel.channelSendTimestampOffset() != channelEndpoint.udpChannel().channelSendTimestampOffset()) {
            throw new InvalidChannelException("option conflicts with existing subscription: channel-snd-ts-offset=" + udpChannel.channelSendTimestampOffset() + " existingChannel=" + channelEndpoint.originalUriString() + " channel=" + udpChannel.originalUriString());
        }
    }

    private void validateReceiveTimestampOffset(UdpChannel udpChannel, ReceiveChannelEndpoint channelEndpoint) {
        if (udpChannel.channelReceiveTimestampOffset() != channelEndpoint.udpChannel().channelReceiveTimestampOffset()) {
            throw new InvalidChannelException("option conflicts with existing subscription: channel-rcv-ts-offset=" + udpChannel.channelReceiveTimestampOffset() + " existingChannel=" + channelEndpoint.originalUriString() + " channel=" + udpChannel.originalUriString());
        }
    }

    private SendChannelEndpoint findExistingSendChannelEndpoint(UdpChannel udpChannel) {
        SendChannelEndpoint endpoint;
        if (udpChannel.hasTag()) {
            for (SendChannelEndpoint endpoint2 : this.sendChannelEndpointByChannelMap.values()) {
                UdpChannel endpointUdpChannel = endpoint2.udpChannel();
                if (!endpointUdpChannel.matchesTag(udpChannel)) continue;
                return endpoint2;
            }
            if (!(udpChannel.hasExplicitControl() || udpChannel.isManualControlMode() || udpChannel.channelUri().containsKey("endpoint"))) {
                throw new InvalidChannelException("URI must have explicit control, endpoint, or be manual control-mode when original: channel=" + udpChannel.originalUriString());
            }
        }
        if (null != (endpoint = (SendChannelEndpoint)this.sendChannelEndpointByChannelMap.get((Object)udpChannel.canonicalForm())) && endpoint.udpChannel().hasTag() && udpChannel.hasTag() && endpoint.udpChannel().tag() != udpChannel.tag()) {
            endpoint = null;
        }
        return endpoint;
    }

    private void checkForClashingSubscription(SubscriptionParams params, UdpChannel udpChannel, int streamId) {
        ReceiveChannelEndpoint channelEndpoint = this.findExistingReceiveChannelEndpoint(udpChannel);
        if (null != channelEndpoint) {
            this.validateReceiveTimestampOffset(udpChannel, channelEndpoint);
            int size = this.subscriptionLinks.size();
            for (int i = 0; i < size; ++i) {
                boolean matchesTag;
                SubscriptionLink subscription = this.subscriptionLinks.get(i);
                boolean bl = matchesTag = !udpChannel.hasTag() || channelEndpoint.matchesTag(udpChannel);
                if (!matchesTag || !subscription.matches(channelEndpoint, streamId, params)) continue;
                if (params.isReliable != subscription.isReliable()) {
                    throw new InvalidChannelException("option conflicts with existing subscription: reliable=" + params.isReliable + " existingChannel=" + subscription.channel() + " channel=" + udpChannel.originalUriString());
                }
                if (params.isRejoin == subscription.isRejoin()) continue;
                throw new InvalidChannelException("option conflicts with existing subscription: rejoin=" + params.isRejoin + " existingChannel=" + subscription.channel() + " channel=" + udpChannel.originalUriString());
            }
        }
    }

    private void linkMatchingImages(SubscriptionLink subscriptionLink) {
        int size = this.publicationImages.size();
        for (int i = 0; i < size; ++i) {
            PublicationImage image = this.publicationImages.get(i);
            if (!subscriptionLink.matches(image) || !image.isAcceptingSubscriptions()) continue;
            long registrationId = subscriptionLink.registrationId();
            long joinPosition = image.joinPosition();
            int sessionId = image.sessionId();
            int streamId = subscriptionLink.streamId();
            UnsafeBufferPosition position = SubscriberPos.allocate(this.tempBuffer, this.countersManager, subscriptionLink.aeronClient().clientId(), registrationId, sessionId, streamId, subscriptionLink.channel(), joinPosition);
            position.setOrdered(joinPosition);
            subscriptionLink.link(image, (ReadablePosition)position);
            image.addSubscriber(subscriptionLink, (ReadablePosition)position, this.cachedNanoClock.nanoTime());
            this.clientProxy.onAvailableImage(image.correlationId(), streamId, sessionId, registrationId, position.id(), image.rawLog().fileName(), Configuration.sourceIdentity(image.sourceAddress()));
        }
    }

    private void linkIpcSubscriptions(IpcPublication publication) {
        int size = this.subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            SubscriptionLink subscription = this.subscriptionLinks.get(i);
            if (!subscription.matches(publication) || subscription.isLinked(publication)) continue;
            this.clientProxy.onAvailableImage(publication.registrationId(), publication.streamId(), publication.sessionId(), subscription.registrationId, this.linkIpcSubscription(publication, subscription).id(), publication.rawLog().fileName(), "aeron:ipc");
        }
    }

    private Position linkIpcSubscription(IpcPublication publication, SubscriptionLink subscription) {
        long joinPosition = publication.joinPosition();
        long registrationId = subscription.registrationId();
        long clientId = subscription.aeronClient().clientId();
        int sessionId = publication.sessionId();
        int streamId = subscription.streamId();
        String channel = subscription.channel();
        UnsafeBufferPosition position = SubscriberPos.allocate(this.tempBuffer, this.countersManager, clientId, registrationId, sessionId, streamId, channel, joinPosition);
        position.setOrdered(joinPosition);
        subscription.link(publication, (ReadablePosition)position);
        publication.addSubscriber(subscription, (ReadablePosition)position, this.cachedNanoClock.nanoTime());
        return position;
    }

    private Position linkSpy(NetworkPublication publication, SubscriptionLink subscription) {
        long joinPosition = publication.consumerPosition();
        long registrationId = subscription.registrationId();
        long clientId = subscription.aeronClient().clientId();
        int streamId = publication.streamId();
        int sessionId = publication.sessionId();
        String channel = subscription.channel();
        UnsafeBufferPosition position = SubscriberPos.allocate(this.tempBuffer, this.countersManager, clientId, registrationId, sessionId, streamId, channel, joinPosition);
        position.setOrdered(joinPosition);
        subscription.link(publication, (ReadablePosition)position);
        publication.addSubscriber(subscription, (ReadablePosition)position, this.cachedNanoClock.nanoTime());
        return position;
    }

    private ReceiveChannelEndpoint getOrCreateReceiveChannelEndpoint(SubscriptionParams params, UdpChannel udpChannel, long registrationId) {
        ReceiveChannelEndpoint channelEndpoint = this.findExistingReceiveChannelEndpoint(udpChannel);
        if (null == channelEndpoint) {
            AtomicCounter channelStatus = null;
            AtomicCounter localSocketAddressIndicator = null;
            try {
                String channel = udpChannel.originalUriString();
                channelStatus = ReceiveChannelStatus.allocate(this.tempBuffer, this.countersManager, registrationId, channel);
                DataPacketDispatcher dispatcher = new DataPacketDispatcher(this.ctx.driverConductorProxy(), this.receiverProxy.receiver());
                channelEndpoint = this.ctx.receiveChannelEndpointSupplier().newInstance(udpChannel, dispatcher, channelStatus, this.ctx);
                if (!udpChannel.isManualControlMode()) {
                    localSocketAddressIndicator = ReceiveLocalSocketAddress.allocate(this.tempBuffer, this.countersManager, registrationId, channelEndpoint.statusIndicatorCounter().id());
                    channelEndpoint.localSocketAddressIndicator(localSocketAddressIndicator);
                }
                SubscriptionParams.validateInitialWindowForRcvBuf(params, channel, channelEndpoint.socketRcvbufLength(), this.ctx, null);
                this.receiveChannelEndpointByChannelMap.put((Object)udpChannel.canonicalForm(), (Object)channelEndpoint);
                this.receiverProxy.registerReceiveChannelEndpoint(channelEndpoint);
            }
            catch (Exception ex) {
                CloseHelper.closeAll((AutoCloseable[])new AutoCloseable[]{channelStatus, localSocketAddressIndicator, channelEndpoint});
                throw ex;
            }
        } else {
            SubscriptionParams.validateInitialWindowForRcvBuf(params, udpChannel.originalUriString(), channelEndpoint.socketRcvbufLength(), this.ctx, channelEndpoint.originalUriString());
            DriverConductor.validateChannelBufferLength("so-rcvbuf", udpChannel.socketRcvbufLength(), channelEndpoint.socketRcvbufLength(), udpChannel.originalUriString(), channelEndpoint.originalUriString());
            DriverConductor.validateChannelBufferLength("so-sndbuf", udpChannel.socketSndbufLength(), channelEndpoint.socketSndbufLength(), udpChannel.originalUriString(), channelEndpoint.originalUriString());
        }
        return channelEndpoint;
    }

    private ReceiveChannelEndpoint findExistingReceiveChannelEndpoint(UdpChannel udpChannel) {
        ReceiveChannelEndpoint endpoint;
        if (udpChannel.hasTag()) {
            for (ReceiveChannelEndpoint endpoint2 : this.receiveChannelEndpointByChannelMap.values()) {
                if (!endpoint2.matchesTag(udpChannel)) continue;
                return endpoint2;
            }
        }
        if (null != (endpoint = (ReceiveChannelEndpoint)this.receiveChannelEndpointByChannelMap.get((Object)udpChannel.canonicalForm())) && endpoint.hasTag() && udpChannel.hasTag() && endpoint.tag() != udpChannel.tag()) {
            endpoint = null;
        }
        return endpoint;
    }

    private AeronClient getOrAddClient(long clientId) {
        AeronClient client = DriverConductor.findClient(this.clients, clientId);
        if (null == client) {
            AtomicCounter counter = ClientHeartbeatTimestamp.allocate(this.tempBuffer, this.countersManager, clientId);
            int counterId = counter.id();
            counter.setOrdered(this.cachedEpochClock.time());
            this.countersManager.setCounterOwnerId(counterId, clientId);
            this.countersManager.setCounterRegistrationId(counterId, clientId);
            client = new AeronClient(clientId, this.clientLivenessTimeoutNs, this.ctx.systemCounters().get(SystemCounterDescriptor.CLIENT_TIMEOUTS), counter);
            this.clients.add(client);
            this.clientProxy.onCounterReady(clientId, counterId);
        }
        return client;
    }

    private IpcPublication addIpcPublication(long registrationId, long clientId, int streamId, String channel, boolean isExclusive, PublicationParams params) {
        int sessionId = params.hasSessionId ? params.sessionId : this.nextAvailableSessionId(streamId, "ipc");
        int initialTermId = params.hasPosition ? params.initialTermId : BitUtil.generateRandomisedId();
        RawLog rawLog = this.newIpcPublicationLog(sessionId, streamId, initialTermId, registrationId, params);
        UnsafeBufferPosition publisherPosition = null;
        UnsafeBufferPosition publisherLimit = null;
        try {
            publisherPosition = PublisherPos.allocate(this.tempBuffer, this.countersManager, registrationId, sessionId, streamId, channel);
            publisherLimit = PublisherLimit.allocate(this.tempBuffer, this.countersManager, registrationId, sessionId, streamId, channel);
            this.countersManager.setCounterOwnerId(publisherLimit.id(), clientId);
            if (params.hasPosition) {
                int positionBitsToShift = LogBufferDescriptor.positionBitsToShift((int)params.termLength);
                long position = LogBufferDescriptor.computePosition((int)params.termId, (int)params.termOffset, (int)positionBitsToShift, (int)initialTermId);
                publisherPosition.setOrdered(position);
                publisherLimit.setOrdered(position);
            }
            IpcPublication publication = new IpcPublication(registrationId, channel, this.ctx, params.entityTag, sessionId, streamId, (Position)publisherPosition, (Position)publisherLimit, rawLog, Configuration.producerWindowLength(params.termLength, this.ctx.ipcPublicationTermWindowLength()), isExclusive, params);
            this.ipcPublications.add(publication);
            this.activeSessionSet.add((Object)new SessionKey(sessionId, streamId, "ipc"));
            return publication;
        }
        catch (Exception ex) {
            CloseHelper.quietCloseAll((AutoCloseable[])new AutoCloseable[]{rawLog, publisherPosition, publisherLimit});
            throw ex;
        }
    }

    private static AeronClient findClient(ArrayList<AeronClient> clients, long clientId) {
        AeronClient aeronClient = null;
        int size = clients.size();
        for (int i = 0; i < size; ++i) {
            AeronClient client = clients.get(i);
            if (client.clientId() != clientId) continue;
            aeronClient = client;
            break;
        }
        return aeronClient;
    }

    private static SubscriptionLink findMdsSubscriptionLink(ArrayList<SubscriptionLink> subscriptionLinks, long registrationId) {
        SubscriptionLink subscriptionLink = null;
        int size = subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            SubscriptionLink subscription = subscriptionLinks.get(i);
            if (subscription.registrationId() != registrationId || !subscription.supportsMds()) continue;
            subscriptionLink = subscription;
            break;
        }
        return subscriptionLink;
    }

    private static SubscriptionLink removeSubscriptionLink(ArrayList<SubscriptionLink> subscriptionLinks, long registrationId, String channel) {
        SubscriptionLink subscriptionLink = null;
        int size = subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            SubscriptionLink subscription = subscriptionLinks.get(i);
            if (subscription.registrationId() != registrationId || !subscription.channel().equals(channel)) continue;
            subscriptionLink = subscription;
            ArrayListUtil.fastUnorderedRemove(subscriptionLinks, (int)i);
            break;
        }
        return subscriptionLink;
    }

    private static IpcPublication findSharedIpcPublication(ArrayList<IpcPublication> ipcPublications, long streamId) {
        IpcPublication ipcPublication = null;
        int size = ipcPublications.size();
        for (int i = 0; i < size; ++i) {
            IpcPublication publication = ipcPublications.get(i);
            if ((long)publication.streamId() != streamId || publication.isExclusive() || IpcPublication.State.ACTIVE != publication.state()) continue;
            ipcPublication = publication;
            break;
        }
        return ipcPublication;
    }

    private void checkForSessionClash(int sessionId, int streamId, String channel, String originalChannel) {
        if (this.activeSessionSet.contains((Object)new SessionKey(sessionId, streamId, channel))) {
            throw new InvalidChannelException("existing publication has clashing sessionId=" + sessionId + " for streamId=" + streamId + " channel=" + originalChannel);
        }
    }

    private int nextAvailableSessionId(int streamId, String channel) {
        int sessionId;
        SessionKey sessionKey = new SessionKey(streamId, channel);
        do {
            ++this.nextSessionId;
            if (this.ctx.publicationReservedSessionIdLow() <= sessionId && sessionId <= this.ctx.publicationReservedSessionIdHigh()) {
                this.nextSessionId = this.ctx.publicationReservedSessionIdHigh() + 1;
                sessionId = this.nextSessionId++;
            }
            sessionKey.sessionId = sessionId;
        } while (this.activeSessionSet.contains((Object)sessionKey));
        return sessionId;
    }

    private <T extends DriverManagedResource> void checkManagedResources(ArrayList<T> list, long nowNs, long nowMs) {
        int lastIndex;
        for (int i = lastIndex = list.size() - 1; i >= 0; --i) {
            DriverManagedResource resource = (DriverManagedResource)list.get(i);
            resource.onTimeEvent(nowNs, nowMs, this);
            if (!resource.hasReachedEndOfLife()) continue;
            if (resource.free()) {
                ArrayListUtil.fastUnorderedRemove(list, (int)i, (int)lastIndex--);
                CloseHelper.close((ErrorHandler)this.ctx.errorHandler(), (AutoCloseable)resource);
                continue;
            }
            this.ctx.systemCounters().get(SystemCounterDescriptor.FREE_FAILS).incrementOrdered();
        }
    }

    private void linkSpies(ArrayList<SubscriptionLink> links, NetworkPublication publication) {
        int size = links.size();
        for (int i = 0; i < size; ++i) {
            SubscriptionLink subscription = links.get(i);
            if (!subscription.matches(publication) || subscription.isLinked(publication)) continue;
            this.clientProxy.onAvailableImage(publication.registrationId(), publication.streamId(), publication.sessionId(), subscription.registrationId(), this.linkSpy(publication, subscription).id(), publication.rawLog().fileName(), "aeron:ipc");
        }
    }

    private void trackTime(long nowNs) {
        long cycleTimeNs = nowNs - this.cachedNanoClock.nanoTime();
        this.cachedNanoClock.update(nowNs);
        this.maxCycleTime.proposeMaxOrdered(cycleTimeNs);
        if (this.clockUpdateDeadlineNs - nowNs < 0L) {
            this.clockUpdateDeadlineNs = nowNs + CLOCK_UPDATE_INTERNAL_NS;
            this.cachedEpochClock.update(this.epochClock.time());
        }
        if (cycleTimeNs > this.ctx.conductorCycleThresholdNs()) {
            this.cycleTimeThresholdExceededCount.incrementOrdered();
        }
    }

    private int processTimers(long nowNs) {
        int workCount = 0;
        if (this.timerCheckDeadlineNs - nowNs < 0L) {
            this.timerCheckDeadlineNs = nowNs + this.timerIntervalNs;
            this.heartbeatAndCheckTimers(nowNs);
            this.checkForBlockedToDriverCommands(nowNs);
            workCount = 1;
        }
        return workCount;
    }

    private static boolean isOldestSubscriptionSparse(ArrayList<SubscriberPosition> subscriberPositions) {
        SubscriberPosition subscriberPosition = subscriberPositions.get(0);
        long regId = subscriberPosition.subscription().registrationId();
        boolean isSparse = subscriberPosition.subscription().isSparse();
        int size = subscriberPositions.size();
        for (int i = 1; i < size; ++i) {
            SubscriptionLink subscription = subscriberPositions.get(i).subscription();
            if (subscription.registrationId() >= regId) continue;
            isSparse = subscription.isSparse();
            regId = subscription.registrationId();
        }
        return isSparse;
    }

    private int trackStreamPositions(int existingWorkCount, long nowNs) {
        int workCount = existingWorkCount;
        ArrayList<PublicationImage> publicationImages = this.publicationImages;
        int size = publicationImages.size();
        for (int i = 0; i < size; ++i) {
            workCount += publicationImages.get(i).trackRebuild(nowNs);
        }
        ArrayList<NetworkPublication> networkPublications = this.networkPublications;
        int size2 = networkPublications.size();
        for (int i = 0; i < size2; ++i) {
            workCount += networkPublications.get(i).updatePublisherLimit();
        }
        ArrayList<IpcPublication> ipcPublications = this.ipcPublications;
        int size3 = ipcPublications.size();
        for (int i = 0; i < size3; ++i) {
            workCount += ipcPublications.get(i).updatePublisherLimit();
        }
        return workCount;
    }

    private static void validateChannelBufferLength(String paramName, int newLength, int existingLength, String channel, String existingChannel) {
        if (0 != newLength && newLength != existingLength) {
            Object existingValue = 0 == existingLength ? "OS default" : Integer.valueOf(existingLength);
            throw new InvalidChannelException(paramName + "=" + newLength + " does not match existing value of " + existingValue + ": existingChannel=" + existingChannel + " channel=" + channel);
        }
    }

    private static void validateEndpointForPublication(UdpChannel udpChannel) {
        if (!udpChannel.isManualControlMode() && !udpChannel.isDynamicControlMode() && udpChannel.hasExplicitEndpoint() && 0 == udpChannel.remoteData().getPort()) {
            throw new IllegalArgumentException("endpoint has port=0 for publication: channel=" + udpChannel.originalUriString());
        }
    }

    private static void validateControlForSubscription(UdpChannel udpChannel) {
        if (udpChannel.hasExplicitControl() && 0 == udpChannel.localControl().getPort()) {
            throw new IllegalArgumentException("control has port=0 for subscription: channel=" + udpChannel.originalUriString());
        }
    }

    private static void validateTimestampConfiguration(UdpChannel udpChannel) {
        if (null != udpChannel.channelUri().get("media-rcv-ts-offset")) {
            throw new InvalidChannelException("Media timestamps 'media-rcv-ts-offset' are not supported in the Java driver: channel=" + udpChannel.originalUriString());
        }
    }

    private static void validateDestinationUri(ChannelUri uri, String destinationUri) {
        if ("aeron-spy".equals(uri.prefix())) {
            throw new InvalidChannelException("Aeron spies are invalid as send destinations: channel=" + destinationUri);
        }
        for (String invalidKey : INVALID_DESTINATION_KEYS) {
            if (!uri.containsKey(invalidKey)) continue;
            throw new InvalidChannelException("destinations must not contain the key: " + invalidKey + " channel=" + destinationUri);
        }
    }

    private static void validateSendDestinationUri(ChannelUri uri, String destinationUri) {
        String endpoint = uri.get("endpoint");
        if (null != endpoint && endpoint.endsWith(":0")) {
            throw new InvalidChannelException("endpoint has port=0 for send destination: channel=" + destinationUri);
        }
    }
}

