/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.ChannelUri;
import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.NetworkPublication;
import io.aeron.driver.SenderRhsPadding;
import io.aeron.driver.media.ControlTransportPoller;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.driver.status.SystemCounterDescriptor;
import java.net.InetSocketAddress;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.CachedNanoClock;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.OneToOneConcurrentArrayQueue;
import org.agrona.concurrent.status.AtomicCounter;

public final class Sender
extends SenderRhsPadding
implements Agent {
    private NetworkPublication[] networkPublications = new NetworkPublication[0];
    private final long statusMessageReadTimeoutNs;
    private final long reResolutionCheckIntervalNs;
    private final int dutyCycleRatio;
    private final ControlTransportPoller controlTransportPoller;
    private final OneToOneConcurrentArrayQueue<Runnable> commandQueue;
    private final AtomicCounter totalBytesSent;
    private final AtomicCounter resolutionChanges;
    private final NanoClock nanoClock;
    private final CachedNanoClock cachedNanoClock;
    private final DriverConductorProxy conductorProxy;

    Sender(MediaDriver.Context ctx) {
        this.controlTransportPoller = ctx.controlTransportPoller();
        this.commandQueue = ctx.senderCommandQueue();
        this.totalBytesSent = ctx.systemCounters().get(SystemCounterDescriptor.BYTES_SENT);
        this.resolutionChanges = ctx.systemCounters().get(SystemCounterDescriptor.RESOLUTION_CHANGES);
        this.nanoClock = ctx.nanoClock();
        this.cachedNanoClock = ctx.senderCachedNanoClock();
        this.statusMessageReadTimeoutNs = ctx.statusMessageTimeoutNs() >> 1;
        this.reResolutionCheckIntervalNs = ctx.reResolutionCheckIntervalNs();
        this.dutyCycleRatio = ctx.sendToStatusMessagePollRatio();
        this.conductorProxy = ctx.driverConductorProxy();
    }

    public void onStart() {
        long nowNs = this.nanoClock.nanoTime();
        this.cachedNanoClock.update(nowNs);
        this.reResolutionDeadlineNs = nowNs + this.reResolutionCheckIntervalNs;
    }

    public void onClose() {
        this.controlTransportPoller.close();
    }

    public int doWork() {
        long nowNs = this.nanoClock.nanoTime();
        this.cachedNanoClock.update(nowNs);
        int workCount = this.commandQueue.drain(Runnable::run, 2);
        int bytesSent = this.doSend(nowNs);
        int bytesReceived = 0;
        if (0 == bytesSent || ++this.dutyCycleCounter >= this.dutyCycleRatio || this.controlPollDeadlineNs - nowNs < 0L) {
            bytesReceived = this.controlTransportPoller.pollTransports();
            this.dutyCycleCounter = 0;
            this.controlPollDeadlineNs = nowNs + this.statusMessageReadTimeoutNs;
        }
        if (this.reResolutionCheckIntervalNs > 0L && this.reResolutionDeadlineNs - nowNs < 0L) {
            this.reResolutionDeadlineNs = nowNs + this.reResolutionCheckIntervalNs;
            this.controlTransportPoller.checkForReResolutions(nowNs, this.conductorProxy);
        }
        return workCount + bytesSent + bytesReceived;
    }

    public String roleName() {
        return "sender";
    }

    void onRegisterSendChannelEndpoint(SendChannelEndpoint channelEndpoint) {
        channelEndpoint.openChannel(this.conductorProxy);
        channelEndpoint.registerForRead(this.controlTransportPoller);
        channelEndpoint.indicateActive();
    }

    void onCloseSendChannelEndpoint(SendChannelEndpoint channelEndpoint) {
        channelEndpoint.close();
    }

    void onNewNetworkPublication(NetworkPublication publication) {
        this.networkPublications = (NetworkPublication[])ArrayUtil.add((Object[])this.networkPublications, (Object)publication);
        publication.channelEndpoint().registerForSend(publication);
    }

    void onRemoveNetworkPublication(NetworkPublication publication) {
        this.networkPublications = (NetworkPublication[])ArrayUtil.remove((Object[])this.networkPublications, (Object)publication);
        publication.channelEndpoint().unregisterForSend(publication);
        publication.senderRelease();
    }

    void onAddDestination(SendChannelEndpoint channelEndpoint, ChannelUri channelUri, InetSocketAddress address) {
        channelEndpoint.addDestination(channelUri, address);
    }

    void onRemoveDestination(SendChannelEndpoint channelEndpoint, ChannelUri channelUri, InetSocketAddress address) {
        channelEndpoint.removeDestination(channelUri, address);
    }

    void onResolutionChange(SendChannelEndpoint channelEndpoint, String endpoint, InetSocketAddress newAddress) {
        channelEndpoint.resolutionChange(endpoint, newAddress);
        this.resolutionChanges.getAndAddOrdered(1L);
    }

    private int doSend(long nowNs) {
        int i;
        int startingIndex;
        int bytesSent = 0;
        NetworkPublication[] publications = this.networkPublications;
        int length = publications.length;
        if ((startingIndex = this.roundRobinIndex++) >= length) {
            startingIndex = 0;
            this.roundRobinIndex = 0;
        }
        for (i = startingIndex; i < length; ++i) {
            bytesSent += publications[i].send(nowNs);
        }
        for (i = 0; i < startingIndex; ++i) {
            bytesSent += publications[i].send(nowNs);
        }
        this.totalBytesSent.getAndAddOrdered((long)bytesSent);
        return bytesSent;
    }
}

