/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.FlowControl;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.media.UdpChannel;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.protocol.StatusMessageFlyweight;
import java.net.InetSocketAddress;

public class UnicastFlowControl
implements FlowControl {
    public static final UnicastFlowControl INSTANCE = new UnicastFlowControl();

    @Override
    public long onStatusMessage(StatusMessageFlyweight flyweight, InetSocketAddress receiverAddress, long senderLimit, int initialTermId, int positionBitsToShift, long timeNs) {
        long position = LogBufferDescriptor.computePosition((int)flyweight.consumptionTermId(), (int)flyweight.consumptionTermOffset(), (int)positionBitsToShift, (int)initialTermId);
        return Math.max(senderLimit, position + (long)flyweight.receiverWindowLength());
    }

    @Override
    public void initialize(MediaDriver.Context context, UdpChannel udpChannel, int initialTermId, int termBufferLength) {
    }

    @Override
    public long onIdle(long timeNs, long senderLimit, long senderPosition, boolean isEos) {
        return senderLimit;
    }

    @Override
    public boolean hasRequiredReceivers() {
        return true;
    }
}

