/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.clustering.it.karaf.cli;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.Optional;
import org.opendaylight.clustering.it.karaf.cli.InstanceIdentifierSupport;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTree;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingInstanceIdentifierCodec;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactorySupplier;
import org.opendaylight.yangtools.yang.data.util.codec.TypeAwareCodec;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeAware;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.RequireServiceComponentRuntime;

@Component
@RequireServiceComponentRuntime
public final class DefaultInstanceIdentifierSupport
implements InstanceIdentifierSupport {
    private final BindingInstanceIdentifierCodec bindingCodec;
    private final TypeAwareCodec<?, ?, ?> jsonCodec;

    @Activate
    public DefaultInstanceIdentifierSupport(@Reference BindingCodecTree bindingCodecTree, @Reference BindingRuntimeContext runtimeContext) {
        this.bindingCodec = bindingCodecTree.getInstanceIdentifierCodec();
        this.jsonCodec = JSONCodecFactorySupplier.RFC7951.createLazy(runtimeContext.getEffectiveModelContext()).codecFor((TypeAware)new FakeLeafDefinition(), null);
    }

    @Override
    public InstanceIdentifier<?> parseArgument(String argument) {
        YangInstanceIdentifier path = (YangInstanceIdentifier)Verify.verifyNotNull((Object)((YangInstanceIdentifier)this.jsonCodec.parseValue(null, argument)));
        InstanceIdentifier ret = this.bindingCodec.toBinding(path);
        Preconditions.checkArgument((ret != null ? 1 : 0) != 0, (String)"%s does not have a binding representation", (Object)path);
        return ret;
    }

    private static final class FakeLeafDefinition
    implements InstanceIdentifierTypeDefinition,
    TypeAware {
        private FakeLeafDefinition() {
        }

        public Optional<String> getReference() {
            throw new UnsupportedOperationException();
        }

        public Optional<String> getDescription() {
            throw new UnsupportedOperationException();
        }

        public Status getStatus() {
            throw new UnsupportedOperationException();
        }

        public QName getQName() {
            throw new UnsupportedOperationException();
        }

        public Optional<String> getUnits() {
            throw new UnsupportedOperationException();
        }

        public Optional<? extends Object> getDefaultValue() {
            throw new UnsupportedOperationException();
        }

        public InstanceIdentifierTypeDefinition getBaseType() {
            return null;
        }

        public boolean requireInstance() {
            return false;
        }

        public TypeDefinition<? extends TypeDefinition<?>> getType() {
            return this;
        }
    }
}

