/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.model.ietf.util.AbstractIetfInetUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.DomainName;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Host;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Prefix;

@Beta
public final class IetfInetUtil
extends AbstractIetfInetUtil<Ipv4Address, Ipv4AddressNoZone, Ipv4Prefix, Ipv6Address, Ipv6AddressNoZone, Ipv6Prefix, IpAddress, IpAddressNoZone, IpPrefix> {
    public static final @NonNull IetfInetUtil INSTANCE = new IetfInetUtil();
    private static final Pattern HOST_IPV4_PATTERN = Pattern.compile("(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(%[\\p{N}\\p{L}]+)?");
    private static final Pattern HOST_IPV6_PATTERN1 = Pattern.compile("((:|[0-9a-fA-F]{0,4}):)([0-9a-fA-F]{0,4}:){0,5}((([0-9a-fA-F]{0,4}:)?(:|[0-9a-fA-F]{0,4}))|(((25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])))(%[\\p{N}\\p{L}]+)?");
    private static final Pattern HOST_IPV6_PATTERN2 = Pattern.compile("(([^:]+:){6}(([^:]+:[^:]+)|(.*\\..*)))|((([^:]+:)*[^:]+)?::(([^:]+:)*[^:]+)?)(%.+)?");
    private static final Pattern HOST_DOMAIN_PATTERN = Pattern.compile("((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.");
    private static final Pattern IPADDRESS_IPV4_PATTERN;
    private static final Pattern IPADDRESS_NO_ZONE_IPV4_PATTERN;
    private static final Pattern IPADDRESS_NO_ZONE_IPV6_PATTERN;
    private static final Pattern IPPREFIX_IPV4_PATTERN;

    private IetfInetUtil() {
        super(Ipv4AddressNoZone.class, Ipv4Prefix.class, Ipv6AddressNoZone.class, Ipv6Prefix.class);
    }

    @Beta
    public static Host hostFor(String str) {
        Matcher ipv4Matcher = HOST_IPV4_PATTERN.matcher(str);
        Matcher ipv6Matcher1 = HOST_IPV6_PATTERN1.matcher(str);
        Matcher ipv6Matcher2 = HOST_IPV6_PATTERN2.matcher(str);
        Matcher domainMatcher = HOST_DOMAIN_PATTERN.matcher(str);
        ArrayList<String> matchers = new ArrayList<String>(3);
        if (ipv6Matcher1.matches() || ipv6Matcher2.matches()) {
            matchers.add(Ipv6Address.class.getSimpleName());
        }
        if (ipv4Matcher.matches()) {
            matchers.add(Ipv4Address.class.getSimpleName());
        } else if (domainMatcher.matches()) {
            matchers.add(DomainName.class.getSimpleName());
        }
        if (matchers.size() > 1) {
            throw new IllegalArgumentException("Cannot create Host from " + str + ". Value is ambigious for " + matchers);
        }
        if (ipv4Matcher.matches()) {
            Ipv4Address ipv4 = new Ipv4Address(str);
            IpAddress ipAddress = new IpAddress(ipv4);
            return new Host(ipAddress);
        }
        if (ipv6Matcher1.matches() || ipv6Matcher2.matches()) {
            Ipv6Address ipv6 = new Ipv6Address(str);
            IpAddress ipAddress = new IpAddress(ipv6);
            return new Host(ipAddress);
        }
        if (domainMatcher.matches()) {
            DomainName domainName = new DomainName(str);
            return new Host(domainName);
        }
        throw new IllegalArgumentException("Cannot create Host from " + str);
    }

    @Beta
    public static IpAddress ipAddressFor(String str) {
        return IPADDRESS_IPV4_PATTERN.matcher(str).matches() ? new IpAddress(new Ipv4Address(str)) : new IpAddress(new Ipv6Address(str));
    }

    @Beta
    public static IpAddressNoZone ipAddressNoZoneFor(String str) {
        if (IPADDRESS_NO_ZONE_IPV4_PATTERN.matcher(str).matches()) {
            return new IpAddressNoZone(new Ipv4AddressNoZone(str));
        }
        if (IPADDRESS_NO_ZONE_IPV6_PATTERN.matcher(str).matches()) {
            return new IpAddressNoZone(new Ipv6AddressNoZone(str));
        }
        throw new IllegalArgumentException("Cannot create IpAddress from " + str);
    }

    @Beta
    public static IpPrefix ipPrefixFor(String defaultValue) {
        return IPPREFIX_IPV4_PATTERN.matcher(defaultValue).matches() ? new IpPrefix(new Ipv4Prefix(defaultValue)) : new IpPrefix(new Ipv6Prefix(defaultValue));
    }

    protected IpAddress ipv4Address(Ipv4AddressNoZone addr) {
        return new IpAddress(addr);
    }

    protected IpAddressNoZone ipv4AddressNoZone(Ipv4AddressNoZone addr) {
        return new IpAddressNoZone(addr);
    }

    protected IpAddressNoZone ipv6AddressNoZone(Ipv6AddressNoZone addr) {
        return new IpAddressNoZone(addr);
    }

    protected IpAddress ipv6Address(Ipv6AddressNoZone addr) {
        return new IpAddress(addr);
    }

    protected IpPrefix ipv4Prefix(Ipv4Prefix addr) {
        return new IpPrefix(addr);
    }

    protected IpPrefix ipv6Prefix(Ipv6Prefix addr) {
        return new IpPrefix(addr);
    }

    protected String ipv4AddressString(Ipv4Address addr) {
        return addr.getValue();
    }

    protected String ipv6AddressString(Ipv6Address addr) {
        return addr.getValue();
    }

    protected String ipv4PrefixString(Ipv4Prefix prefix) {
        return prefix.getValue();
    }

    protected String ipv6PrefixString(Ipv6Prefix prefix) {
        return prefix.getValue();
    }

    protected Ipv4Address maybeIpv4Address(IpAddress addr) {
        return addr.getIpv4Address();
    }

    protected Ipv4AddressNoZone maybeIpv4AddressNoZone(IpAddressNoZone addr) {
        return addr.getIpv4AddressNoZone();
    }

    protected Ipv6Address maybeIpv6Address(IpAddress addr) {
        return addr.getIpv6Address();
    }

    protected Ipv6AddressNoZone maybeIpv6AddressNoZone(IpAddressNoZone addr) {
        return addr.getIpv6AddressNoZone();
    }

    static {
        Verify.verify((Ipv4Address.PATTERN_CONSTANTS.size() == 1 ? 1 : 0) != 0);
        IPADDRESS_IPV4_PATTERN = Pattern.compile(Ipv4Address.PATTERN_CONSTANTS.get(0));
        IPADDRESS_NO_ZONE_IPV4_PATTERN = Pattern.compile("[0-9\\.]*");
        IPADDRESS_NO_ZONE_IPV6_PATTERN = Pattern.compile("[0-9a-fA-F:\\.]*");
        Verify.verify((Ipv4Prefix.PATTERN_CONSTANTS.size() == 1 ? 1 : 0) != 0);
        IPPREFIX_IPV4_PATTERN = Pattern.compile(Ipv4Prefix.PATTERN_CONSTANTS.get(0));
    }
}

