/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.AugmentStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ConfigEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DeviationStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RefineStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.UsesStatement;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.spi.meta.CommonStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStatementState;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.ParserNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.RootStmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementFactory;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.EffectiveInstances;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.InferredStatementContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.NamespaceStorageSupport;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.ReplicaStatementContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.RootStatementContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementDefinitionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ReactorStmtCtx<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>>
extends NamespaceStorageSupport
implements StmtContext.Mutable<A, D, E>,
EffectiveStmtCtx.Current<A, D> {
    private static final Logger LOG = LoggerFactory.getLogger(ReactorStmtCtx.class);
    private int refcount = 0;
    private static final int REFCOUNT_NONE = 0;
    private static final int REFCOUNT_DEFUNCT = Integer.MAX_VALUE;
    private static final int REFCOUNT_SWEEPING = -2147483647;
    private static final int REFCOUNT_SWEPT = Integer.MIN_VALUE;
    private @Nullable Object effectiveInstance;
    private boolean isSupportedToBuildEffective = true;
    private static final int MASK_CONFIG = 3;
    private static final int HAVE_CONFIG = 4;
    private static final int ALL_INDEPENDENT = 8;
    private static final int IS_SUPPORTED_BY_FEATURES = 16;
    private static final int HAVE_SUPPORTED_BY_FEATURES = 32;
    private static final int IS_IGNORE_IF_FEATURE = 64;
    private static final int HAVE_IGNORE_IF_FEATURE = 128;
    private static final int SET_SUPPORTED_BY_FEATURES = 48;
    private static final int SET_IGNORE_IF_FEATURE = 192;
    private static final EffectiveStmtCtx.Parent.EffectiveConfig[] EFFECTIVE_CONFIGS;
    private byte flags;
    private byte parentRef = (byte)-1;
    private static final byte PARENTREF_UNKNOWN = -1;
    private static final byte PARENTREF_ABSENT = 0;
    private static final byte PARENTREF_PRESENT = 1;

    ReactorStmtCtx() {
    }

    ReactorStmtCtx(ReactorStmtCtx<A, D, E> original) {
        this.isSupportedToBuildEffective = original.isSupportedToBuildEffective;
        this.flags = original.flags;
    }

    ReactorStmtCtx(ReactorStmtCtx<A, D, E> original, Void dummy) {
        this.isSupportedToBuildEffective = original.isSupportedToBuildEffective;
        this.flags = original.flags;
    }

    public abstract StatementContextBase<?, ?, ?> getParentContext();

    public abstract RootStatementContext<?, ?, ?> getRoot();

    public abstract Collection<? extends @NonNull StatementContextBase<?, ?, ?>> mutableDeclaredSubstatements();

    @Override
    public final NamespaceBehaviour.Registry getBehaviourRegistry() {
        return this.getRoot().getBehaviourRegistryImpl();
    }

    public final YangVersion yangVersion() {
        return this.getRoot().getRootVersionImpl();
    }

    public final void setRootVersion(YangVersion version) {
        this.getRoot().setRootVersionImpl(version);
    }

    public final void addRequiredSource(SourceIdentifier dependency) {
        this.getRoot().addRequiredSourceImpl(dependency);
    }

    public final void setRootIdentifier(SourceIdentifier identifier) {
        this.getRoot().setRootIdentifierImpl(identifier);
    }

    public final ModelActionBuilder newInferenceAction(ModelProcessingPhase phase) {
        return this.getRoot().getSourceContext().newInferenceAction(phase);
    }

    public final StatementDefinition publicDefinition() {
        return this.definition().getPublicView();
    }

    public final EffectiveStmtCtx.Parent effectiveParent() {
        return this.getParentContext();
    }

    public final QName moduleName() {
        RootStmtContext.Mutable root = this.getRoot();
        return QName.create((QNameModule)StmtContextUtils.getModuleQName((RootStmtContext)root), (String)root.getRawArgument());
    }

    public final <X, Z extends EffectiveStatement<X, ?>> @NonNull Optional<X> findSubstatementArgument(@NonNull Class<Z> type) {
        E existing = this.effectiveInstance();
        return existing != null ? existing.findFirstEffectiveSubstatementArgument(type) : this.findSubstatementArgumentImpl(type);
    }

    public final boolean hasSubstatement(@NonNull Class<? extends EffectiveStatement<?, ?>> type) {
        E existing = this.effectiveInstance();
        return existing != null ? existing.findFirstEffectiveSubstatement(type).isPresent() : this.hasSubstatementImpl(type);
    }

    private E effectiveInstance() {
        Object existing = this.effectiveInstance;
        return existing != null ? (E)EffectiveInstances.local(existing) : null;
    }

    <X, Z extends EffectiveStatement<X, ?>> @NonNull Optional<X> findSubstatementArgumentImpl(@NonNull Class<Z> type) {
        return this.allSubstatementsStream().filter(ctx -> ctx.isSupportedToBuildEffective() && ctx.producesEffective(type)).findAny().map(ctx -> ctx.getArgument());
    }

    boolean hasSubstatementImpl(@NonNull Class<? extends EffectiveStatement<?, ?>> type) {
        return this.allSubstatementsStream().anyMatch(ctx -> ctx.isSupportedToBuildEffective() && ctx.producesEffective(type));
    }

    @Deprecated
    public final <Z extends EffectiveStatement<A, D>> StmtContext<A, D, Z> caerbannog() {
        return this;
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).omitNullValues()).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("definition", this.definition()).add("argument", this.argument()).add("refCount", (Object)this.refString());
    }

    private String refString() {
        int current = this.refcount;
        return switch (current) {
            case Integer.MAX_VALUE -> "DEFUNCT";
            case -2147483647 -> "SWEEPING";
            case Integer.MIN_VALUE -> "SWEPT";
            default -> String.valueOf(this.refcount);
        };
    }

    abstract @NonNull StatementDefinitionContext<A, D, E> definition();

    public final <K, V, T extends K> V namespaceItem(ParserNamespace<K, V> type, T key) {
        return (V)this.getBehaviourRegistry().getNamespaceBehaviour(type).getFrom((NamespaceBehaviour.NamespaceStorageNode)this, key);
    }

    public final <K, V> Map<K, V> namespace(ParserNamespace<K, V> type) {
        return this.getNamespace(type);
    }

    public final <K, V> Map<K, V> localNamespacePortion(ParserNamespace<K, V> type) {
        return this.getLocalNamespace(type);
    }

    @Override
    protected <K, V> void onNamespaceElementAdded(ParserNamespace<K, V> type, K key, V value) {
    }

    abstract @Nullable ReactorStmtCtx<?, ?, ?> asEffectiveChildOf(StatementContextBase<?, ?, ?> var1, CopyType var2, QNameModule var3);

    public final ReplicaStatementContext<A, D, E> replicaAsChildOf(StmtContext.Mutable<?, ?, ?> parent) {
        Preconditions.checkArgument((boolean)(parent instanceof StatementContextBase), (String)"Unsupported parent %s", parent);
        ReplicaStatementContext<A, D, E> ret = this.replicaAsChildOf((StatementContextBase)parent);
        this.definition().onStatementAdded(ret);
        return ret;
    }

    abstract @NonNull ReplicaStatementContext<A, D, E> replicaAsChildOf(@NonNull StatementContextBase<?, ?, ?> var1);

    public final E buildEffective() {
        Object existing = this.effectiveInstance;
        return existing != null ? EffectiveInstances.local(existing) : this.loadEffective();
    }

    private @NonNull E loadEffective() {
        E ret = this.createEffective();
        this.effectiveInstance = ret;
        if (this.refcount == 0) {
            this.sweepOnDecrement();
        }
        return ret;
    }

    abstract @NonNull E createEffective();

    abstract @NonNull E createInferredEffective(@NonNull StatementFactory<A, D, E> var1, @NonNull InferredStatementContext<A, D, E> var2, Stream<? extends ReactorStmtCtx<?, ?, ?>> var3, Stream<? extends ReactorStmtCtx<?, ?, ?>> var4);

    final @NonNull E attachEffectiveCopy(@NonNull EffectiveStatementState state, @NonNull E stmt) {
        EffectiveInstances<EffectiveStatement> instances;
        Object local = this.effectiveInstance;
        if (local instanceof EffectiveInstances) {
            instances = (EffectiveInstances<EffectiveStatement>)local;
        } else {
            this.effectiveInstance = instances = new EffectiveInstances<EffectiveStatement>((EffectiveStatement)local);
        }
        return instances.attachCopy(state, (EffectiveStatement)stmt);
    }

    abstract @NonNull ReactorStmtCtx<A, D, E> unmodifiedEffectiveSource();

    public final ModelProcessingPhase getCompletedPhase() {
        return ModelProcessingPhase.ofExecutionOrder((byte)this.executionOrder());
    }

    abstract byte executionOrder();

    final boolean tryToCompletePhase(byte executionOrder) {
        return this.executionOrder() >= executionOrder || this.doTryToCompletePhase(executionOrder);
    }

    abstract boolean doTryToCompletePhase(byte var1);

    public boolean isSupportedToBuildEffective() {
        return this.isSupportedToBuildEffective;
    }

    public final void setUnsupported() {
        this.isSupportedToBuildEffective = false;
    }

    public final boolean isSupportedByFeatures() {
        int fl = this.flags & 0x30;
        if (fl != 0) {
            return fl == 48;
        }
        if (this.isIgnoringIfFeatures()) {
            this.flags = (byte)(this.flags | 0x30);
            return true;
        }
        if (this.isParentSupportedByFeatures() && this.computeSupportedByFeatures()) {
            this.flags = (byte)(this.flags | 0x30);
            return true;
        }
        this.flags = (byte)(this.flags | 0x20);
        return false;
    }

    abstract boolean computeSupportedByFeatures();

    protected abstract boolean isParentSupportedByFeatures();

    final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull EffectiveStmtCtx.Parent.EffectiveConfig effectiveConfig(ReactorStmtCtx<?, ?, ?> parent) {
        return (this.flags & 4) != 0 ? EFFECTIVE_CONFIGS[this.flags & 3] : this.loadEffectiveConfig(parent);
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull EffectiveStmtCtx.Parent.EffectiveConfig loadEffectiveConfig(ReactorStmtCtx<?, ?, ?> parent) {
        EffectiveStmtCtx.Parent.EffectiveConfig myConfig;
        EffectiveStmtCtx.Parent.EffectiveConfig parentConfig = parent.effectiveConfig();
        if (parentConfig != EffectiveStmtCtx.Parent.EffectiveConfig.IGNORED && !this.definition().support().isIgnoringConfig()) {
            Optional optConfig = this.findSubstatementArgument(ConfigEffectiveStatement.class);
            if (optConfig.isPresent()) {
                if (((Boolean)optConfig.orElseThrow()).booleanValue()) {
                    InferenceException.throwIf((parentConfig == EffectiveStmtCtx.Parent.EffectiveConfig.FALSE ? 1 : 0) != 0, (CommonStmtCtx)this, (String)"Parent node has config=false, this node must not be specifed as config=true", (Object[])new Object[0]);
                    myConfig = EffectiveStmtCtx.Parent.EffectiveConfig.TRUE;
                } else {
                    myConfig = EffectiveStmtCtx.Parent.EffectiveConfig.FALSE;
                }
            } else {
                myConfig = parentConfig;
            }
        } else {
            myConfig = EffectiveStmtCtx.Parent.EffectiveConfig.IGNORED;
        }
        this.flags = (byte)(this.flags & 0xFFFFFFFC | 4 | myConfig.ordinal());
        return myConfig;
    }

    protected abstract boolean isIgnoringConfig();

    final boolean isIgnoringConfig(StatementContextBase<?, ?, ?> parent) {
        return EffectiveStmtCtx.Parent.EffectiveConfig.IGNORED == this.effectiveConfig(parent);
    }

    protected abstract boolean isIgnoringIfFeatures();

    final boolean isIgnoringIfFeatures(StatementContextBase<?, ?, ?> parent) {
        int fl = this.flags & 0xC0;
        if (fl != 0) {
            return fl == 192;
        }
        if (this.definition().support().isIgnoringIfFeatures() || parent.isIgnoringIfFeatures()) {
            this.flags = (byte)(this.flags | 0xC0);
            return true;
        }
        this.flags = (byte)(this.flags | 0x80);
        return false;
    }

    final boolean allSubstatementsContextIndependent() {
        return (this.flags & 8) != 0;
    }

    final void setAllSubstatementsContextIndependent() {
        this.flags = (byte)(this.flags | 8);
    }

    public final QName argumentAsTypeQName() {
        return StmtContextUtils.qnameFromArgument((StmtContext)((StmtContext)this.getOriginalCtx().orElse(this)), (String)this.getRawArgument());
    }

    public final QNameModule effectiveNamespace() {
        if (StmtContextUtils.isUnknownStatement((StmtContext)this)) {
            return this.publicDefinition().getStatementName().getModule();
        }
        if (this.producesDeclared(UsesStatement.class)) {
            return this.coerceParent().effectiveNamespace();
        }
        Object argument = this.argument();
        if (argument instanceof QName) {
            QName qname = (QName)argument;
            return qname.getModule();
        }
        if (argument instanceof String) {
            String str = (String)argument;
            return StmtContextUtils.qnameFromArgument((StmtContext)((StmtContext)this.getOriginalCtx().orElse(this)), (String)str).getModule();
        }
        if (argument instanceof SchemaNodeIdentifier) {
            SchemaNodeIdentifier sni = (SchemaNodeIdentifier)argument;
            if (this.producesDeclared(AugmentStatement.class) || this.producesDeclared(RefineStatement.class) || this.producesDeclared(DeviationStatement.class)) {
                return sni.lastNodeIdentifier().getModule();
            }
        }
        return this.coerceParent().effectiveNamespace();
    }

    private ReactorStmtCtx<?, ?, ?> coerceParent() {
        return (ReactorStmtCtx)this.coerceParentContext();
    }

    final void incRef() {
        int current = this.refcount;
        Verify.verify((current >= 0 ? 1 : 0) != 0, (String)"Attempted to access reference count of %s", (Object)this);
        if (current != Integer.MAX_VALUE) {
            this.refcount = current + 1;
        } else {
            LOG.debug("Disabled refcount increment of {}", (Object)this);
        }
    }

    final void decRef() {
        int current = this.refcount;
        if (current == Integer.MAX_VALUE) {
            LOG.debug("Disabled refcount decrement of {}", (Object)this);
            return;
        }
        if (current <= 0) {
            LOG.warn("Statement refcount underflow, reference counting disabled for {}", (Object)this, (Object)new Throwable());
            this.refcount = Integer.MAX_VALUE;
            return;
        }
        this.refcount = current - 1;
        LOG.trace("Refcount {} on {}", (Object)this.refcount, (Object)this);
        if (this.refcount == 0) {
            this.lastDecRef();
        }
    }

    final boolean noRefs() {
        int local = this.refcount;
        return local < 0 || local == 0 && this.noParentRef();
    }

    private void lastDecRef() {
        if (this.noImplictRef()) {
            this.sweepOnDecrement();
            return;
        }
        byte prevRefs = this.parentRef;
        if (prevRefs == 0) {
            this.markNoParentRef();
        } else if (prevRefs == -1) {
            this.loadParentRefcount();
        }
    }

    static final void markNoParentRef(Collection<? extends ReactorStmtCtx<?, ?, ?>> substatements) {
        for (ReactorStmtCtx<?, ?, ?> stmt : substatements) {
            byte prevRef = stmt.parentRef;
            stmt.parentRef = 0;
            if (prevRef != 1 || stmt.refcount != 0) continue;
            stmt.markNoParentRef();
        }
    }

    abstract void markNoParentRef();

    static final void sweep(Collection<? extends ReactorStmtCtx<?, ?, ?>> substatements) {
        for (ReactorStmtCtx<?, ?, ?> stmt : substatements) {
            stmt.sweep();
        }
    }

    private void sweep() {
        this.parentRef = 0;
        if (this.refcount == 0 && this.noImplictRef()) {
            LOG.trace("Releasing {}", (Object)this);
            this.sweepState();
        }
    }

    static final int countUnswept(Collection<? extends ReactorStmtCtx<?, ?, ?>> substatements) {
        int result = 0;
        for (ReactorStmtCtx<?, ?, ?> stmt : substatements) {
            if (stmt.refcount <= 0 && stmt.noImplictRef()) continue;
            ++result;
        }
        return result;
    }

    abstract int sweepSubstatements();

    private void sweepOnDecrement() {
        LOG.trace("Sweeping on decrement {}", (Object)this);
        if (this.noParentRef()) {
            this.sweepState();
        }
        this.sweepParent();
    }

    private void sweepParent() {
        StmtContext.Mutable parent = this.getParentContext();
        if (parent != null) {
            parent.sweepOnChildDecrement();
        }
    }

    private void sweepOnChildDecrement() {
        if (this.isAwaitingChildren()) {
            this.sweepOnChildDone();
            return;
        }
        int refs = this.refcount;
        if (refs > 0 || refs <= -2147483647 || !this.noImplictRef()) {
            return;
        }
        if (this.noParentRef()) {
            LOG.trace("Cleanup {} of parent {}", (Object)refs, (Object)this);
            if (this.sweepState()) {
                this.sweepParent();
            }
        }
    }

    private boolean noImplictRef() {
        return this.effectiveInstance != null || !this.isSupportedToBuildEffective();
    }

    private boolean noParentRef() {
        return this.parentRefcount() == 0;
    }

    private byte parentRefcount() {
        byte refs = this.parentRef;
        return refs != -1 ? refs : this.loadParentRefcount();
    }

    private byte loadParentRefcount() {
        this.parentRef = this.calculateParentRefcount();
        return this.parentRef;
    }

    private byte calculateParentRefcount() {
        StmtContext.Mutable parent = this.getParentContext();
        return parent == null ? (byte)0 : parent.refcountForChild();
    }

    private byte refcountForChild() {
        if (this.executionOrder() < 6) {
            return -1;
        }
        int refs = this.refcount;
        if (refs == 0) {
            return this.noImplictRef() && this.noParentRef() ? (byte)0 : 1;
        }
        return refs < 0 ? (byte)0 : 1;
    }

    private boolean isAwaitingChildren() {
        return this.refcount > -2147483647 && this.refcount < 0;
    }

    private void sweepOnChildDone() {
        LOG.trace("Sweeping on child done {}", (Object)this);
        int current = this.refcount;
        if (current >= 0) {
            LOG.trace("Ignoring child sweep of {} for {}", (Object)this, (Object)current);
            return;
        }
        Verify.verify((current != Integer.MIN_VALUE ? 1 : 0) != 0, (String)"Attempt to sweep a child of swept %s", (Object)this);
        this.refcount = current + 1;
        LOG.trace("Child refcount {}", (Object)this.refcount);
        if (this.refcount == 0) {
            this.sweepDone();
            StmtContext.Mutable parent = this.getParentContext();
            LOG.trace("Propagating to parent {}", (Object)parent);
            if (parent != null && parent.isAwaitingChildren()) {
                parent.sweepOnChildDone();
            }
        }
    }

    private void sweepDone() {
        LOG.trace("Sweep done for {}", (Object)this);
        this.refcount = Integer.MIN_VALUE;
        this.sweepNamespaces();
    }

    private boolean sweepState() {
        this.refcount = -2147483647;
        int childRefs = this.sweepSubstatements();
        if (childRefs == 0) {
            this.sweepDone();
            return true;
        }
        if (childRefs < 0 || childRefs >= Integer.MAX_VALUE) {
            LOG.warn("Negative child refcount {} cannot be stored, reference counting disabled for {}", new Object[]{childRefs, this, new Throwable()});
            this.refcount = Integer.MAX_VALUE;
        } else {
            LOG.trace("Still {} outstanding children of {}", (Object)childRefs, (Object)this);
            this.refcount = -childRefs;
        }
        return false;
    }

    static {
        EffectiveStmtCtx.Parent.EffectiveConfig[] values = EffectiveStmtCtx.Parent.EffectiveConfig.values();
        int length = values.length;
        Verify.verify((length == 4 ? 1 : 0) != 0, (String)"Unexpected EffectiveConfig cardinality %s", (int)length);
        EFFECTIVE_CONFIGS = values;
    }
}

