/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyHistory;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.ParserNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementFactory;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.InferredStatementContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.ReactorStmtCtx;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.RootStatementContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementDefinitionContext;

final class ReplicaStatementContext<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>>
extends ReactorStmtCtx<A, D, E> {
    private final StatementContextBase<?, ?, ?> parent;
    private final ReactorStmtCtx<A, D, E> source;
    private final boolean haveSourceRef;

    ReplicaStatementContext(StatementContextBase<?, ?, ?> parent, ReactorStmtCtx<A, D, E> source) {
        super(source, null);
        this.parent = Objects.requireNonNull(parent);
        this.source = Objects.requireNonNull(source);
        if (source.isSupportedToBuildEffective()) {
            source.incRef();
            this.haveSourceRef = true;
        } else {
            this.haveSourceRef = false;
        }
    }

    @Override
    E createEffective() {
        return this.source.buildEffective();
    }

    @Override
    E createInferredEffective(StatementFactory<A, D, E> factory, InferredStatementContext<A, D, E> ctx, Stream<? extends ReactorStmtCtx<?, ?, ?>> declared, Stream<? extends ReactorStmtCtx<?, ?, ?>> effective) {
        return this.source.createInferredEffective(factory, ctx, declared, effective);
    }

    @Override
    ReactorStmtCtx<A, D, E> unmodifiedEffectiveSource() {
        return this.source.unmodifiedEffectiveSource();
    }

    public EffectiveStmtCtx.Parent.EffectiveConfig effectiveConfig() {
        return this.source.effectiveConfig();
    }

    public D declared() {
        return (D)this.source.declared();
    }

    public A argument() {
        return (A)this.source.argument();
    }

    public StatementSourceReference sourceReference() {
        return this.source.sourceReference();
    }

    public String rawArgument() {
        return this.source.rawArgument();
    }

    public Optional<StmtContext<A, D, E>> getOriginalCtx() {
        return this.source.getOriginalCtx();
    }

    @Override
    public Collection<? extends StatementContextBase<?, ?, ?>> mutableDeclaredSubstatements() {
        return this.source.mutableDeclaredSubstatements();
    }

    public Collection<? extends StmtContext.Mutable<?, ?, ?>> mutableEffectiveSubstatements() {
        return this.source.mutableEffectiveSubstatements();
    }

    @Override
    byte executionOrder() {
        return this.source.executionOrder();
    }

    public CopyHistory history() {
        return this.source.history();
    }

    public Collection<? extends StmtContext<?, ?, ?>> getEffectOfStatement() {
        return List.of();
    }

    @Override
    ReplicaStatementContext<A, D, E> replicaAsChildOf(StatementContextBase<?, ?, ?> newParent) {
        return this.source.replicaAsChildOf(newParent);
    }

    public Optional<StmtContext.Mutable<A, D, E>> copyAsChildOf(StmtContext.Mutable<?, ?, ?> newParent, CopyType type, QNameModule targetModule) {
        return this.source.copyAsChildOf(newParent, type, targetModule);
    }

    @Override
    ReactorStmtCtx<?, ?, ?> asEffectiveChildOf(StatementContextBase<?, ?, ?> newParent, CopyType type, QNameModule targetModule) {
        ReactorStmtCtx<?, ?, ?> ret = this.source.asEffectiveChildOf(newParent, type, targetModule);
        return ret == null ? null : this;
    }

    @Override
    StatementDefinitionContext<A, D, E> definition() {
        return this.source.definition();
    }

    @Override
    void markNoParentRef() {
    }

    @Override
    int sweepSubstatements() {
        if (this.haveSourceRef) {
            this.source.decRef();
        }
        return 0;
    }

    @Deprecated
    public <K, V, T extends K, U extends V> void addToNs(ParserNamespace<K, V> type, T key, U value) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Optional<StmtContext<A, D, E>> getPreviousCopyCtx() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public <K, KT extends K, C extends StmtContext<?, ?, ?>> void addContext(ParserNamespace<K, ? super C> namespace, KT key, C stmt) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void addAsEffectOfStatement(Collection<? extends StmtContext<?, ?, ?>> ctxs) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public StmtContext.Mutable<?, ?, ?> childCopyOf(StmtContext<?, ?, ?> stmt, CopyType type, QNameModule targetModule) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    boolean doTryToCompletePhase(byte executionOrder) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public <X, Y extends DeclaredStatement<X>, Z extends EffectiveStatement<X, Y>> StmtContext.Mutable<X, Y, Z> createUndeclaredSubstatement(StatementSupport<X, Y, Z> support, X arg) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void addEffectiveSubstatement(StmtContext.Mutable<?, ?, ?> substatement) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void addEffectiveSubstatements(Collection<? extends StmtContext.Mutable<?, ?, ?>> statements) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void removeStatementFromEffectiveSubstatements(StatementDefinition statementDef) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void removeStatementFromEffectiveSubstatements(StatementDefinition statementDef, String statementArg) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public boolean hasImplicitParentSupport() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public StmtContext<?, ?, ?> wrapWithImplicit(StmtContext<?, ?, ?> original) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StatementContextBase<?, ?, ?> getParentContext() {
        return this.parent;
    }

    public NamespaceBehaviour.StorageNodeType getStorageNodeType() {
        return NamespaceBehaviour.StorageNodeType.STATEMENT_LOCAL;
    }

    @Override
    public StatementContextBase<?, ?, ?> getParentNamespaceStorage() {
        return this.parent;
    }

    @Override
    public RootStatementContext<?, ?, ?> getRoot() {
        return this.parent.getRoot();
    }

    @Override
    protected boolean isIgnoringIfFeatures() {
        return this.isIgnoringIfFeatures(this.parent);
    }

    @Override
    protected boolean isIgnoringConfig() {
        return this.isIgnoringConfig(this.parent);
    }

    @Override
    boolean computeSupportedByFeatures() {
        return this.source.isSupportedByFeatures();
    }

    @Override
    protected boolean isParentSupportedByFeatures() {
        return this.parent.isSupportedByFeatures();
    }
}

