/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.blueprint.ext;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.mdsal.dom.spi.ContentRoutedRpcContext;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.meta.ModelStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RpcEffectiveStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RpcUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RpcUtil.class);

    private RpcUtil() {
    }

    static List<QName> decomposeRpcService(Class<RpcService> service, EffectiveModelContext schemaContext, Predicate<ContentRoutedRpcContext> filter) {
        QNameModule moduleName = BindingReflections.getQNameModule(service);
        ModuleEffectiveStatement module = (ModuleEffectiveStatement)schemaContext.findModuleStatement(moduleName).orElseThrow(() -> new IllegalArgumentException("Module not found in SchemaContext: " + moduleName + "; service: " + service));
        LOG.debug("Resolved service {} to module {}", service, (Object)module);
        return module.streamEffectiveSubstatements(RpcEffectiveStatement.class).filter(rpc -> filter.test(ContentRoutedRpcContext.forRpc((RpcEffectiveStatement)rpc))).map(ModelStatement::argument).collect(Collectors.toList());
    }
}

