/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.netty.timer;

import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.Nullable;

public final class HashedWheelTimerCloseable
implements AutoCloseable,
Timer {
    private final Timer timer;

    private HashedWheelTimerCloseable(Timer timer) {
        this.timer = timer;
    }

    @Override
    public void close() {
        this.stop();
    }

    public Timeout newTimeout(TimerTask task, long delay, TimeUnit unit) {
        return this.timer.newTimeout(task, delay, unit);
    }

    public Set<Timeout> stop() {
        return this.timer.stop();
    }

    public static HashedWheelTimerCloseable newInstance(@Nullable Long duration, @Nullable Integer ticksPerWheel) {
        return HashedWheelTimerCloseable.newInstance(null, duration, ticksPerWheel);
    }

    public static HashedWheelTimerCloseable newInstance(@Nullable ThreadFactory threadFactory, @Nullable Long duration, @Nullable Integer ticksPerWheel) {
        TimeUnit unit = TimeUnit.MILLISECONDS;
        if (!HashedWheelTimerCloseable.nullOrNonPositive(duration) && threadFactory == null && HashedWheelTimerCloseable.nullOrNonPositive(ticksPerWheel)) {
            return new HashedWheelTimerCloseable((Timer)new HashedWheelTimer(duration.longValue(), unit));
        }
        if (!HashedWheelTimerCloseable.nullOrNonPositive(duration) && threadFactory == null && !HashedWheelTimerCloseable.nullOrNonPositive(ticksPerWheel)) {
            return new HashedWheelTimerCloseable((Timer)new HashedWheelTimer(duration.longValue(), unit, ticksPerWheel.intValue()));
        }
        if (HashedWheelTimerCloseable.nullOrNonPositive(duration) && threadFactory != null && HashedWheelTimerCloseable.nullOrNonPositive(ticksPerWheel)) {
            return new HashedWheelTimerCloseable((Timer)new HashedWheelTimer(threadFactory));
        }
        if (!HashedWheelTimerCloseable.nullOrNonPositive(duration) && threadFactory != null && HashedWheelTimerCloseable.nullOrNonPositive(ticksPerWheel)) {
            return new HashedWheelTimerCloseable((Timer)new HashedWheelTimer(threadFactory, duration.longValue(), unit));
        }
        if (!HashedWheelTimerCloseable.nullOrNonPositive(duration) && threadFactory != null && !HashedWheelTimerCloseable.nullOrNonPositive(ticksPerWheel)) {
            return new HashedWheelTimerCloseable((Timer)new HashedWheelTimer(threadFactory, duration.longValue(), unit, ticksPerWheel.intValue()));
        }
        return new HashedWheelTimerCloseable((Timer)new HashedWheelTimer());
    }

    private static boolean nullOrNonPositive(Number num) {
        return num == null || num.longValue() <= 0L;
    }
}

