/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api;

import com.google.common.annotations.Beta;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.model.api.ActionDefinition;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ExtensionDefinition;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.MustDefinition;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.NotificationNodeContainer;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathExpression;

public interface SchemaContext
extends ContainerLike,
Immutable {
    public static final @NonNull QName NAME = QName.create((XMLNamespace)YangConstants.NETCONF_NAMESPACE, (String)"data").intern();

    public @NonNull Collection<? extends @NonNull DataSchemaNode> getDataDefinitions();

    public @NonNull Collection<? extends @NonNull Module> getModules();

    public @NonNull Collection<? extends @NonNull RpcDefinition> getOperations();

    public @NonNull Collection<? extends ExtensionDefinition> getExtensions();

    public Optional<Module> findModule(@NonNull QNameModule var1);

    default public Optional<Module> findModule(@NonNull XMLNamespace namespace) {
        return this.findModule(QNameModule.create((XMLNamespace)namespace));
    }

    default public Optional<Module> findModule(@NonNull XMLNamespace namespace, @Nullable Revision revision) {
        return this.findModule(QNameModule.create((XMLNamespace)namespace, (Revision)revision));
    }

    default public Optional<Module> findModule(@NonNull XMLNamespace namespace, @NonNull Optional<Revision> revision) {
        return this.findModule(QNameModule.create((XMLNamespace)namespace, revision));
    }

    default public Optional<? extends Module> findModule(String name, Optional<Revision> revision) {
        return this.findModules(name).stream().filter(module -> revision.equals(module.getRevision())).findAny();
    }

    default public Optional<? extends Module> findModule(String name, @Nullable Revision revision) {
        return this.findModule(name, Optional.ofNullable(revision));
    }

    default public Optional<? extends Module> findModule(String name) {
        return this.findModule(name, Optional.empty());
    }

    default public @NonNull Collection<? extends @NonNull Module> findModules(String name) {
        return Collections2.filter(this.getModules(), m -> name.equals(m.getName()));
    }

    default public @NonNull Collection<? extends @NonNull Module> findModules(XMLNamespace namespace) {
        return Collections2.filter(this.getModules(), m -> namespace.equals((Object)m.getNamespace()));
    }

    @Override
    @Deprecated
    default public Collection<? extends ActionDefinition> getActions() {
        return ImmutableSet.of();
    }

    @Override
    @Deprecated
    default public Optional<ActionDefinition> findAction(QName qname) {
        Objects.requireNonNull(qname);
        return Optional.empty();
    }

    @Override
    default public Optional<NotificationDefinition> findNotification(QName qname) {
        Optional<Collection> defs = this.findModule(qname.getModule()).map(NotificationNodeContainer::getNotifications);
        if (defs.isPresent()) {
            for (NotificationDefinition def : defs.orElseThrow()) {
                if (!qname.equals((Object)def.getQName())) continue;
                return Optional.of(def);
            }
        }
        return Optional.empty();
    }

    @Override
    @Deprecated
    default public Optional<String> getDescription() {
        return Optional.empty();
    }

    @Override
    @Deprecated
    default public Optional<String> getReference() {
        return Optional.empty();
    }

    @Override
    @Deprecated
    default public Collection<? extends @NonNull MustDefinition> getMustConstraints() {
        return ImmutableSet.of();
    }

    @Override
    @Deprecated
    default public Optional<? extends YangXPathExpression.QualifiedBound> getWhenCondition() {
        return Optional.empty();
    }

    @Override
    @Deprecated
    default public boolean isAugmenting() {
        return false;
    }

    @Override
    @Deprecated
    default public boolean isAddedByUses() {
        return false;
    }

    @Override
    @Deprecated
    default public Optional<Boolean> effectiveConfig() {
        return Optional.empty();
    }

    @Override
    @Deprecated
    default public QName getQName() {
        return NAME;
    }

    @Override
    @Deprecated
    default public Status getStatus() {
        return Status.CURRENT;
    }

    @Override
    @Deprecated
    default public Collection<? extends UsesNode> getUses() {
        return Collections.emptySet();
    }

    @Override
    @Deprecated
    default public Collection<? extends AugmentationSchemaNode> getAvailableAugmentations() {
        return Collections.emptySet();
    }

    @Override
    @Beta
    default public Optional<DataSchemaNode> findDataTreeChild(QName name) {
        return this.findModule(name.getModule()).flatMap(mod -> mod.findDataTreeChild(name));
    }

    @Beta
    public @NonNull Collection<? extends IdentitySchemaNode> getDerivedIdentities(IdentitySchemaNode var1);
}

