/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.admin;

import org.opendaylight.controller.cluster.datastore.DistributedDataStoreInterface;
import org.opendaylight.controller.cluster.datastore.admin.ClusterAdminRpcService;
import org.opendaylight.controller.eos.akka.DataCenterControl;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ClusterAdminService;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={})
public final class OSGiClusterAdmin {
    private static final Logger LOG = LoggerFactory.getLogger(OSGiClusterAdmin.class);
    private final Registration reg;

    @Activate
    public OSGiClusterAdmin(@Reference(target="(type=distributed-config)") DistributedDataStoreInterface configDatastore, @Reference(target="(type=distributed-operational)") DistributedDataStoreInterface operDatastore, @Reference BindingNormalizedNodeSerializer serializer, @Reference RpcProviderService rpcProviderService, @Reference DataCenterControl dataCenterControls, @Reference DataCenterControl dataCenterControl) {
        this.reg = rpcProviderService.registerRpcImplementation(ClusterAdminService.class, (RpcService)new ClusterAdminRpcService(configDatastore, operDatastore, serializer, dataCenterControl));
        LOG.info("Cluster Admin services started");
    }

    @Deactivate
    void deactivate() {
        this.reg.close();
        LOG.info("Cluster Admin services stopped");
    }
}

