/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.api;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.ChoiceIn;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.DataRoot;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.InstanceNotification;

@Beta
public final class InstanceNotificationSpec<N extends InstanceNotification<N, P>, P extends DataObject>
implements Immutable {
    private final @NonNull InstanceIdentifier<P> path;
    private final @NonNull Class<N> type;

    private InstanceNotificationSpec(Class<N> type, InstanceIdentifier<P> path) {
        this.type = Objects.requireNonNull(type);
        this.path = Objects.requireNonNull(path);
    }

    public static <P extends ChildOf<? extends DataRoot>> @NonNull Builder<P> builder(Class<P> container) {
        return new Builder(InstanceIdentifier.builder(container));
    }

    public static <C extends ChoiceIn<? extends DataRoot> & DataObject, P extends ChildOf<? super C>> @NonNull Builder<P> builder(Class<C> caze, Class<P> container) {
        return new Builder(InstanceIdentifier.builder(caze, container));
    }

    public @NonNull InstanceIdentifier<P> path() {
        return this.path;
    }

    public @NonNull Class<N> type() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.path);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof InstanceNotificationSpec)) {
            return false;
        }
        InstanceNotificationSpec other = (InstanceNotificationSpec)obj;
        return this.type.equals(other.type) && this.path.equals(other.path);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("action", this.type).add("path", this.path).toString();
    }

    @Beta
    public static final class Builder<P extends DataObject>
    implements Mutable {
        private final InstanceIdentifier.InstanceIdentifierBuilder<P> pathBuilder;

        Builder(InstanceIdentifier.InstanceIdentifierBuilder<P> pathBuilder) {
            this.pathBuilder = Objects.requireNonNull(pathBuilder);
        }

        public <N extends ChildOf<? super P>> @NonNull Builder<N> withPathChild(Class<N> container) {
            this.pathBuilder.child(container);
            return this.castThis();
        }

        public <C extends ChoiceIn<? super P> & DataObject, N extends ChildOf<? super C>> @NonNull Builder<N> withPathChild(Class<C> caze, Class<N> container) {
            this.pathBuilder.child(caze, container);
            return this.castThis();
        }

        public <N extends DataObject & Augmentation<? super P>> @NonNull Builder<N> withPathAugmentation(Class<N> container) {
            this.pathBuilder.augmentation(container);
            return this.castThis();
        }

        public <N extends InstanceNotification<N, P>> @NonNull InstanceNotificationSpec<N, P> build(Class<N> type) {
            return new InstanceNotificationSpec(type, this.pathBuilder.build());
        }

        private <N extends DataObject> @NonNull Builder<N> castThis() {
            return this;
        }
    }
}

