/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.api;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.EventListener;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.BindingService;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.binding.NotificationListener;

public interface NotificationService
extends BindingService {
    @Deprecated(since="10.0.0", forRemoval=true)
    public <T extends NotificationListener> @NonNull ListenerRegistration<T> registerNotificationListener(@NonNull T var1);

    public <N extends Notification<N> & DataObject> @NonNull Registration registerListener(Class<N> var1, Listener<N> var2, Executor var3);

    default public <N extends Notification<N> & DataObject> @NonNull Registration registerListener(Class<N> type, Listener<N> listener) {
        return this.registerListener(type, listener, MoreExecutors.directExecutor());
    }

    @Beta
    public @NonNull Registration registerCompositeListener(CompositeListener var1, Executor var2);

    @Beta
    default public @NonNull Registration registerCompositeListener(CompositeListener listener) {
        return this.registerCompositeListener(listener, MoreExecutors.directExecutor());
    }

    @FunctionalInterface
    public static interface Listener<N extends Notification<N> & DataObject>
    extends EventListener {
        public void onNotification(@NonNull N var1);
    }

    @Beta
    public record CompositeListener(@NonNull Set<Component<?>> constituents) {
        public CompositeListener(@NonNull Set<Component<?>> constituents) {
            Objects.requireNonNull(constituents);
            Preconditions.checkArgument((!constituents.isEmpty() ? 1 : 0) != 0, (Object)"Composite listener requires at least one constituent listener");
        }

        @Beta
        public record Component<T extends Notification<T> & DataObject>(@NonNull Class<T> type, Listener<T> listener) {
            public Component(@NonNull Class<T> type, Listener<T> listener) {
                Objects.requireNonNull(type);
                Objects.requireNonNull(listener);
                Preconditions.checkArgument((boolean)DataObject.class.isAssignableFrom(type), (String)"%s is not a DataObject", type);
                Preconditions.checkArgument((boolean)Notification.class.isAssignableFrom(type), (String)"%s is not a Notification", type);
            }
        }
    }
}

