/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.impl.AbstractValueCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.EncapsulatedValueCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.IdentityCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.InstanceIdentifierCodec;
import org.opendaylight.yangtools.yang.binding.BaseIdentity;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

abstract class CompositeValueCodec
extends AbstractValueCodec<Object, Object> {
    private final EncapsulatedValueCodec typeObjectCodec;

    private CompositeValueCodec(Class<?> valueType) {
        this.typeObjectCodec = EncapsulatedValueCodec.ofUnchecked(valueType);
    }

    @Override
    protected Object deserializeImpl(Object input) {
        return this.typeObjectCodec.deserialize(this.domToBinding(input));
    }

    abstract @NonNull Object domToBinding(@NonNull Object var1);

    @Override
    protected Object serializeImpl(Object input) {
        return this.bindingToDom(this.typeObjectCodec.serialize(input));
    }

    abstract @NonNull Object bindingToDom(@NonNull Object var1);

    static final class OfInstanceIdentifier
    extends CompositeValueCodec {
        private final InstanceIdentifierCodec valueCodec;

        OfInstanceIdentifier(Class<?> valueType, InstanceIdentifierCodec codec) {
            super(valueType);
            this.valueCodec = Objects.requireNonNull(codec);
        }

        @Override
        Object domToBinding(Object domValue) {
            Preconditions.checkArgument((boolean)(domValue instanceof YangInstanceIdentifier), (String)"Unexpected DOM value %s", (Object)domValue);
            InstanceIdentifier binding = this.valueCodec.toBinding((YangInstanceIdentifier)domValue);
            Preconditions.checkArgument((binding != null ? 1 : 0) != 0, (String)"Cannot represent %s in binding", (Object)domValue);
            return binding;
        }

        @Override
        Object bindingToDom(Object bindingValue) {
            Preconditions.checkArgument((boolean)(bindingValue instanceof InstanceIdentifier), (String)"Unexpected Binding value %s", (Object)bindingValue);
            return this.valueCodec.fromBinding((InstanceIdentifier)bindingValue);
        }
    }

    static final class OfIdentity
    extends CompositeValueCodec {
        private final IdentityCodec valueCodec;

        OfIdentity(Class<?> valueType, IdentityCodec codec) {
            super(valueType);
            this.valueCodec = Objects.requireNonNull(codec);
        }

        @Override
        Object bindingToDom(Object bindingValue) {
            Preconditions.checkArgument((boolean)(bindingValue instanceof BaseIdentity), (String)"Unexpected Binding value %s", (Object)bindingValue);
            return this.valueCodec.fromBinding((BaseIdentity)bindingValue);
        }

        @Override
        Object domToBinding(Object domValue) {
            Preconditions.checkArgument((boolean)(domValue instanceof QName), (String)"Unexpected DOM value %s", (Object)domValue);
            return this.valueCodec.toBinding((QName)domValue);
        }
    }
}

