/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingDataObjectCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeCachingCodec;
import org.opendaylight.mdsal.binding.dom.codec.api.IncorrectNestingException;
import org.opendaylight.mdsal.binding.dom.codec.api.MissingClassInLoadingStrategyException;
import org.opendaylight.mdsal.binding.dom.codec.api.MissingSchemaException;
import org.opendaylight.mdsal.binding.dom.codec.api.MissingSchemaForClassException;
import org.opendaylight.mdsal.binding.dom.codec.impl.BindingToNormalizedStreamWriter;
import org.opendaylight.mdsal.binding.dom.codec.impl.CachingNormalizedNodeCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecPrototype;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataObjectSerializer;
import org.opendaylight.mdsal.binding.dom.codec.impl.NodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.NonCachingCodec;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.runtime.api.RuntimeTypeContainer;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.util.ClassLoaderUtils;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.BindingObject;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class DataContainerCodecContext<D extends DataObject, T extends RuntimeTypeContainer>
extends NodeCodecContext
implements BindingDataObjectCodecTreeNode<D> {
    private static final Logger LOG = LoggerFactory.getLogger(DataContainerCodecContext.class);
    private static final VarHandle EVENT_STREAM_SERIALIZER;
    private final @NonNull DataContainerCodecPrototype<T> prototype;
    private volatile DataObjectSerializer eventStreamSerializer;

    DataContainerCodecContext(DataContainerCodecPrototype<T> prototype) {
        this.prototype = Objects.requireNonNull(prototype);
    }

    public final @NonNull T getType() {
        return this.prototype.getType();
    }

    public final BindingDataObjectCodecTreeNode.ChildAddressabilitySummary getChildAddressabilitySummary() {
        return this.prototype.getChildAddressabilitySummary();
    }

    protected final QNameModule namespace() {
        return this.prototype.getNamespace();
    }

    protected final NodeCodecContext.CodecContextFactory factory() {
        return this.prototype.getFactory();
    }

    @Override
    protected YangInstanceIdentifier.PathArgument getDomPathArgument() {
        return this.prototype.getYangArg();
    }

    public abstract NodeCodecContext yangPathArgumentChild(YangInstanceIdentifier.PathArgument var1);

    public DataContainerCodecContext<?, ?> bindingPathArgumentChild(InstanceIdentifier.PathArgument arg, List<YangInstanceIdentifier.PathArgument> builder) {
        BindingDataObjectCodecTreeNode child = this.streamChild(arg.getType());
        if (builder != null) {
            child.addYangPathArgument(arg, builder);
        }
        return child;
    }

    protected InstanceIdentifier.PathArgument getBindingPathArgument(YangInstanceIdentifier.PathArgument domArg) {
        return this.bindingArg();
    }

    protected final InstanceIdentifier.PathArgument bindingArg() {
        return this.prototype.getBindingArg();
    }

    public final Class<D> getBindingClass() {
        return (Class)Class.class.cast(this.prototype.getBindingClass());
    }

    public abstract <C extends DataObject> DataContainerCodecContext<C, ?> streamChild(Class<C> var1);

    public abstract <C extends DataObject> Optional<DataContainerCodecContext<C, ?>> possibleStreamChild(Class<C> var1);

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.prototype.getBindingClass() + "]";
    }

    public BindingNormalizedNodeCachingCodec<D> createCachingCodec(ImmutableCollection<Class<? extends BindingObject>> cacheSpecifier) {
        if (cacheSpecifier.isEmpty()) {
            return new NonCachingCodec(this);
        }
        return new CachingNormalizedNodeCodec(this, (ImmutableSet<Class<? extends BindingObject>>)ImmutableSet.copyOf(cacheSpecifier));
    }

    protected final <V> @NonNull V childNonNull(@Nullable V nullable, YangInstanceIdentifier.PathArgument child, String message, Object ... args) {
        if (nullable == null) {
            throw this.childNullException(DataContainerCodecContext.extractName(child), message, args);
        }
        return nullable;
    }

    protected final <V> @NonNull V childNonNull(@Nullable V nullable, QName child, String message, Object ... args) {
        if (nullable == null) {
            throw this.childNullException(child, message, args);
        }
        return nullable;
    }

    protected final <V> @NonNull V childNonNull(@Nullable V nullable, Class<?> childClass, String message, Object ... args) {
        if (nullable == null) {
            throw this.childNullException(childClass, message, args);
        }
        return nullable;
    }

    @CheckReturnValue
    private IllegalArgumentException childNullException(QName child, String message, Object ... args) {
        QNameModule module = child.getModule();
        if (!this.factory().getRuntimeContext().getEffectiveModelContext().findModule(module).isPresent()) {
            return new MissingSchemaException("Module " + module + " is not present in current schema context.");
        }
        return new IncorrectNestingException(message, args);
    }

    @CheckReturnValue
    private @NonNull IllegalArgumentException childNullException(Class<?> childClass, String message, Object ... args) {
        return DataContainerCodecContext.childNullException(this.factory().getRuntimeContext(), childClass, message, args);
    }

    @CheckReturnValue
    private static @NonNull IllegalArgumentException childNullException(BindingRuntimeContext runtimeContext, Class<?> childClass, String message, Object ... args) {
        Object schema = Augmentation.class.isAssignableFrom(childClass) ? runtimeContext.getAugmentationDefinition(childClass.asSubclass(Augmentation.class)) : runtimeContext.getSchemaDefinition(childClass);
        if (schema == null) {
            return new MissingSchemaForClassException(childClass);
        }
        try {
            runtimeContext.loadClass(org.opendaylight.mdsal.binding.model.api.Type.of(childClass));
        }
        catch (ClassNotFoundException e) {
            return new MissingClassInLoadingStrategyException("User supplied class " + childClass.getName() + " is not available in " + runtimeContext, (Throwable)e);
        }
        return new IncorrectNestingException(message, args);
    }

    private static QName extractName(YangInstanceIdentifier.PathArgument child) {
        if (child instanceof YangInstanceIdentifier.AugmentationIdentifier) {
            Set children = ((YangInstanceIdentifier.AugmentationIdentifier)child).getPossibleChildNames();
            Preconditions.checkArgument((!children.isEmpty() ? 1 : 0) != 0, (Object)"Augmentation without childs must not be used in data");
            return (QName)children.iterator().next();
        }
        return child.getNodeType();
    }

    final DataObjectSerializer eventStreamSerializer() {
        DataObjectSerializer existing = EVENT_STREAM_SERIALIZER.getAcquire(this);
        return existing != null ? existing : this.loadEventStreamSerializer();
    }

    private DataObjectSerializer loadEventStreamSerializer() {
        DataObjectSerializer loaded = this.factory().getEventStreamSerializer(this.getBindingClass());
        Object witness = EVENT_STREAM_SERIALIZER.compareAndExchangeRelease(this, null, loaded);
        return witness == null ? loaded : (DataObjectSerializer)witness;
    }

    public NormalizedNode serialize(D data) {
        NormalizedNodeResult result = new NormalizedNodeResult();
        NormalizedNodeStreamWriter domWriter = ImmutableNormalizedNodeStreamWriter.from((NormalizedNodeResult)result);
        this.writeAsNormalizedNode(data, domWriter);
        return result.getResult();
    }

    public void writeAsNormalizedNode(D data, NormalizedNodeStreamWriter writer) {
        try {
            this.eventStreamSerializer().serialize((DataObject)data, new BindingToNormalizedStreamWriter(this, writer));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to serialize Binding DTO", e);
        }
    }

    static final <T extends NormalizedNode> @NonNull T checkDataArgument(@NonNull Class<T> expectedType, NormalizedNode data) {
        try {
            return (T)((NormalizedNode)expectedType.cast(Objects.requireNonNull(data)));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Expected " + expectedType.getSimpleName(), e);
        }
    }

    static final Optional<Class<? extends DataContainer>> getYangModeledReturnType(Method method, String prefix) {
        String methodName = method.getName();
        if ("getClass".equals(methodName) || !methodName.startsWith(prefix) || method.getParameterCount() > 0) {
            return Optional.empty();
        }
        Class<?> returnType = method.getReturnType();
        if (DataContainer.class.isAssignableFrom(returnType)) {
            return DataContainerCodecContext.optionalDataContainer(returnType);
        }
        if (List.class.isAssignableFrom(returnType)) {
            return DataContainerCodecContext.getYangModeledReturnType(method, 0);
        }
        if (Map.class.isAssignableFrom(returnType)) {
            return DataContainerCodecContext.getYangModeledReturnType(method, 1);
        }
        return Optional.empty();
    }

    private static Optional<Class<? extends DataContainer>> getYangModeledReturnType(Method method, int parameterOffset) {
        try {
            return (Optional)ClassLoaderUtils.callWithClassLoader((ClassLoader)method.getDeclaringClass().getClassLoader(), () -> DataContainerCodecContext.genericParameter(method.getGenericReturnType(), parameterOffset).flatMap(result -> result instanceof Class ? DataContainerCodecContext.optionalCast((Class)result) : Optional.empty()));
        }
        catch (Exception e) {
            LOG.debug("Unable to find YANG modeled return type for {}", (Object)method, (Object)e);
            return Optional.empty();
        }
    }

    private static Optional<Type> genericParameter(Type type, int offset) {
        ParameterizedType parameterized;
        Type[] parameters;
        if (type instanceof ParameterizedType && (parameters = (parameterized = (ParameterizedType)type).getActualTypeArguments()).length > offset) {
            return Optional.of(parameters[offset]);
        }
        return Optional.empty();
    }

    private static Optional<Class<? extends DataContainer>> optionalCast(Class<?> type) {
        return DataContainer.class.isAssignableFrom(type) ? DataContainerCodecContext.optionalDataContainer(type) : Optional.empty();
    }

    static final Optional<Class<? extends DataContainer>> optionalDataContainer(Class<?> type) {
        return Optional.of(type.asSubclass(DataContainer.class));
    }

    static boolean isSubstitutionFor(Class potential, Class target) {
        HashSet targetImplemented;
        HashSet subImplemented = new HashSet(Arrays.asList(potential.getInterfaces()));
        if (!subImplemented.equals(targetImplemented = new HashSet(Arrays.asList(target.getInterfaces())))) {
            return false;
        }
        if (Augmentation.class.isAssignableFrom(potential) && !BindingReflections.findAugmentationTarget((Class)potential).equals(BindingReflections.findAugmentationTarget((Class)target))) {
            return false;
        }
        for (Method potentialMethod : potential.getMethods()) {
            if (Modifier.isStatic(potentialMethod.getModifiers())) continue;
            try {
                Method targetMethod = target.getMethod(potentialMethod.getName(), potentialMethod.getParameterTypes());
                if (potentialMethod.getReturnType().equals(targetMethod.getReturnType())) continue;
                return false;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            catch (SecurityException e) {
                throw new IllegalStateException("Could not compare methods", e);
            }
        }
        return true;
    }

    static {
        try {
            EVENT_STREAM_SERIALIZER = MethodHandles.lookup().findVarHandle(DataContainerCodecContext.class, "eventStreamSerializer", DataObjectSerializer.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

