/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecPrototype;
import org.opendaylight.mdsal.binding.dom.codec.impl.IdentifiableItemCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.LazyBindingMap;
import org.opendaylight.mdsal.binding.dom.codec.impl.ListNodeCodecContext;
import org.opendaylight.mdsal.binding.runtime.api.ListRuntimeType;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.Ordering;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;

abstract class KeyedListNodeCodecContext<I extends Identifier<D>, D extends DataObject & Identifiable<I>>
extends ListNodeCodecContext<D> {
    private final IdentifiableItemCodec codec;

    KeyedListNodeCodecContext(DataContainerCodecPrototype<ListRuntimeType> prototype, Method keyMethod, IdentifiableItemCodec codec) {
        super(prototype, keyMethod);
        this.codec = Objects.requireNonNull(codec);
    }

    static KeyedListNodeCodecContext create(DataContainerCodecPrototype<ListRuntimeType> prototype) {
        Method keyMethod;
        Class<?> bindingClass = prototype.getBindingClass();
        try {
            keyMethod = bindingClass.getMethod("key", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Required method not available", e);
        }
        ListRuntimeType type = prototype.getType();
        IdentifiableItemCodec codec = prototype.getFactory().getPathArgumentCodec(bindingClass, type);
        return type.statement().ordering() == Ordering.SYSTEM ? new Unordered(prototype, keyMethod, codec) : new Ordered(prototype, keyMethod, codec);
    }

    @Override
    protected void addYangPathArgument(InstanceIdentifier.PathArgument arg, List<YangInstanceIdentifier.PathArgument> builder) {
        if (builder == null) {
            return;
        }
        super.addYangPathArgument(arg, builder);
        if (arg instanceof InstanceIdentifier.IdentifiableItem) {
            builder.add((YangInstanceIdentifier.PathArgument)this.codec.bindingToDom((InstanceIdentifier.IdentifiableItem)arg));
        } else {
            super.addYangPathArgument(arg, builder);
        }
    }

    @Override
    protected InstanceIdentifier.PathArgument getBindingPathArgument(YangInstanceIdentifier.PathArgument domArg) {
        return domArg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates ? this.codec.domToBinding((YangInstanceIdentifier.NodeIdentifierWithPredicates)domArg) : super.getBindingPathArgument(domArg);
    }

    YangInstanceIdentifier.NodeIdentifierWithPredicates serialize(Identifier<?> key) {
        return this.codec.bindingToDom(InstanceIdentifier.IdentifiableItem.of(this.getBindingClass(), key));
    }

    @NonNull Identifier<?> deserialize(YangInstanceIdentifier.NodeIdentifierWithPredicates arg) {
        return this.codec.deserializeIdentifier(arg);
    }

    @Override
    public YangInstanceIdentifier.PathArgument serializePathArgument(InstanceIdentifier.PathArgument arg) {
        return arg instanceof InstanceIdentifier.IdentifiableItem ? this.codec.bindingToDom((InstanceIdentifier.IdentifiableItem)arg) : super.serializePathArgument(arg);
    }

    @Override
    public InstanceIdentifier.PathArgument deserializePathArgument(YangInstanceIdentifier.PathArgument arg) {
        return arg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates ? this.codec.domToBinding((YangInstanceIdentifier.NodeIdentifierWithPredicates)arg) : super.deserializePathArgument(arg);
    }

    static final class Unordered<I extends Identifier<D>, D extends DataObject & Identifiable<I>>
    extends KeyedListNodeCodecContext<I, D> {
        Unordered(DataContainerCodecPrototype<ListRuntimeType> prototype, Method keyMethod, IdentifiableItemCodec codec) {
            super(prototype, keyMethod, codec);
        }

        @Override
        Map<I, D> fromMap(MapNode map, int size) {
            return LazyBindingMap.create(this, map, size);
        }
    }

    private static final class Ordered<I extends Identifier<D>, D extends DataObject & Identifiable<I>>
    extends KeyedListNodeCodecContext<I, D> {
        Ordered(DataContainerCodecPrototype<ListRuntimeType> prototype, Method keyMethod, IdentifiableItemCodec codec) {
            super(prototype, keyMethod, codec);
        }
    }
}

