/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecPrototype;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataObjectCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.LazyBindingList;
import org.opendaylight.mdsal.binding.runtime.api.ListRuntimeType;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.data.api.schema.DistinctNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;

class ListNodeCodecContext<D extends DataObject>
extends DataObjectCodecContext<D, ListRuntimeType> {
    ListNodeCodecContext(DataContainerCodecPrototype<ListRuntimeType> prototype) {
        super(prototype);
    }

    ListNodeCodecContext(DataContainerCodecPrototype<ListRuntimeType> prototype, Method keyMethod) {
        super(prototype, keyMethod);
    }

    public D deserialize(NormalizedNode node) {
        NormalizedNode nonnull = Objects.requireNonNull(node);
        if (nonnull instanceof MapEntryNode) {
            MapEntryNode mapEntry = (MapEntryNode)nonnull;
            return this.createBindingProxy((DistinctNodeContainer<?, ?>)mapEntry);
        }
        if (nonnull instanceof UnkeyedListEntryNode) {
            UnkeyedListEntryNode unkeyedEntry = (UnkeyedListEntryNode)nonnull;
            return this.createBindingProxy((DistinctNodeContainer<?, ?>)unkeyedEntry);
        }
        throw new IllegalArgumentException("Expecting either a MapEntryNode or an UnkeyedListEntryNode, not " + node.contract().getSimpleName());
    }

    @Override
    protected Object deserializeObject(NormalizedNode node) {
        if (node instanceof MapNode) {
            MapNode map = (MapNode)node;
            return this.fromMap(map);
        }
        if (node instanceof MapEntryNode) {
            MapEntryNode mapEntry = (MapEntryNode)node;
            return this.createBindingProxy((DistinctNodeContainer<?, ?>)mapEntry);
        }
        if (node instanceof UnkeyedListNode) {
            UnkeyedListNode list = (UnkeyedListNode)node;
            return this.fromUnkeyedList(list);
        }
        if (node instanceof UnkeyedListEntryNode) {
            UnkeyedListEntryNode listEntry = (UnkeyedListEntryNode)node;
            return this.createBindingProxy((DistinctNodeContainer<?, ?>)listEntry);
        }
        throw new IllegalStateException("Unsupported data type " + node.contract().getSimpleName());
    }

    @NonNull Object fromMap(MapNode map, int size) {
        return LazyBindingList.create(this, size, map.body());
    }

    private Object fromMap(MapNode map) {
        int size = map.size();
        return size == 0 ? null : this.fromMap(map, size);
    }

    private List<D> fromUnkeyedList(UnkeyedListNode node) {
        int size = node.size();
        return size == 0 ? null : LazyBindingList.create(this, size, node.body());
    }
}

