/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.model.ietf.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.HexFormat;
import java.util.UUID;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.spec.reflect.StringValueObjectFactory;
import org.opendaylight.mdsal.model.ietf.util.AbstractIetfInetUtil;
import org.opendaylight.mdsal.model.ietf.util.Ipv4Utils;

@Beta
public abstract class AbstractIetfYangUtil<M, P, H, Q, U> {
    private static final int MAC_BYTE_LENGTH = 6;
    private static final HexFormat COLON_HEXFORMAT = HexFormat.ofDelimiter(":");
    private static final byte @NonNull [] EMPTY_BYTES = new byte[0];
    private final StringValueObjectFactory<M> macFactory;
    private final StringValueObjectFactory<P> physFactory;
    private final StringValueObjectFactory<H> hexFactory;
    private final StringValueObjectFactory<Q> quadFactory;
    private final StringValueObjectFactory<U> uuidFactory;

    protected AbstractIetfYangUtil(Class<M> macClass, Class<P> physClass, Class<H> hexClass, Class<Q> quadClass, Class<U> uuidClass) {
        this.macFactory = StringValueObjectFactory.create(macClass, (String)"00:00:00:00:00:00");
        this.physFactory = StringValueObjectFactory.create(physClass, (String)"00:00");
        this.hexFactory = StringValueObjectFactory.create(hexClass, (String)"00");
        this.quadFactory = StringValueObjectFactory.create(quadClass, (String)"0.0.0.0");
        this.uuidFactory = StringValueObjectFactory.create(uuidClass, (String)"f81d4fae-7dec-11d0-a765-00a0c91e6bf6");
    }

    public final @NonNull M canonizeMacAddress(@NonNull M macAddress) {
        char[] input = this.getValue(macAddress).toCharArray();
        return (M)(AbstractIetfYangUtil.ensureLowerCase(input) ? this.macFactory.newInstance(String.valueOf(input)) : macAddress);
    }

    public final @NonNull M macAddressFor(byte @NonNull [] bytes) {
        Preconditions.checkArgument((bytes.length == 6 ? 1 : 0) != 0, (String)"MAC address should have 6 bytes, not %s", (int)bytes.length);
        return (M)this.macFactory.newInstance(COLON_HEXFORMAT.formatHex(bytes));
    }

    public final byte @NonNull [] macAddressBytes(@NonNull M macAddress) {
        return AbstractIetfYangUtil.stringToBytes(this.getValue(macAddress), 6);
    }

    public final @NonNull P canonizePhysAddress(@NonNull P physAddress) {
        char[] input = this.getPhysValue(physAddress).toCharArray();
        return (P)(AbstractIetfYangUtil.ensureLowerCase(input) ? this.physFactory.newInstance(String.valueOf(input)) : physAddress);
    }

    public final @NonNull P physAddressFor(byte @NonNull [] bytes) {
        Preconditions.checkArgument((bytes.length > 0 ? 1 : 0) != 0, (Object)"Physical address should have at least one byte");
        return (P)this.physFactory.newInstance(COLON_HEXFORMAT.formatHex(bytes));
    }

    public final byte @NonNull [] physAddressBytes(@NonNull P physAddress) {
        String str = this.getPhysValue(physAddress);
        return str.isEmpty() ? EMPTY_BYTES : AbstractIetfYangUtil.stringToBytes(str, str.length() / 3 + 1);
    }

    public final @NonNull H hexStringFor(byte @NonNull [] bytes) {
        Preconditions.checkArgument((bytes.length > 0 ? 1 : 0) != 0, (Object)"Hex string should have at least one byte");
        return (H)this.hexFactory.newInstance(COLON_HEXFORMAT.formatHex(bytes));
    }

    public final byte @NonNull [] hexStringBytes(@NonNull H hexString) {
        String str = this.getHexValue(hexString);
        return AbstractIetfYangUtil.stringToBytes(str, str.length() / 3 + 1);
    }

    public final @NonNull Q dottedQuadFor(byte @NonNull [] bytes) {
        Preconditions.checkArgument((bytes.length == 4 ? 1 : 0) != 0, (Object)"Dotted-quad should have 4 bytes");
        return (Q)this.quadFactory.newInstance(AbstractIetfInetUtil.addressStringV4(bytes));
    }

    public final @NonNull Q dottedQuadFor(int bits) {
        return (Q)this.quadFactory.newInstance(Ipv4Utils.addressString(bits));
    }

    public final int dottedQuadBits(@NonNull Q dottedQuad) {
        String str = this.getQuadValue(dottedQuad);
        return Ipv4Utils.addressBits(str, str.length());
    }

    public final byte @NonNull [] dottedQuadBytes(@NonNull Q dottedQuad) {
        String str = this.getQuadValue(dottedQuad);
        return Ipv4Utils.addressBytes(str, str.length());
    }

    public final @NonNull U uuidFor(@NonNull UUID uuid) {
        return (U)this.uuidFactory.newInstance(uuid.toString());
    }

    protected abstract String getValue(M var1);

    protected abstract String getPhysValue(P var1);

    protected abstract String getHexValue(H var1);

    protected abstract String getQuadValue(Q var1);

    private static boolean ensureLowerCase(char @NonNull [] chars) {
        boolean ret = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c < 'A' || c > 'F') continue;
            chars[i] = (char)(c + 32);
            ret = true;
        }
        return ret;
    }

    private static byte @NonNull [] stringToBytes(String str, int length) {
        byte[] ret = new byte[length];
        int i = 0;
        int base = 0;
        while (i < length) {
            ret[i] = (byte)((HexFormat.fromHexDigit(str.charAt(base)) << 4) + HexFormat.fromHexDigit(str.charAt(base + 1)));
            ++i;
            base += 3;
        }
        return ret;
    }
}

