/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.binding;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;

@NonNullByDefault
public interface YangModuleInfo
extends Immutable {
    public QName getName();

    public InputStream openYangTextStream() throws IOException;

    default public Collection<YangModuleInfo> getImportedModules() {
        return ImmutableList.of();
    }

    default public ByteSource getYangTextByteSource() {
        return new ByteSource(){

            public InputStream openStream() throws IOException {
                return YangModuleInfo.this.openYangTextStream();
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)((Object)this)).add("name", (Object)YangModuleInfo.this.getName()).toString();
            }
        };
    }

    default public CharSource getYangTextCharSource() {
        return this.getYangTextByteSource().asCharSource(StandardCharsets.UTF_8);
    }
}

