/*
 * Decompiled with CFR 0.152.
 */
package org.lmdbjava;

import jnr.constants.Constant;
import jnr.constants.ConstantSet;
import org.lmdbjava.Cursor;
import org.lmdbjava.Dbi;
import org.lmdbjava.Env;
import org.lmdbjava.LmdbNativeException;
import org.lmdbjava.Txn;

final class ResultCodeMapper {
    static final int MDB_SUCCESS = 0;
    private static final ConstantSet CONSTANTS = ConstantSet.getConstantSet((String)"Errno");
    private static final String POSIX_ERR_NO = "Errno";

    private ResultCodeMapper() {
    }

    static void checkRc(int rc) {
        switch (rc) {
            case 0: {
                return;
            }
            case -30780: {
                throw new Dbi.BadDbiException();
            }
            case -30783: {
                throw new Txn.BadReaderLockException();
            }
            case -30782: {
                throw new Txn.BadException();
            }
            case -30781: {
                throw new Dbi.BadValueSizeException();
            }
            case -30796: {
                throw new LmdbNativeException.PageCorruptedException();
            }
            case -30787: {
                throw new Cursor.FullException();
            }
            case -30791: {
                throw new Dbi.DbFullException();
            }
            case -30784: {
                throw new Dbi.IncompatibleException();
            }
            case -30793: {
                throw new Env.FileInvalidException();
            }
            case -30799: {
                throw new Dbi.KeyExistsException();
            }
            case -30792: {
                throw new Env.MapFullException();
            }
            case -30785: {
                throw new Dbi.MapResizedException();
            }
            case -30798: {
                throw new Dbi.KeyNotFoundException();
            }
            case -30786: {
                throw new LmdbNativeException.PageFullException();
            }
            case -30797: {
                throw new LmdbNativeException.PageNotFoundException();
            }
            case -30795: {
                throw new LmdbNativeException.PanicException();
            }
            case -30790: {
                throw new Env.ReadersFullException();
            }
            case -30789: {
                throw new LmdbNativeException.TlsFullException();
            }
            case -30788: {
                throw new Txn.TxFullException();
            }
            case -30794: {
                throw new Env.VersionMismatchException();
            }
        }
        Constant constant = CONSTANTS.getConstant((long)rc);
        if (constant == null) {
            throw new IllegalArgumentException("Unknown result code " + rc);
        }
        String msg = constant.name() + " " + constant.toString();
        throw new LmdbNativeException.ConstantDerviedException(rc, msg);
    }
}

