/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.loader;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.loader.LeafBindingClassLoader;
import org.opendaylight.mdsal.binding.loader.RootBindingClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class BindingClassLoader
extends ClassLoader {
    private static final ClassLoadingStrategy<BindingClassLoader> STRATEGY = (classLoader, types) -> {
        Verify.verify((types.size() == 1 ? 1 : 0) != 0, (String)"Unexpected multiple types", (Object)types);
        Map.Entry entry = types.entrySet().iterator().next();
        return ImmutableMap.of((Object)((TypeDescription)entry.getKey()), classLoader.loadClass(((TypeDescription)entry.getKey()).getName(), (byte[])entry.getValue()));
    };
    private static final Logger LOG;
    private final @Nullable File dumpDir;

    BindingClassLoader(ClassLoader parentLoader, @Nullable File dumpDir) {
        super(parentLoader);
        this.dumpDir = dumpDir;
    }

    BindingClassLoader(BindingClassLoader parentLoader) {
        this(parentLoader, parentLoader.dumpDir);
    }

    public static @NonNull BindingClassLoader create(Class<?> rootClass, @Nullable File dumpDir) {
        ClassLoader parentLoader = rootClass.getClassLoader();
        return AccessController.doPrivileged(() -> new RootBindingClassLoader(parentLoader, dumpDir));
    }

    public final <T> @NonNull Class<T> generateClass(Class<?> bindingInterface, String fqcn, ClassGenerator<T> generator) {
        return this.findClassLoader(Objects.requireNonNull(bindingInterface)).doGenerateClass(bindingInterface, fqcn, generator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final @NonNull Class<?> getGeneratedClass(Class<?> bindingInterface, String fqcn) {
        Class<?> ret;
        BindingClassLoader loader = this.findClassLoader(Objects.requireNonNull(bindingInterface));
        Object object = loader.getClassLoadingLock(fqcn);
        synchronized (object) {
            ret = loader.findLoadedClass(fqcn);
        }
        Preconditions.checkArgument((ret != null ? 1 : 0) != 0, (String)"Failed to find generated class %s for %s", (Object)fqcn, bindingInterface);
        return ret;
    }

    abstract void appendLoaders(@NonNull Set<LeafBindingClassLoader> var1);

    abstract @NonNull BindingClassLoader findClassLoader(@NonNull Class<?> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> @NonNull Class<T> doGenerateClass(Class<?> bindingInterface, String fqcn, ClassGenerator<T> generator) {
        Object object = this.getClassLoadingLock(fqcn);
        synchronized (object) {
            Class<?> existing = this.findLoadedClass(fqcn);
            if (existing != null) {
                return existing;
            }
            GeneratorResult<T> result = generator.generateClass(this, fqcn, bindingInterface);
            DynamicType.Unloaded unloaded = result.getResult();
            Verify.verify((boolean)fqcn.equals(unloaded.getTypeDescription().getName()), (String)"Unexpected class in %s", unloaded);
            Verify.verify((boolean)unloaded.getAuxiliaryTypes().isEmpty(), (String)"Auxiliary types present in %s", unloaded);
            this.dumpBytecode(unloaded);
            this.processDependencies((Collection<Class<?>>)result.getDependencies());
            return generator.customizeLoading(() -> unloaded.load((ClassLoader)this, STRATEGY).getLoaded());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Class<?> loadClass(String fqcn, byte[] byteCode) {
        Object object = this.getClassLoadingLock(fqcn);
        synchronized (object) {
            Class<?> existing = this.findLoadedClass(fqcn);
            Verify.verify((existing == null ? 1 : 0) != 0, (String)"Attempted to load existing %s", existing);
            return this.defineClass(fqcn, byteCode, 0, byteCode.length);
        }
    }

    private void processDependencies(Collection<Class<?>> deps) {
        HashSet<LeafBindingClassLoader> depLoaders = new HashSet<LeafBindingClassLoader>();
        for (Class<?> dep : deps) {
            ClassLoader depLoader = dep.getClassLoader();
            Verify.verify((boolean)(depLoader instanceof BindingClassLoader), (String)"Dependency %s is not a generated class", dep);
            if (this.equals(depLoader)) continue;
            try {
                this.loadClass(dep.getName());
            }
            catch (ClassNotFoundException e) {
                LOG.debug("Cannot find {} in local loader, attempting to compensate", dep, (Object)e);
                Verify.verify((boolean)(depLoader instanceof LeafBindingClassLoader), (String)"Dependency loader %s is not a leaf", (Object)depLoader);
                depLoaders.add((LeafBindingClassLoader)depLoader);
            }
        }
        if (!depLoaders.isEmpty()) {
            this.appendLoaders(depLoaders);
        }
    }

    private void dumpBytecode(DynamicType.Unloaded<?> unloaded) {
        File dir = this.dumpDir;
        if (dir != null) {
            try {
                unloaded.saveIn(dir);
            }
            catch (IOException | IllegalArgumentException e) {
                LOG.info("Failed to save {}", (Object)unloaded.getTypeDescription().getName(), (Object)e);
            }
        }
    }

    static {
        Verify.verify((boolean)ClassLoader.registerAsParallelCapable());
        LOG = LoggerFactory.getLogger(BindingClassLoader.class);
    }

    public static interface ClassGenerator<T> {
        public GeneratorResult<T> generateClass(BindingClassLoader var1, String var2, Class<?> var3);

        default public Class<T> customizeLoading(@NonNull Supplier<Class<T>> loader) {
            return loader.get();
        }
    }

    public static final class GeneratorResult<T> {
        private final @NonNull ImmutableSet<Class<?>> dependecies;
        private final // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull DynamicType.Unloaded<T> result;

        GeneratorResult(DynamicType.Unloaded<T> result, ImmutableSet<Class<?>> dependecies) {
            this.result = Objects.requireNonNull(result);
            this.dependecies = Objects.requireNonNull(dependecies);
        }

        public static <T> @NonNull GeneratorResult<T> of(DynamicType.Unloaded<T> result) {
            return new GeneratorResult<T>(result, ImmutableSet.of());
        }

        public static <T> @NonNull GeneratorResult<T> of(DynamicType.Unloaded<T> result, Collection<Class<?>> dependencies) {
            return dependencies.isEmpty() ? GeneratorResult.of(result) : new GeneratorResult<T>(result, ImmutableSet.copyOf(dependencies));
        }

        // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull DynamicType.Unloaded<T> getResult() {
            return this.result;
        }

        @NonNull ImmutableSet<Class<?>> getDependencies() {
            return this.dependecies;
        }
    }
}

