/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ActionDefinition;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.MustDefinition;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathExpression;

public final class ContainerSchemaNodes {
    private ContainerSchemaNodes() {
    }

    @Beta
    public static @NonNull ContainerLike forNotification(NotificationDefinition notification) {
        return new NotificationContainerSchemaNode(notification);
    }

    @Beta
    public static @NonNull ContainerLike forRPC(RpcDefinition rpc) {
        return new RpcContainerSchemaNode(rpc);
    }

    private static final class NotificationContainerSchemaNode
    extends AbstractContainerSchemaNode<NotificationDefinition> {
        private final ImmutableMap<QName, ? extends DataSchemaNode> mapNodes;

        private NotificationContainerSchemaNode(NotificationDefinition notification) {
            super(notification);
            this.mapNodes = Maps.uniqueIndex((Iterable)notification.getChildNodes(), SchemaNode::getQName);
        }

        public Collection<? extends NotificationDefinition> getNotifications() {
            return ImmutableSet.of((Object)((NotificationDefinition)this.schemaNode));
        }

        public Collection<? extends AugmentationSchemaNode> getAvailableAugmentations() {
            return ((NotificationDefinition)this.schemaNode).getAvailableAugmentations();
        }

        public Collection<? extends TypeDefinition<?>> getTypeDefinitions() {
            return ((NotificationDefinition)this.schemaNode).getTypeDefinitions();
        }

        public Collection<? extends DataSchemaNode> getChildNodes() {
            return ((NotificationDefinition)this.schemaNode).getChildNodes();
        }

        public Collection<? extends GroupingDefinition> getGroupings() {
            return ((NotificationDefinition)this.schemaNode).getGroupings();
        }

        public DataSchemaNode dataChildByName(QName name) {
            return (DataSchemaNode)this.mapNodes.get((Object)Objects.requireNonNull(name));
        }

        @Deprecated(forRemoval=true)
        public boolean isAddedByUses() {
            return false;
        }

        public Collection<? extends ActionDefinition> getActions() {
            return ImmutableSet.of();
        }
    }

    private static final class RpcContainerSchemaNode
    extends AbstractContainerSchemaNode<RpcDefinition> {
        RpcContainerSchemaNode(RpcDefinition rpcDefinition) {
            super(rpcDefinition);
        }

        public Collection<? extends GroupingDefinition> getGroupings() {
            return ((RpcDefinition)this.schemaNode).getGroupings();
        }

        public Collection<? extends TypeDefinition<?>> getTypeDefinitions() {
            return ((RpcDefinition)this.schemaNode).getTypeDefinitions();
        }

        public Collection<? extends AugmentationSchemaNode> getAvailableAugmentations() {
            return ImmutableSet.of();
        }

        public Collection<? extends DataSchemaNode> getChildNodes() {
            return ImmutableList.of((Object)((RpcDefinition)this.schemaNode).getInput(), (Object)((RpcDefinition)this.schemaNode).getOutput());
        }

        public DataSchemaNode dataChildByName(QName name) {
            return switch (name.getLocalName()) {
                case "input" -> ((RpcDefinition)this.schemaNode).getInput();
                case "output" -> ((RpcDefinition)this.schemaNode).getOutput();
                default -> null;
            };
        }

        @Deprecated(forRemoval=true)
        public boolean isAddedByUses() {
            return false;
        }

        public Collection<? extends ActionDefinition> getActions() {
            return ImmutableSet.of();
        }

        public Collection<? extends NotificationDefinition> getNotifications() {
            return ImmutableSet.of();
        }
    }

    private static abstract class AbstractContainerSchemaNode<T extends SchemaNode>
    implements ContainerLike {
        final T schemaNode;

        AbstractContainerSchemaNode(T schemaNode) {
            this.schemaNode = schemaNode;
        }

        public Collection<? extends UsesNode> getUses() {
            return ImmutableSet.of();
        }

        @Deprecated
        public boolean isAugmenting() {
            return false;
        }

        public Optional<Boolean> effectiveConfig() {
            return Optional.empty();
        }

        public QName getQName() {
            return this.schemaNode.getQName();
        }

        public Optional<String> getDescription() {
            return this.schemaNode.getDescription();
        }

        public Optional<String> getReference() {
            return this.schemaNode.getReference();
        }

        public Status getStatus() {
            return this.schemaNode.getStatus();
        }

        public Collection<? extends @NonNull MustDefinition> getMustConstraints() {
            return ImmutableList.of();
        }

        public Optional<? extends YangXPathExpression.QualifiedBound> getWhenCondition() {
            return Optional.empty();
        }
    }
}

