/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.util.AbstractInteriorContextNode;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

abstract class DataContainerContextNode<T extends YangInstanceIdentifier.PathArgument>
extends AbstractInteriorContextNode<T> {
    private final ConcurrentMap<YangInstanceIdentifier.PathArgument, DataSchemaContextNode<?>> byArg = new ConcurrentHashMap();
    private final ConcurrentMap<QName, DataSchemaContextNode<?>> byQName = new ConcurrentHashMap();
    private final DataNodeContainer container;

    DataContainerContextNode(T identifier, DataNodeContainer container, DataSchemaNode schema) {
        super(identifier, schema);
        this.container = Objects.requireNonNull(container);
    }

    @Override
    public DataSchemaContextNode<?> getChild(YangInstanceIdentifier.PathArgument child) {
        DataSchemaContextNode<?> potential = (DataSchemaContextNode<?>)((Object)this.byArg.get(child));
        if (potential != null) {
            return potential;
        }
        potential = this.fromLocalSchema(child);
        return this.register(potential);
    }

    @Override
    public DataSchemaContextNode<?> getChild(QName child) {
        DataSchemaContextNode<?> potential = (DataSchemaContextNode<?>)((Object)this.byQName.get(child));
        if (potential != null) {
            return potential;
        }
        potential = this.fromLocalSchemaAndQName(this.container, child);
        return this.register(potential);
    }

    @Override
    protected final DataSchemaContextNode<?> enterChild(QName child, SchemaInferenceStack stack) {
        return DataContainerContextNode.pushToStack(this.getChild(child), stack);
    }

    @Override
    protected final DataSchemaContextNode<?> enterChild(YangInstanceIdentifier.PathArgument child, SchemaInferenceStack stack) {
        return DataContainerContextNode.pushToStack(this.getChild(child), stack);
    }

    private static @Nullable DataSchemaContextNode<?> pushToStack(@Nullable DataSchemaContextNode<?> child, @NonNull SchemaInferenceStack stack) {
        if (child != null) {
            child.pushToStack(stack);
        }
        return child;
    }

    private DataSchemaContextNode<?> fromLocalSchema(YangInstanceIdentifier.PathArgument child) {
        if (child instanceof YangInstanceIdentifier.AugmentationIdentifier) {
            YangInstanceIdentifier.AugmentationIdentifier augId = (YangInstanceIdentifier.AugmentationIdentifier)child;
            return DataContainerContextNode.fromSchemaAndQNameChecked(this.container, (QName)augId.getPossibleChildNames().iterator().next());
        }
        return DataContainerContextNode.fromSchemaAndQNameChecked(this.container, child.getNodeType());
    }

    protected DataSchemaContextNode<?> fromLocalSchemaAndQName(DataNodeContainer schema, QName child) {
        return DataContainerContextNode.fromSchemaAndQNameChecked(schema, child);
    }

    private DataSchemaContextNode<?> register(DataSchemaContextNode<?> potential) {
        if (potential != null) {
            this.byArg.put((YangInstanceIdentifier.PathArgument)potential.getIdentifier(), potential);
            for (QName qname : potential.getQNameIdentifiers()) {
                this.byQName.put(qname, potential);
            }
        }
        return potential;
    }
}

