/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.runtime.spi;

import com.google.common.annotations.Beta;
import com.google.common.base.Throwables;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeGenerator;
import org.opendaylight.mdsal.binding.runtime.api.DefaultBindingRuntimeContext;
import org.opendaylight.mdsal.binding.runtime.api.ModuleInfoSnapshot;
import org.opendaylight.mdsal.binding.runtime.spi.ModuleInfoSnapshotBuilder;
import org.opendaylight.mdsal.binding.runtime.spi.ServiceLoaderState;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.parser.api.YangParserException;
import org.opendaylight.yangtools.yang.parser.api.YangParserFactory;

@Beta
public final class BindingRuntimeHelpers {
    private BindingRuntimeHelpers() {
    }

    public static @NonNull EffectiveModelContext createEffectiveModel(Class<?> ... classes) {
        return BindingRuntimeHelpers.createEffectiveModel(Arrays.stream(classes).map(BindingRuntimeHelpers::extractYangModuleInfo).collect(Collectors.toList()));
    }

    public static @NonNull EffectiveModelContext createEffectiveModel(Iterable<? extends YangModuleInfo> moduleInfos) {
        try {
            return BindingRuntimeHelpers.createEffectiveModel(ServiceLoaderState.ParserFactory.INSTANCE, moduleInfos);
        }
        catch (YangParserException e) {
            throw new IllegalStateException("Failed to parse models", e);
        }
    }

    public static @NonNull EffectiveModelContext createEffectiveModel(YangParserFactory parserFactory, Iterable<? extends YangModuleInfo> moduleInfos) throws YangParserException {
        return BindingRuntimeHelpers.prepareContext(parserFactory, moduleInfos).getEffectiveModelContext();
    }

    public static @NonNull BindingRuntimeContext createRuntimeContext() {
        ModuleInfoSnapshot infos;
        try {
            infos = BindingRuntimeHelpers.prepareContext(ServiceLoaderState.ParserFactory.INSTANCE, (Iterable<? extends YangModuleInfo>)BindingReflections.loadModuleInfos());
        }
        catch (YangParserException e) {
            throw new IllegalStateException("Failed to parse models", e);
        }
        return new DefaultBindingRuntimeContext(ServiceLoaderState.Generator.INSTANCE.generateTypeMapping(infos.getEffectiveModelContext()), infos);
    }

    public static @NonNull BindingRuntimeContext createRuntimeContext(Class<?> ... classes) {
        try {
            return BindingRuntimeHelpers.createRuntimeContext(ServiceLoaderState.ParserFactory.INSTANCE, ServiceLoaderState.Generator.INSTANCE, classes);
        }
        catch (YangParserException e) {
            throw new IllegalStateException("Failed to parse models", e);
        }
    }

    public static @NonNull BindingRuntimeContext createRuntimeContext(Collection<? extends YangModuleInfo> infos) {
        ModuleInfoSnapshot snapshot;
        try {
            snapshot = BindingRuntimeHelpers.prepareContext(ServiceLoaderState.ParserFactory.INSTANCE, infos);
        }
        catch (YangParserException e) {
            throw new IllegalStateException("Failed to parse models", e);
        }
        return new DefaultBindingRuntimeContext(ServiceLoaderState.Generator.INSTANCE.generateTypeMapping(snapshot.getEffectiveModelContext()), snapshot);
    }

    public static @NonNull BindingRuntimeContext createRuntimeContext(YangParserFactory parserFactory, BindingRuntimeGenerator generator, Class<?> ... classes) throws YangParserException {
        return BindingRuntimeHelpers.createRuntimeContext(parserFactory, generator, Arrays.asList(classes));
    }

    public static @NonNull BindingRuntimeContext createRuntimeContext(YangParserFactory parserFactory, BindingRuntimeGenerator generator, Collection<Class<?>> classes) throws YangParserException {
        ModuleInfoSnapshot infos = BindingRuntimeHelpers.prepareContext(parserFactory, classes.stream().map(BindingRuntimeHelpers::extractYangModuleInfo).collect(Collectors.toList()));
        return new DefaultBindingRuntimeContext(generator.generateTypeMapping(infos.getEffectiveModelContext()), infos);
    }

    private static @NonNull YangModuleInfo extractYangModuleInfo(Class<?> clazz) {
        try {
            return BindingReflections.getModuleInfo(clazz);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException("Failed to extract module info from " + clazz, e);
        }
    }

    private static @NonNull ModuleInfoSnapshot prepareContext(YangParserFactory parserFactory, Iterable<? extends YangModuleInfo> moduleInfos) throws YangParserException {
        return new ModuleInfoSnapshotBuilder(parserFactory).add(moduleInfos).build();
    }
}

