/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.checkerframework.checker.regex.qual.Regex;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Immutable;

public final class Revision
implements Comparable<Revision>,
Immutable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final @Regex String STRING_FORMAT_PATTERN_STR = "\\d\\d\\d\\d\\-\\d\\d-\\d\\d";
    public static final Pattern STRING_FORMAT_PATTERN = Pattern.compile("\\d\\d\\d\\d\\-\\d\\d-\\d\\d");
    public static final Revision MAX_VALUE = Revision.of("9999-12-31");
    private final @NonNull String str;

    private Revision(@NonNull String str) {
        FORMATTER.parse(str);
        this.str = str;
    }

    public static @NonNull Revision of(@NonNull String str) {
        return new Revision(str);
    }

    public static @NonNull Optional<Revision> ofNullable(@Nullable String str) {
        return str == null ? Optional.empty() : Optional.of(new Revision(str));
    }

    public static int compare(@NonNull Optional<Revision> first, @NonNull Optional<Revision> second) {
        if (first.isPresent()) {
            return second.isPresent() ? first.orElseThrow().compareTo(second.orElseThrow()) : 1;
        }
        return second.isPresent() ? -1 : 0;
    }

    public static int compare(@Nullable Revision first, @Nullable Revision second) {
        if (first != null) {
            return second != null ? first.compareTo(second) : 1;
        }
        return second != null ? -1 : 0;
    }

    @Override
    public int compareTo(Revision o) {
        return this.str.compareTo(o.str);
    }

    public int hashCode() {
        return this.str.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Revision)) return false;
        Revision other = (Revision)obj;
        if (!this.str.equals(other.str)) return false;
        return true;
    }

    public String toString() {
        return this.str;
    }

    Object writeReplace() {
        return new Proxy(this.str);
    }

    private static final class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private String str;

        public Proxy() {
        }

        Proxy(String str) {
            this.str = Objects.requireNonNull(str);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.str);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.str = (String)in.readObject();
        }

        private Object readResolve() {
            return Revision.of(Objects.requireNonNull(this.str));
        }
    }
}

