/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.threadpool.util;

import java.io.Closeable;
import java.util.OptionalInt;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.config.threadpool.ThreadPool;

public class FlexibleThreadPoolWrapper
implements ThreadPool,
Closeable {
    private final ThreadPoolExecutor executor;

    public FlexibleThreadPoolWrapper(int minThreadCount, int maxThreadCount, long keepAlive, TimeUnit timeUnit, ThreadFactory threadFactory) {
        this(minThreadCount, maxThreadCount, keepAlive, timeUnit, threadFactory, (BlockingQueue<Runnable>)((Object)FlexibleThreadPoolWrapper.getQueue(OptionalInt.empty())));
    }

    public FlexibleThreadPoolWrapper(int minThreadCount, int maxThreadCount, long keepAlive, TimeUnit timeUnit, ThreadFactory threadFactory, OptionalInt queueCapacity) {
        this(minThreadCount, maxThreadCount, keepAlive, timeUnit, threadFactory, (BlockingQueue<Runnable>)((Object)FlexibleThreadPoolWrapper.getQueue(queueCapacity)));
    }

    private FlexibleThreadPoolWrapper(int minThreadCount, int maxThreadCount, long keepAlive, TimeUnit timeUnit, ThreadFactory threadFactory, BlockingQueue<Runnable> queue) {
        this.executor = new ThreadPoolExecutor(minThreadCount, maxThreadCount, keepAlive, timeUnit, queue, threadFactory, new FlexibleRejectionHandler());
        this.executor.prestartAllCoreThreads();
    }

    private static ForwardingBlockingQueue getQueue(OptionalInt capacity) {
        return new ForwardingBlockingQueue(capacity.isPresent() ? new LinkedBlockingQueue(capacity.orElseThrow()) : new LinkedBlockingQueue());
    }

    public ExecutorService getExecutor() {
        return Executors.unconfigurableExecutorService(this.executor);
    }

    public int getMinThreadCount() {
        return this.executor.getCorePoolSize();
    }

    public void setMinThreadCount(int minThreadCount) {
        this.executor.setCorePoolSize(minThreadCount);
    }

    public int getMaxThreadCount() {
        return this.executor.getMaximumPoolSize();
    }

    public void setMaxThreadCount(int maxThreadCount) {
        this.executor.setMaximumPoolSize(maxThreadCount);
    }

    public long getKeepAliveMillis() {
        return this.executor.getKeepAliveTime(TimeUnit.MILLISECONDS);
    }

    public void setKeepAliveMillis(long keepAliveMillis) {
        this.executor.setKeepAliveTime(keepAliveMillis, TimeUnit.MILLISECONDS);
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.executor.setThreadFactory(threadFactory);
    }

    public void prestartAllCoreThreads() {
        this.executor.prestartAllCoreThreads();
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }

    private static final class ForwardingBlockingQueue
    extends com.google.common.util.concurrent.ForwardingBlockingQueue<Runnable> {
        private final BlockingQueue<Runnable> delegate;

        ForwardingBlockingQueue(BlockingQueue<Runnable> delegate) {
            this.delegate = delegate;
        }

        protected BlockingQueue<Runnable> delegate() {
            return this.delegate;
        }

        public boolean offer(Runnable o) {
            return false;
        }
    }

    private static final class FlexibleRejectionHandler
    implements RejectedExecutionHandler {
        private FlexibleRejectionHandler() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                throw new RejectedExecutionException("Interrupted while waiting on the queue", e);
            }
        }
    }
}

