/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.singleton.dom.impl;

import com.google.common.base.Verify;
import com.google.common.util.concurrent.ListenableFuture;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.singleton.dom.impl.ClusterSingletonServiceGroupImpl;

@NonNullByDefault
@SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF_NONVIRTUAL"}, justification="SpotBugs does not grok @Nullable field")
final class ServiceInfo {
    private static final ServiceInfo STARTED = new ServiceInfo(ClusterSingletonServiceGroupImpl.ServiceState.STARTED, null);
    private final @Nullable ListenableFuture<?> future;
    private final ClusterSingletonServiceGroupImpl.ServiceState state;

    private ServiceInfo(ClusterSingletonServiceGroupImpl.ServiceState state, @Nullable ListenableFuture<?> future) {
        this.state = Objects.requireNonNull(state);
        this.future = future;
    }

    static ServiceInfo started() {
        return STARTED;
    }

    ClusterSingletonServiceGroupImpl.ServiceState getState() {
        return this.state;
    }

    ListenableFuture<?> getFuture() {
        return (ListenableFuture)Verify.verifyNotNull(this.future);
    }

    ServiceInfo toState(ClusterSingletonServiceGroupImpl.ServiceState newState) {
        Verify.verify((this.state != newState ? 1 : 0) != 0, (String)"Attempted to re-transition into %s", (Object)((Object)this.state));
        return new ServiceInfo(newState, null);
    }

    ServiceInfo toState(ClusterSingletonServiceGroupImpl.ServiceState newState, ListenableFuture<?> newFuture) {
        Verify.verify((this.state != newState ? 1 : 0) != 0, (String)"Attempted to re-transition into %s", (Object)((Object)this.state));
        return new ServiceInfo(newState, Objects.requireNonNull(newFuture));
    }
}

