/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.configuration.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.ops4j.pax.web.service.undertow.internal.configuration.ParserUtils;
import org.xml.sax.Locator;

public class SecurityRealm {
    private static final QName ATT_NAME = new QName("name");
    private String name;
    private ServerIdentities identities;
    private Authentication authentication;
    private String userPrincipalClassName;
    private final List<String> rolePrincipalClassNames = new ArrayList<String>();

    public static SecurityRealm create(Map<QName, String> attributes) {
        SecurityRealm realm = new SecurityRealm();
        realm.name = attributes.get(ATT_NAME);
        return realm;
    }

    public ServerIdentities getIdentities() {
        return this.identities;
    }

    public void setIdentities(ServerIdentities identities) {
        this.identities = identities;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUserPrincipalClassName() {
        return this.userPrincipalClassName;
    }

    public void setUserPrincipalClassName(String userPrincipalClassName) {
        this.userPrincipalClassName = userPrincipalClassName;
    }

    public List<String> getRolePrincipalClassNames() {
        return this.rolePrincipalClassNames;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{\n");
        sb.append("\t\t\tname: ").append(this.name);
        if (this.identities != null) {
            sb.append("\n\t\t\tssl: ").append(this.identities.getSsl());
        }
        sb.append("\n\t\t\tauthentication: ").append(this.authentication);
        sb.append("\n\t\t\tuser principal class name: ").append(this.userPrincipalClassName);
        sb.append("\n\t\t\trole principal class names: ").append(this.rolePrincipalClassNames);
        sb.append("\n\t\t}");
        return sb.toString();
    }

    public static class User {
        protected static final QName ATT_USERNAME = new QName("username");
        private String username;
        private String password;

        public static User create(Map<QName, String> attributes, Locator locator) {
            User user = new User();
            user.username = attributes.get(ATT_USERNAME);
            return user;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String toString() {
            return this.username + "/***";
        }
    }

    public static class UsersAuth {
        private final List<User> users = new ArrayList<User>();

        public List<User> getUsers() {
            return this.users;
        }

        public String toString() {
            return "{ users: " + this.users + " }";
        }
    }

    public static class PropertiesAuth {
        protected static final QName ATT_PATH = new QName("path");
        private String path;

        public static PropertiesAuth create(Map<QName, String> attributes, Locator locator) {
            PropertiesAuth auth = new PropertiesAuth();
            auth.path = attributes.get(ATT_PATH);
            return auth;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String toString() {
            return "{ path: " + this.path + " }";
        }
    }

    public static class JaasAuth {
        protected static final QName ATT_NAME = new QName("name");
        private String name;

        public static JaasAuth create(Map<QName, String> attributes, Locator locator) {
            JaasAuth auth = new JaasAuth();
            auth.name = attributes.get(ATT_NAME);
            return auth;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return "{ name: " + this.name + " }";
        }
    }

    public static class Keystore
    extends Truststore {
        protected static final QName ATT_ALIAS = new QName("alias");
        protected static final QName ATT_KEY_PASSWORD = new QName("key-password");
        protected static final QName ATT_GENERATE_SELF_SIGNED_CERTIFICATE_HOST = new QName("generate-self-signed-certificate-host");
        private String alias;
        private String keyPassword;
        private String generateSelfSignedCertificateHost;

        public static Keystore create(Map<QName, String> attributes, Locator locator) {
            Keystore keystore = new Keystore();
            keystore.type = attributes.get(ATT_PROVIDER);
            keystore.path = attributes.get(ATT_PATH);
            keystore.password = attributes.get(ATT_KEYSTORE_PASSWORD);
            keystore.alias = attributes.get(ATT_ALIAS);
            keystore.keyPassword = attributes.get(ATT_KEY_PASSWORD);
            keystore.generateSelfSignedCertificateHost = attributes.get(ATT_GENERATE_SELF_SIGNED_CERTIFICATE_HOST);
            return keystore;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public String getKeyPassword() {
            return this.keyPassword;
        }

        public void setKeyPassword(String keyPassword) {
            this.keyPassword = keyPassword;
        }

        public String getGenerateSelfSignedCertificateHost() {
            return this.generateSelfSignedCertificateHost;
        }

        public void setGenerateSelfSignedCertificateHost(String generateSelfSignedCertificateHost) {
            this.generateSelfSignedCertificateHost = generateSelfSignedCertificateHost;
        }

        @Override
        public String toString() {
            return "{ provider: " + this.getType() + ", path: " + this.getPath() + ", alias: " + this.alias + " }";
        }
    }

    public static class Truststore {
        protected static final QName ATT_PROVIDER = new QName("provider");
        protected static final QName ATT_PATH = new QName("path");
        protected static final QName ATT_KEYSTORE_PASSWORD = new QName("keystore-password");
        protected String type;
        protected String path;
        protected String password;

        public static Truststore create(Map<QName, String> attributes, Locator locator) {
            Truststore truststore = new Truststore();
            truststore.type = attributes.get(ATT_PROVIDER);
            truststore.path = attributes.get(ATT_PATH);
            truststore.password = attributes.get(ATT_KEYSTORE_PASSWORD);
            return truststore;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String toString() {
            return "{ provider: " + this.type + ", path: " + this.path + " }";
        }
    }

    public static class Engine {
        private static final QName ATT_ENABLED_CIPHER_SUITES = new QName("enabled-cipher-suites");
        private static final QName ATT_ENABLED_PROTOCOLS = new QName("enabled-protocols");
        private final List<String> enabledCipherSuites = new ArrayList<String>();
        private final List<String> enabledProtocols = new ArrayList<String>();

        public static Engine create(Map<QName, String> attributes, Locator locator) {
            Engine engine = new Engine();
            engine.getEnabledCipherSuites().addAll(ParserUtils.toStringList(attributes.get(ATT_ENABLED_CIPHER_SUITES), locator));
            engine.getEnabledProtocols().addAll(ParserUtils.toStringList(attributes.get(ATT_ENABLED_PROTOCOLS), locator));
            return engine;
        }

        public List<String> getEnabledCipherSuites() {
            return this.enabledCipherSuites;
        }

        public List<String> getEnabledProtocols() {
            return this.enabledProtocols;
        }

        public String toString() {
            return "{ enabled ciphers: " + this.enabledCipherSuites + ", enabled protocols: " + this.enabledProtocols + " }";
        }
    }

    public static class Authentication {
        private Truststore truststore;
        private JaasAuth jaas;
        private PropertiesAuth properties;
        private UsersAuth users;

        public Truststore getTruststore() {
            return this.truststore;
        }

        public void setTruststore(Truststore truststore) {
            this.truststore = truststore;
        }

        public JaasAuth getJaas() {
            return this.jaas;
        }

        public void setJaas(JaasAuth jaas) {
            this.jaas = jaas;
        }

        public PropertiesAuth getProperties() {
            return this.properties;
        }

        public void setProperties(PropertiesAuth properties) {
            this.properties = properties;
        }

        public UsersAuth getUsers() {
            return this.users;
        }

        public void setUsers(UsersAuth users) {
            this.users = users;
        }

        public String toString() {
            return "{ truststore: " + this.truststore + ", jaas: " + this.jaas + ", properties: " + this.properties + ", users: " + this.users + " }";
        }
    }

    public static class SSLConfig {
        private Engine engine;
        private Keystore keystore;

        public Engine getEngine() {
            return this.engine;
        }

        public void setEngine(Engine engine) {
            this.engine = engine;
        }

        public Keystore getKeystore() {
            return this.keystore;
        }

        public void setKeystore(Keystore keystore) {
            this.keystore = keystore;
        }

        public String toString() {
            return "{\n\t\t\t\tengine: " + this.engine + "\n\t\t\t\tkeystore: " + this.keystore + "\n\t\t\t}";
        }
    }

    public static class ServerIdentities {
        private SSLConfig ssl;

        public SSLConfig getSsl() {
            return this.ssl;
        }

        public void setSsl(SSLConfig ssl) {
            this.ssl = ssl;
        }
    }
}

