/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.configuration.model;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.ops4j.pax.web.service.undertow.internal.configuration.ParserUtils;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import org.xnio.SslClientAuthMode;

public class Server {
    protected static final QName ATT_NAME = new QName("name");
    private String name;
    private final List<HttpListener> httpListeners = new LinkedList<HttpListener>();
    private final List<HttpsListener> httpsListeners = new LinkedList<HttpsListener>();
    private Host host;

    public static Server create(Map<QName, String> attributes, Locator locator) {
        Server server = new Server();
        server.name = attributes.get(ATT_NAME);
        return server;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<HttpListener> getHttpListeners() {
        return this.httpListeners;
    }

    public List<HttpsListener> getHttpsListeners() {
        return this.httpsListeners;
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    public String toString() {
        return "{\n\t\t\tname: " + this.name + "\n\t\t\thttp listeners: " + this.httpListeners + "\n\t\t\thttps listeners: " + this.httpsListeners + "\n\t\t\thost: " + this.host + "\n\t\t}";
    }

    public static class Host {
        protected static final QName ATT_NAME = new QName("name");
        protected static final QName ATT_ALIAS = new QName("alias");
        private String name;
        private String alias;
        private final List<Location> location = new ArrayList<Location>();
        private AccessLog accessLog;
        private final List<FilterRef> filterRef = new ArrayList<FilterRef>();

        public static Host create(Map<QName, String> attributes, Locator locator) {
            Host host = new Host();
            host.name = attributes.get(ATT_NAME);
            host.alias = attributes.get(ATT_ALIAS);
            return host;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public List<Location> getLocations() {
            return this.location;
        }

        public AccessLog getAccessLog() {
            return this.accessLog;
        }

        public void setAccessLog(AccessLog accessLog) {
            this.accessLog = accessLog;
        }

        public List<FilterRef> getFilterRefs() {
            return this.filterRef;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("{ ");
            sb.append("name: ").append(this.name);
            sb.append(", alias: ").append(this.alias);
            sb.append(", locations: ").append(this.location);
            sb.append(", access log: ").append(this.accessLog);
            sb.append(", filter refs: ").append(this.filterRef);
            sb.append(" }");
            return sb.toString();
        }

        public static class FilterRef {
            protected static final QName ATT_NAME = new QName("name");
            protected static final QName ATT_PREDICATE = new QName("predicate");
            private String name;
            private String predicate;

            public static FilterRef create(Map<QName, String> attributes, Locator locator) {
                FilterRef ref = new FilterRef();
                ref.name = attributes.get(ATT_NAME);
                ref.predicate = attributes.get(ATT_PREDICATE);
                return ref;
            }

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getPredicate() {
                return this.predicate;
            }

            public void setPredicate(String predicate) {
                this.predicate = predicate;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder("{ ");
                sb.append("name: ").append(this.name);
                sb.append(", predicate: ").append(this.predicate);
                sb.append(" }");
                return sb.toString();
            }
        }

        public static class AccessLog {
            protected static final QName ATT_PATTERN = new QName("pattern");
            protected static final QName ATT_DIRECTORY = new QName("directory");
            protected static final QName ATT_PREFIX = new QName("prefix");
            protected static final QName ATT_SUFFIX = new QName("suffix");
            protected static final QName ATT_ROTATE = new QName("rotate");
            private String pattern = "common";
            private String directory;
            private String prefix = "access_log.";
            private String suffix = "log";
            private String rotate = "true";

            public static AccessLog create(Map<QName, String> attributes, Locator locator) {
                AccessLog al = new AccessLog();
                al.pattern = ParserUtils.toStringValue(attributes.get(ATT_PATTERN), locator, "common");
                al.directory = attributes.get(ATT_DIRECTORY);
                al.prefix = ParserUtils.toStringValue(attributes.get(ATT_PREFIX), locator, "access_log.");
                al.suffix = ParserUtils.toStringValue(attributes.get(ATT_SUFFIX), locator, "log");
                al.rotate = ParserUtils.toStringValue(attributes.get(ATT_ROTATE), locator, "true");
                return al;
            }

            public String getPattern() {
                return this.pattern;
            }

            public void setPattern(String pattern) {
                this.pattern = pattern;
            }

            public String getDirectory() {
                return this.directory;
            }

            public void setDirectory(String directory) {
                this.directory = directory;
            }

            public String getPrefix() {
                return this.prefix;
            }

            public void setPrefix(String prefix) {
                this.prefix = prefix;
            }

            public String getSuffix() {
                return this.suffix;
            }

            public void setSuffix(String suffix) {
                this.suffix = suffix;
            }

            public String getRotate() {
                return this.rotate;
            }

            public void setRotate(String rotate) {
                this.rotate = rotate;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder("{ ");
                sb.append("pattern: '").append(this.pattern).append('\'');
                sb.append(", directory: ").append(this.directory);
                sb.append(", prefix: ").append(this.prefix);
                sb.append(", suffix: ").append(this.suffix);
                sb.append(", rotate: ").append(this.rotate);
                sb.append(" }");
                return sb.toString();
            }
        }

        public static class Location {
            protected static final QName ATT_NAME = new QName("name");
            protected static final QName ATT_HANDLER = new QName("handler");
            private String name;
            private String handler;
            private final List<FilterRef> filterRef = new ArrayList<FilterRef>();

            public static Location create(Map<QName, String> attributes, Locator locator) {
                Location location = new Location();
                location.name = attributes.get(ATT_NAME);
                location.handler = attributes.get(ATT_HANDLER);
                return location;
            }

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getHandler() {
                return this.handler;
            }

            public void setHandler(String handler) {
                this.handler = handler;
            }

            public List<FilterRef> getFilterRefs() {
                return this.filterRef;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder("{ ");
                sb.append("name: ").append(this.name);
                sb.append(", handler: ").append(this.handler);
                sb.append(", filterRef: ").append(this.filterRef);
                sb.append(" }");
                return sb.toString();
            }
        }
    }

    public static class HttpsListener
    extends Listener {
        protected static final QName ATT_SSL_CONTEXT = new QName("ssl-context");
        protected static final QName ATT_CERTIFICATE_FORWARDING = new QName("certificate-forwarding");
        protected static final QName ATT_PROXY_ADDRESS_FORWARDING = new QName("proxy-address-forwarding");
        protected static final QName ATT_SECURITY_REALM = new QName("security-realm");
        protected static final QName ATT_VERIFY_CLIENT = new QName("verify-client");
        protected static final QName ATT_ENABLED_CIPHER_SUITES = new QName("enabled-cipher-suites");
        protected static final QName ATT_ENABLED_PROTOCOLS = new QName("enabled-protocols");
        protected static final QName ATT_ENABLE_HTTP2 = new QName("enable-http2");
        protected static final QName ATT_ENABLE_SPDY = new QName("enable-spdy");
        protected static final QName ATT_SSL_SESSION_CACHE_SIZE = new QName("ssl-session-cache-size");
        protected static final QName ATT_SSL_SESSION_TIMEOUT = new QName("ssl-session-timeout");
        protected static final QName ATT_HTTP2_ENABLE_PUSH = new QName("http2-enable-push");
        protected static final QName ATT_HTTP2_HEADER_TABLE_SIZE = new QName("http2-header-table-size");
        protected static final QName ATT_HTTP2_INITIAL_WINDOW_SIZE = new QName("http2-initial-window-size");
        protected static final QName ATT_HTTP2_MAX_CONCURRENT_STREAMS = new QName("http2-max-concurrent-streams");
        protected static final QName ATT_HTTP2_MAX_FRAME_SIZE = new QName("http2-max-frame-size");
        protected static final QName ATT_HTTP2_MAX_HEADER_LIST_SIZE = new QName("http2-max-header-list-size");
        protected static final QName ATT_REQUIRE_HOST_HTTP11 = new QName("require-host-http11");
        protected static final QName ATT_PROXY_PROTOCOL = new QName("proxy-protocol");
        private String sslContext;
        private boolean certificateForwarding = false;
        private boolean proxyAddressForwarding = false;
        private String securityRealm;
        private SslClientAuthMode verifyClient = SslClientAuthMode.NOT_REQUESTED;
        private List<String> enabledCipherSuites = new ArrayList<String>();
        private List<String> enabledProtocols = new ArrayList<String>();
        private boolean enableHttp2 = false;
        @Deprecated
        private boolean enableSpdy = false;
        private int sslSessionCacheSize = 0;
        private int sslSessionTimeout = 0;
        private boolean http2EnablePush = false;
        private int http2HeaderTableSize = 4096;
        private int http2InitialWindowSize = 65535;
        private Integer http2MaxConcurrentStreams = -1;
        private int http2MaxFrameSize = 16384;
        private Integer http2MaxHeaderListSize = 0x100000;
        private boolean requireHostHttp11 = false;
        private boolean proxyProtocol = false;

        public static HttpsListener create(Map<QName, String> attributes, Locator locator) throws SAXParseException {
            HttpsListener listener = new HttpsListener();
            listener.receiveBuffer = ParserUtils.toInteger(attributes.get(ATT_RECEIVE_BUFFER), locator, 65536);
            listener.sendBuffer = ParserUtils.toInteger(attributes.get(ATT_SEND_BUFFER), locator, 65536);
            listener.tcpBacklog = ParserUtils.toInteger(attributes.get(ATT_TCP_BACKLOG), locator, 128);
            listener.tcpKeepAlive = ParserUtils.toBoolean(attributes.get(ATT_TCP_KEEP_ALIVE), locator, false);
            listener.readTimeout = ParserUtils.toInteger(attributes.get(ATT_READ_TIMEOUT), locator, 0);
            listener.writeTimeout = ParserUtils.toInteger(attributes.get(ATT_WRITE_TIMEOUT), locator, 0);
            listener.maxConnections = ParserUtils.toInteger(attributes.get(ATT_MAX_CONNECTIONS), locator, Integer.MAX_VALUE);
            listener.name = attributes.get(ATT_NAME);
            listener.socketBindingName = attributes.get(ATT_SOCKET_BINDING);
            listener.workerName = ParserUtils.toStringValue(attributes.get(ATT_WORKER), locator, "default");
            listener.bufferPoolName = ParserUtils.toStringValue(attributes.get(ATT_BUFFER_POOL), locator, "default");
            listener.enabled = ParserUtils.toBoolean(attributes.get(ATT_ENABLED), locator, true);
            listener.resolvePeerAddress = ParserUtils.toBoolean(attributes.get(ATT_RESOLVE_PEER_ADDRESS), locator, false);
            listener.disallowedMethods.addAll(ParserUtils.toStringList(attributes.get(ATT_DISALLOWED_METHODS), locator));
            listener.secure = ParserUtils.toBoolean(attributes.get(ATT_SECURE), locator, false);
            listener.maxPostSize = ParserUtils.toLong(attributes.get(ATT_MAX_POST_SIZE), locator, 0xA00000L);
            listener.bufferPipelinedData = ParserUtils.toBoolean(attributes.get(ATT_BUFFER_PIPELINED_DATA), locator, false);
            listener.maxHeaderSize = ParserUtils.toInteger(attributes.get(ATT_MAX_HEADER_SIZE), locator, 0x100000);
            listener.maxParameters = ParserUtils.toInteger(attributes.get(ATT_MAX_PARAMETERS), locator, 1000);
            listener.maxHeaders = ParserUtils.toInteger(attributes.get(ATT_MAX_HEADERS), locator, 200);
            listener.maxCookies = ParserUtils.toInteger(attributes.get(ATT_MAX_COOKIES), locator, 200);
            listener.allowEncodedSlash = ParserUtils.toBoolean(attributes.get(ATT_ALLOW_ENCODED_SLASH), locator, false);
            listener.decodeUrl = ParserUtils.toBoolean(attributes.get(ATT_DECODE_URL), locator, true);
            listener.urlCharset = ParserUtils.toStringValue(attributes.get(ATT_URL_CHARSET), locator, StandardCharsets.UTF_8.name());
            listener.alwaysSetKeepAlive = ParserUtils.toBoolean(attributes.get(ATT_ALWAYS_SET_KEEP_ALIVE), locator, true);
            listener.maxBufferedRequestSize = ParserUtils.toInteger(attributes.get(ATT_MAX_BUFFERED_REQUEST_SIZE), locator, 16384);
            listener.recordRequestStartTime = ParserUtils.toBoolean(attributes.get(ATT_RECORD_REQUEST_START_TIME), locator, false);
            listener.allowEqualsInCookieValue = ParserUtils.toBoolean(attributes.get(ATT_ALLOW_EQUALS_IN_COOKIE_VALUE), locator, false);
            listener.noRequestTimeout = ParserUtils.toInteger(attributes.get(ATT_NO_REQUEST_TIMEOUT), locator, 60000);
            listener.requestParseTimeout = ParserUtils.toInteger(attributes.get(ATT_REQUEST_PARSE_TIMEOUT), locator, 60000);
            listener.rfc6265CookieValidation = ParserUtils.toBoolean(attributes.get(ATT_RFC6265_COOKIE_VALIDATION), locator, false);
            listener.allowUnescapedCharactersInUrl = ParserUtils.toBoolean(attributes.get(ATT_ALLOW_UNESCAPED_CHARACTERS_IN_URL), locator, false);
            listener.sslContext = attributes.get(ATT_SSL_CONTEXT);
            listener.certificateForwarding = ParserUtils.toBoolean(attributes.get(ATT_CERTIFICATE_FORWARDING), locator, false);
            listener.proxyAddressForwarding = ParserUtils.toBoolean(attributes.get(ATT_PROXY_ADDRESS_FORWARDING), locator, false);
            listener.securityRealm = attributes.get(ATT_SECURITY_REALM);
            String vc = attributes.get(ATT_VERIFY_CLIENT);
            if (vc == null) {
                listener.verifyClient = SslClientAuthMode.NOT_REQUESTED;
            } else {
                try {
                    listener.verifyClient = SslClientAuthMode.valueOf((String)vc);
                }
                catch (IllegalArgumentException e) {
                    throw new SAXParseException("Can't parse \"" + vc + "\" as valid value for \"verify-client\" attribute", locator);
                }
            }
            listener.enabledCipherSuites.addAll(ParserUtils.toStringList(attributes.get(ATT_ENABLED_CIPHER_SUITES), locator));
            listener.enabledProtocols.addAll(ParserUtils.toStringList(attributes.get(ATT_ENABLED_PROTOCOLS), locator));
            listener.enableHttp2 = ParserUtils.toBoolean(attributes.get(ATT_ENABLE_HTTP2), locator, false);
            listener.enableSpdy = ParserUtils.toBoolean(attributes.get(ATT_ENABLE_HTTP2), locator, false);
            listener.sslSessionCacheSize = ParserUtils.toInteger(attributes.get(ATT_SSL_SESSION_CACHE_SIZE), locator, 0);
            listener.sslSessionTimeout = ParserUtils.toInteger(attributes.get(ATT_SSL_SESSION_TIMEOUT), locator, 0);
            listener.http2EnablePush = ParserUtils.toBoolean(attributes.get(ATT_HTTP2_ENABLE_PUSH), locator, false);
            listener.http2HeaderTableSize = ParserUtils.toInteger(attributes.get(ATT_HTTP2_HEADER_TABLE_SIZE), locator, 4096);
            listener.http2InitialWindowSize = ParserUtils.toInteger(attributes.get(ATT_HTTP2_INITIAL_WINDOW_SIZE), locator, 65535);
            listener.http2MaxConcurrentStreams = ParserUtils.toInteger(attributes.get(ATT_HTTP2_MAX_CONCURRENT_STREAMS), locator, -1);
            listener.http2MaxFrameSize = ParserUtils.toInteger(attributes.get(ATT_HTTP2_MAX_FRAME_SIZE), locator, 16384);
            listener.http2MaxHeaderListSize = ParserUtils.toInteger(attributes.get(ATT_HTTP2_MAX_HEADER_LIST_SIZE), locator, 0x100000);
            listener.requireHostHttp11 = ParserUtils.toBoolean(attributes.get(ATT_REQUIRE_HOST_HTTP11), locator, false);
            listener.proxyProtocol = ParserUtils.toBoolean(attributes.get(ATT_PROXY_PROTOCOL), locator, false);
            return listener;
        }

        public String getSslContext() {
            return this.sslContext;
        }

        public void setSslContext(String sslContext) {
            this.sslContext = sslContext;
        }

        @Override
        public boolean isCertificateForwarding() {
            return this.certificateForwarding;
        }

        public void setCertificateForwarding(boolean certificateForwarding) {
            this.certificateForwarding = certificateForwarding;
        }

        @Override
        public boolean isProxyAddressForwarding() {
            return this.proxyAddressForwarding;
        }

        public void setProxyAddressForwarding(boolean proxyAddressForwarding) {
            this.proxyAddressForwarding = proxyAddressForwarding;
        }

        public String getSecurityRealm() {
            return this.securityRealm;
        }

        public void setSecurityRealm(String securityRealm) {
            this.securityRealm = securityRealm;
        }

        public SslClientAuthMode getVerifyClient() {
            return this.verifyClient;
        }

        public void setVerifyClient(SslClientAuthMode verifyClient) {
            this.verifyClient = verifyClient;
        }

        public List<String> getEnabledCipherSuites() {
            return this.enabledCipherSuites;
        }

        public void setEnabledCipherSuites(List<String> enabledCipherSuites) {
            this.enabledCipherSuites = enabledCipherSuites;
        }

        public List<String> getEnabledProtocols() {
            return this.enabledProtocols;
        }

        public void setEnabledProtocols(List<String> enabledProtocols) {
            this.enabledProtocols = enabledProtocols;
        }

        @Override
        public boolean isEnableHttp2() {
            return this.enableHttp2;
        }

        public void setEnableHttp2(boolean enableHttp2) {
            this.enableHttp2 = enableHttp2;
        }

        public boolean isEnableSpdy() {
            return this.enableSpdy;
        }

        public void setEnableSpdy(boolean enableSpdy) {
            this.enableSpdy = enableSpdy;
        }

        public int getSslSessionCacheSize() {
            return this.sslSessionCacheSize;
        }

        public void setSslSessionCacheSize(int sslSessionCacheSize) {
            this.sslSessionCacheSize = sslSessionCacheSize;
        }

        public int getSslSessionTimeout() {
            return this.sslSessionTimeout;
        }

        public void setSslSessionTimeout(int sslSessionTimeout) {
            this.sslSessionTimeout = sslSessionTimeout;
        }

        @Override
        public boolean isHttp2EnablePush() {
            return this.http2EnablePush;
        }

        public void setHttp2EnablePush(boolean http2EnablePush) {
            this.http2EnablePush = http2EnablePush;
        }

        @Override
        public int getHttp2HeaderTableSize() {
            return this.http2HeaderTableSize;
        }

        public void setHttp2HeaderTableSize(int http2HeaderTableSize) {
            this.http2HeaderTableSize = http2HeaderTableSize;
        }

        @Override
        public int getHttp2InitialWindowSize() {
            return this.http2InitialWindowSize;
        }

        public void setHttp2InitialWindowSize(int http2InitialWindowSize) {
            this.http2InitialWindowSize = http2InitialWindowSize;
        }

        @Override
        public Integer getHttp2MaxConcurrentStreams() {
            return this.http2MaxConcurrentStreams;
        }

        public void setHttp2MaxConcurrentStreams(Integer http2MaxConcurrentStreams) {
            this.http2MaxConcurrentStreams = http2MaxConcurrentStreams;
        }

        @Override
        public int getHttp2MaxFrameSize() {
            return this.http2MaxFrameSize;
        }

        public void setHttp2MaxFrameSize(int http2MaxFrameSize) {
            this.http2MaxFrameSize = http2MaxFrameSize;
        }

        @Override
        public Integer getHttp2MaxHeaderListSize() {
            return this.http2MaxHeaderListSize;
        }

        public void setHttp2MaxHeaderListSize(Integer http2MaxHeaderListSize) {
            this.http2MaxHeaderListSize = http2MaxHeaderListSize;
        }

        @Override
        public boolean isRequireHostHttp11() {
            return this.requireHostHttp11;
        }

        public void setRequireHostHttp11(boolean requireHostHttp11) {
            this.requireHostHttp11 = requireHostHttp11;
        }

        public boolean isProxyProtocol() {
            return this.proxyProtocol;
        }

        public void setProxyProtocol(boolean proxyProtocol) {
            this.proxyProtocol = proxyProtocol;
        }

        @Override
        public boolean isSecure() {
            return true;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("{ ");
            sb.append(this.toStringParameters());
            sb.append(" }");
            return sb.toString();
        }

        @Override
        protected String toStringParameters() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toStringParameters());
            sb.append(", ssl context: ").append(this.sslContext);
            sb.append(", certificate forwarding: ").append(this.certificateForwarding);
            sb.append(", proxy address forwarding: ").append(this.proxyAddressForwarding);
            sb.append(", security realm: ").append(this.securityRealm);
            sb.append(", verify client: ").append(this.verifyClient);
            sb.append(", enabled cipher suites: ").append(this.enabledCipherSuites);
            sb.append(", enabled protocols: ").append(this.enabledProtocols);
            sb.append(", enable http2: ").append(this.enableHttp2);
            sb.append(", enable spdy: ").append(this.enableSpdy);
            sb.append(", ssl session cache size: ").append(this.sslSessionCacheSize);
            sb.append(", ssl session timeout: ").append(this.sslSessionTimeout);
            sb.append(", http2 enable push: ").append(this.http2EnablePush);
            sb.append(", http2 header table size: ").append(this.http2HeaderTableSize);
            sb.append(", http2 initial window size: ").append(this.http2InitialWindowSize);
            sb.append(", http2 max concurrent streams: ").append(this.http2MaxConcurrentStreams);
            sb.append(", http2 max frame size: ").append(this.http2MaxFrameSize);
            sb.append(", http2 max header list size: ").append(this.http2MaxHeaderListSize);
            sb.append(", require host http11: ").append(this.requireHostHttp11);
            sb.append(", proxy protocol: ").append(this.proxyProtocol);
            return sb.toString();
        }
    }

    public static class HttpListener
    extends Listener {
        protected static final QName ATT_CERTIFICATE_FORWARDING = new QName("certificate-forwarding");
        protected static final QName ATT_REDIRECT_SOCKET = new QName("redirect-socket");
        protected static final QName ATT_PROXY_ADDRESS_FORWARDING = new QName("proxy-address-forwarding");
        protected static final QName ATT_ENABLE_HTTP2 = new QName("enable-http2");
        protected static final QName ATT_HTTP2_ENABLE_PUSH = new QName("http2-enable-push");
        protected static final QName ATT_HTTP2_HEADER_TABLE_SIZE = new QName("http2-header-table-size");
        protected static final QName ATT_HTTP2_INITIAL_WINDOW_SIZE = new QName("http2-initial-window-size");
        protected static final QName ATT_HTTP2_MAX_CONCURRENT_STREAMS = new QName("http2-max-concurrent-streams");
        protected static final QName ATT_HTTP2_MAX_FRAME_SIZE = new QName("http2-max-frame-size");
        protected static final QName ATT_HTTP2_MAX_HEADER_LIST_SIZE = new QName("http2-max-header-list-size");
        protected static final QName ATT_REQUIRE_HOST_HTTP11 = new QName("require-host-http11");
        protected static final QName ATT_PROXY_PROTOCOL = new QName("proxy-protocol");
        private boolean certificateForwarding = false;
        private String redirectSocket;
        private boolean proxyAddressForwarding = false;
        private boolean enableHttp2 = false;
        private boolean http2EnablePush = false;
        private int http2HeaderTableSize = 4096;
        private int http2InitialWindowSize = 65535;
        private Integer http2MaxConcurrentStreams = -1;
        private int http2MaxFrameSize = 16384;
        private Integer http2MaxHeaderListSize = 0x100000;
        private boolean requireHostHttp11 = false;
        private boolean proxyProtocol = false;

        public static HttpListener create(Map<QName, String> attributes, Locator locator) throws SAXParseException {
            HttpListener listener = new HttpListener();
            listener.receiveBuffer = ParserUtils.toInteger(attributes.get(ATT_RECEIVE_BUFFER), locator, 65536);
            listener.sendBuffer = ParserUtils.toInteger(attributes.get(ATT_SEND_BUFFER), locator, 65536);
            listener.tcpBacklog = ParserUtils.toInteger(attributes.get(ATT_TCP_BACKLOG), locator, 128);
            listener.tcpKeepAlive = ParserUtils.toBoolean(attributes.get(ATT_TCP_KEEP_ALIVE), locator, false);
            listener.readTimeout = ParserUtils.toInteger(attributes.get(ATT_READ_TIMEOUT), locator, 0);
            listener.writeTimeout = ParserUtils.toInteger(attributes.get(ATT_WRITE_TIMEOUT), locator, 0);
            listener.maxConnections = ParserUtils.toInteger(attributes.get(ATT_MAX_CONNECTIONS), locator, Integer.MAX_VALUE);
            listener.name = attributes.get(ATT_NAME);
            listener.socketBindingName = attributes.get(ATT_SOCKET_BINDING);
            listener.workerName = ParserUtils.toStringValue(attributes.get(ATT_WORKER), locator, "default");
            listener.bufferPoolName = ParserUtils.toStringValue(attributes.get(ATT_BUFFER_POOL), locator, "default");
            listener.enabled = ParserUtils.toBoolean(attributes.get(ATT_ENABLED), locator, true);
            listener.resolvePeerAddress = ParserUtils.toBoolean(attributes.get(ATT_RESOLVE_PEER_ADDRESS), locator, false);
            listener.disallowedMethods.addAll(ParserUtils.toStringList(attributes.get(ATT_DISALLOWED_METHODS), locator));
            listener.secure = ParserUtils.toBoolean(attributes.get(ATT_SECURE), locator, false);
            listener.maxPostSize = ParserUtils.toLong(attributes.get(ATT_MAX_POST_SIZE), locator, 0xA00000L);
            listener.bufferPipelinedData = ParserUtils.toBoolean(attributes.get(ATT_BUFFER_PIPELINED_DATA), locator, false);
            listener.maxHeaderSize = ParserUtils.toInteger(attributes.get(ATT_MAX_HEADER_SIZE), locator, 0x100000);
            listener.maxParameters = ParserUtils.toInteger(attributes.get(ATT_MAX_PARAMETERS), locator, 1000);
            listener.maxHeaders = ParserUtils.toInteger(attributes.get(ATT_MAX_HEADERS), locator, 200);
            listener.maxCookies = ParserUtils.toInteger(attributes.get(ATT_MAX_COOKIES), locator, 200);
            listener.allowEncodedSlash = ParserUtils.toBoolean(attributes.get(ATT_ALLOW_ENCODED_SLASH), locator, false);
            listener.decodeUrl = ParserUtils.toBoolean(attributes.get(ATT_DECODE_URL), locator, true);
            listener.urlCharset = ParserUtils.toStringValue(attributes.get(ATT_URL_CHARSET), locator, StandardCharsets.UTF_8.name());
            listener.alwaysSetKeepAlive = ParserUtils.toBoolean(attributes.get(ATT_ALWAYS_SET_KEEP_ALIVE), locator, true);
            listener.maxBufferedRequestSize = ParserUtils.toInteger(attributes.get(ATT_MAX_BUFFERED_REQUEST_SIZE), locator, 16384);
            listener.recordRequestStartTime = ParserUtils.toBoolean(attributes.get(ATT_RECORD_REQUEST_START_TIME), locator, false);
            listener.allowEqualsInCookieValue = ParserUtils.toBoolean(attributes.get(ATT_ALLOW_EQUALS_IN_COOKIE_VALUE), locator, false);
            listener.noRequestTimeout = ParserUtils.toInteger(attributes.get(ATT_NO_REQUEST_TIMEOUT), locator, 60000);
            listener.requestParseTimeout = ParserUtils.toInteger(attributes.get(ATT_REQUEST_PARSE_TIMEOUT), locator, 60000);
            listener.rfc6265CookieValidation = ParserUtils.toBoolean(attributes.get(ATT_RFC6265_COOKIE_VALIDATION), locator, false);
            listener.allowUnescapedCharactersInUrl = ParserUtils.toBoolean(attributes.get(ATT_ALLOW_UNESCAPED_CHARACTERS_IN_URL), locator, false);
            listener.certificateForwarding = ParserUtils.toBoolean(attributes.get(ATT_CERTIFICATE_FORWARDING), locator, false);
            listener.redirectSocket = attributes.get(ATT_REDIRECT_SOCKET);
            listener.proxyAddressForwarding = ParserUtils.toBoolean(attributes.get(ATT_PROXY_ADDRESS_FORWARDING), locator, false);
            listener.enableHttp2 = ParserUtils.toBoolean(attributes.get(ATT_ENABLE_HTTP2), locator, false);
            listener.http2EnablePush = ParserUtils.toBoolean(attributes.get(ATT_HTTP2_ENABLE_PUSH), locator, false);
            listener.http2HeaderTableSize = ParserUtils.toInteger(attributes.get(ATT_HTTP2_HEADER_TABLE_SIZE), locator, 4096);
            listener.http2InitialWindowSize = ParserUtils.toInteger(attributes.get(ATT_HTTP2_INITIAL_WINDOW_SIZE), locator, 65535);
            listener.http2MaxConcurrentStreams = ParserUtils.toInteger(attributes.get(ATT_HTTP2_MAX_CONCURRENT_STREAMS), locator, -1);
            listener.http2MaxFrameSize = ParserUtils.toInteger(attributes.get(ATT_HTTP2_MAX_FRAME_SIZE), locator, 16384);
            listener.http2MaxHeaderListSize = ParserUtils.toInteger(attributes.get(ATT_HTTP2_MAX_HEADER_LIST_SIZE), locator, 0x100000);
            listener.requireHostHttp11 = ParserUtils.toBoolean(attributes.get(ATT_REQUIRE_HOST_HTTP11), locator, false);
            listener.proxyProtocol = ParserUtils.toBoolean(attributes.get(ATT_PROXY_PROTOCOL), locator, false);
            return listener;
        }

        @Override
        public boolean isCertificateForwarding() {
            return this.certificateForwarding;
        }

        public void setCertificateForwarding(boolean certificateForwarding) {
            this.certificateForwarding = certificateForwarding;
        }

        public String getRedirectSocket() {
            return this.redirectSocket;
        }

        public void setRedirectSocket(String redirectSocket) {
            this.redirectSocket = redirectSocket;
        }

        @Override
        public boolean isProxyAddressForwarding() {
            return this.proxyAddressForwarding;
        }

        public void setProxyAddressForwarding(boolean proxyAddressForwarding) {
            this.proxyAddressForwarding = proxyAddressForwarding;
        }

        @Override
        public boolean isEnableHttp2() {
            return this.enableHttp2;
        }

        public void setEnableHttp2(boolean enableHttp2) {
            this.enableHttp2 = enableHttp2;
        }

        @Override
        public boolean isHttp2EnablePush() {
            return this.http2EnablePush;
        }

        public void setHttp2EnablePush(boolean http2EnablePush) {
            this.http2EnablePush = http2EnablePush;
        }

        @Override
        public int getHttp2HeaderTableSize() {
            return this.http2HeaderTableSize;
        }

        public void setHttp2HeaderTableSize(int http2HeaderTableSize) {
            this.http2HeaderTableSize = http2HeaderTableSize;
        }

        @Override
        public int getHttp2InitialWindowSize() {
            return this.http2InitialWindowSize;
        }

        public void setHttp2InitialWindowSize(int http2InitialWindowSize) {
            this.http2InitialWindowSize = http2InitialWindowSize;
        }

        @Override
        public Integer getHttp2MaxConcurrentStreams() {
            return this.http2MaxConcurrentStreams;
        }

        public void setHttp2MaxConcurrentStreams(Integer http2MaxConcurrentStreams) {
            this.http2MaxConcurrentStreams = http2MaxConcurrentStreams;
        }

        @Override
        public int getHttp2MaxFrameSize() {
            return this.http2MaxFrameSize;
        }

        public void setHttp2MaxFrameSize(int http2MaxFrameSize) {
            this.http2MaxFrameSize = http2MaxFrameSize;
        }

        @Override
        public Integer getHttp2MaxHeaderListSize() {
            return this.http2MaxHeaderListSize;
        }

        public void setHttp2MaxHeaderListSize(Integer http2MaxHeaderListSize) {
            this.http2MaxHeaderListSize = http2MaxHeaderListSize;
        }

        @Override
        public boolean isRequireHostHttp11() {
            return this.requireHostHttp11;
        }

        public void setRequireHostHttp11(boolean requireHostHttp11) {
            this.requireHostHttp11 = requireHostHttp11;
        }

        public boolean isProxyProtocol() {
            return this.proxyProtocol;
        }

        public void setProxyProtocol(boolean proxyProtocol) {
            this.proxyProtocol = proxyProtocol;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("{ ");
            sb.append(this.toStringParameters());
            sb.append(" }");
            return sb.toString();
        }

        @Override
        protected String toStringParameters() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toStringParameters());
            sb.append(", certificate forwarding: ").append(this.certificateForwarding);
            sb.append(", redirect socket: ").append(this.redirectSocket);
            sb.append(", proxy address forwarding: ").append(this.proxyAddressForwarding);
            sb.append(", enable http2: ").append(this.enableHttp2);
            sb.append(", http2 enable push: ").append(this.http2EnablePush);
            sb.append(", http2 header table size: ").append(this.http2HeaderTableSize);
            sb.append(", http2 initial window size: ").append(this.http2InitialWindowSize);
            sb.append(", http2 max concurrent streams: ").append(this.http2MaxConcurrentStreams);
            sb.append(", http2 max frame size: ").append(this.http2MaxFrameSize);
            sb.append(", http2 max header list size: ").append(this.http2MaxHeaderListSize);
            sb.append(", require host http11: ").append(this.requireHostHttp11);
            sb.append(", proxy protocol: ").append(this.proxyProtocol);
            return sb.toString();
        }
    }

    public static abstract class Listener
    extends SocketOptions {
        protected static final QName ATT_RECEIVE_BUFFER = new QName("receive-buffer");
        protected static final QName ATT_SEND_BUFFER = new QName("send-buffer");
        protected static final QName ATT_TCP_BACKLOG = new QName("tcp-backlog");
        protected static final QName ATT_TCP_KEEP_ALIVE = new QName("tcp-keep-alive");
        protected static final QName ATT_READ_TIMEOUT = new QName("read-timeout");
        protected static final QName ATT_WRITE_TIMEOUT = new QName("write-timeout");
        protected static final QName ATT_MAX_CONNECTIONS = new QName("max-connections");
        protected static final QName ATT_NAME = new QName("name");
        protected static final QName ATT_SOCKET_BINDING = new QName("socket-binding");
        protected static final QName ATT_WORKER = new QName("worker");
        protected static final QName ATT_BUFFER_POOL = new QName("buffer-pool");
        protected static final QName ATT_ENABLED = new QName("enabled");
        protected static final QName ATT_RESOLVE_PEER_ADDRESS = new QName("resolve-peer-address");
        protected static final QName ATT_DISALLOWED_METHODS = new QName("disallowed-methods");
        protected static final QName ATT_SECURE = new QName("secure");
        protected static final QName ATT_MAX_POST_SIZE = new QName("max-post-size");
        protected static final QName ATT_BUFFER_PIPELINED_DATA = new QName("buffer-pipelined-data");
        protected static final QName ATT_MAX_HEADER_SIZE = new QName("max-header-size");
        protected static final QName ATT_MAX_PARAMETERS = new QName("max-parameters");
        protected static final QName ATT_MAX_HEADERS = new QName("max-headers");
        protected static final QName ATT_MAX_COOKIES = new QName("max-cookies");
        protected static final QName ATT_ALLOW_ENCODED_SLASH = new QName("allow-encoded-slash");
        protected static final QName ATT_DECODE_URL = new QName("decode-url");
        protected static final QName ATT_URL_CHARSET = new QName("url-charset");
        protected static final QName ATT_ALWAYS_SET_KEEP_ALIVE = new QName("always-set-keep-alive");
        protected static final QName ATT_MAX_BUFFERED_REQUEST_SIZE = new QName("max-buffered-request-size");
        protected static final QName ATT_RECORD_REQUEST_START_TIME = new QName("record-request-start-time");
        protected static final QName ATT_ALLOW_EQUALS_IN_COOKIE_VALUE = new QName("allow-equals-in-cookie-value");
        protected static final QName ATT_NO_REQUEST_TIMEOUT = new QName("no-request-timeout");
        protected static final QName ATT_REQUEST_PARSE_TIMEOUT = new QName("request-parse-timeout");
        protected static final QName ATT_RFC6265_COOKIE_VALIDATION = new QName("rfc6265-cookie-validation");
        protected static final QName ATT_ALLOW_UNESCAPED_CHARACTERS_IN_URL = new QName("allow-unescaped-characters-in-url");
        protected String name;
        protected String socketBindingName;
        protected String workerName = "default";
        protected String bufferPoolName = "default";
        protected boolean enabled = true;
        protected boolean resolvePeerAddress = false;
        protected List<String> disallowedMethods = new LinkedList<String>(Collections.singletonList("TRACE"));
        protected boolean secure = false;
        protected long maxPostSize = 0xA00000L;
        protected boolean bufferPipelinedData = false;
        protected int maxHeaderSize = 0x100000;
        protected int maxParameters = 1000;
        protected int maxHeaders = 200;
        protected int maxCookies = 200;
        protected boolean allowEncodedSlash = false;
        protected boolean decodeUrl = true;
        protected String urlCharset = StandardCharsets.UTF_8.name();
        protected boolean alwaysSetKeepAlive = true;
        protected int maxBufferedRequestSize = 16384;
        protected boolean recordRequestStartTime = false;
        protected boolean allowEqualsInCookieValue = false;
        protected int noRequestTimeout = 60000;
        protected int requestParseTimeout = 60000;
        protected boolean rfc6265CookieValidation = false;
        protected boolean allowUnescapedCharactersInUrl = false;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getSocketBindingName() {
            return this.socketBindingName;
        }

        public void setSocketBindingName(String socketBindingName) {
            this.socketBindingName = socketBindingName;
        }

        public String getWorkerName() {
            return this.workerName;
        }

        public void setWorkerName(String workerName) {
            this.workerName = workerName;
        }

        public String getBufferPoolName() {
            return this.bufferPoolName;
        }

        public void setBufferPoolName(String bufferPoolName) {
            this.bufferPoolName = bufferPoolName;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isResolvePeerAddress() {
            return this.resolvePeerAddress;
        }

        public void setResolvePeerAddress(boolean resolvePeerAddress) {
            this.resolvePeerAddress = resolvePeerAddress;
        }

        public List<String> getDisallowedMethods() {
            return this.disallowedMethods;
        }

        public void setDisallowedMethods(List<String> disallowedMethods) {
            this.disallowedMethods = disallowedMethods;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public void setSecure(boolean secure) {
            this.secure = secure;
        }

        public long getMaxPostSize() {
            return this.maxPostSize;
        }

        public void setMaxPostSize(long maxPostSize) {
            this.maxPostSize = maxPostSize;
        }

        public boolean isBufferPipelinedData() {
            return this.bufferPipelinedData;
        }

        public void setBufferPipelinedData(boolean bufferPipelinedData) {
            this.bufferPipelinedData = bufferPipelinedData;
        }

        public int getMaxHeaderSize() {
            return this.maxHeaderSize;
        }

        public void setMaxHeaderSize(int maxHeaderSize) {
            this.maxHeaderSize = maxHeaderSize;
        }

        public int getMaxParameters() {
            return this.maxParameters;
        }

        public void setMaxParameters(int maxParameters) {
            this.maxParameters = maxParameters;
        }

        public int getMaxHeaders() {
            return this.maxHeaders;
        }

        public void setMaxHeaders(int maxHeaders) {
            this.maxHeaders = maxHeaders;
        }

        public int getMaxCookies() {
            return this.maxCookies;
        }

        public void setMaxCookies(int maxCookies) {
            this.maxCookies = maxCookies;
        }

        public boolean isAllowEncodedSlash() {
            return this.allowEncodedSlash;
        }

        public void setAllowEncodedSlash(boolean allowEncodedSlash) {
            this.allowEncodedSlash = allowEncodedSlash;
        }

        public boolean isDecodeUrl() {
            return this.decodeUrl;
        }

        public void setDecodeUrl(boolean decodeUrl) {
            this.decodeUrl = decodeUrl;
        }

        public String getUrlCharset() {
            return this.urlCharset;
        }

        public void setUrlCharset(String urlCharset) {
            this.urlCharset = urlCharset;
        }

        public boolean isAlwaysSetKeepAlive() {
            return this.alwaysSetKeepAlive;
        }

        public void setAlwaysSetKeepAlive(boolean alwaysSetKeepAlive) {
            this.alwaysSetKeepAlive = alwaysSetKeepAlive;
        }

        public int getMaxBufferedRequestSize() {
            return this.maxBufferedRequestSize;
        }

        public void setMaxBufferedRequestSize(int maxBufferedRequestSize) {
            this.maxBufferedRequestSize = maxBufferedRequestSize;
        }

        public boolean isRecordRequestStartTime() {
            return this.recordRequestStartTime;
        }

        public void setRecordRequestStartTime(boolean recordRequestStartTime) {
            this.recordRequestStartTime = recordRequestStartTime;
        }

        public boolean isAllowEqualsInCookieValue() {
            return this.allowEqualsInCookieValue;
        }

        public void setAllowEqualsInCookieValue(boolean allowEqualsInCookieValue) {
            this.allowEqualsInCookieValue = allowEqualsInCookieValue;
        }

        public int getNoRequestTimeout() {
            return this.noRequestTimeout;
        }

        public void setNoRequestTimeout(int noRequestTimeout) {
            this.noRequestTimeout = noRequestTimeout;
        }

        public int getRequestParseTimeout() {
            return this.requestParseTimeout;
        }

        public void setRequestParseTimeout(int requestParseTimeout) {
            this.requestParseTimeout = requestParseTimeout;
        }

        public boolean isRfc6265CookieValidation() {
            return this.rfc6265CookieValidation;
        }

        public void setRfc6265CookieValidation(boolean rfc6265CookieValidation) {
            this.rfc6265CookieValidation = rfc6265CookieValidation;
        }

        public boolean isAllowUnescapedCharactersInUrl() {
            return this.allowUnescapedCharactersInUrl;
        }

        public void setAllowUnescapedCharactersInUrl(boolean allowUnescapedCharactersInUrl) {
            this.allowUnescapedCharactersInUrl = allowUnescapedCharactersInUrl;
        }

        public abstract boolean isProxyAddressForwarding();

        public abstract boolean isCertificateForwarding();

        public abstract boolean isRequireHostHttp11();

        public abstract boolean isEnableHttp2();

        public abstract boolean isHttp2EnablePush();

        public abstract int getHttp2HeaderTableSize();

        public abstract int getHttp2InitialWindowSize();

        public abstract Integer getHttp2MaxConcurrentStreams();

        public abstract int getHttp2MaxFrameSize();

        public abstract Integer getHttp2MaxHeaderListSize();

        @Override
        protected String toStringParameters() {
            StringBuilder sb = new StringBuilder();
            sb.append("name: ").append(this.name);
            sb.append(", ").append(super.toStringParameters());
            sb.append(", socket binding name: ").append(this.socketBindingName);
            sb.append(", worker name: ").append(this.workerName);
            sb.append(", buffer pool name: ").append(this.bufferPoolName);
            sb.append(", enabled: ").append(this.enabled);
            sb.append(", resolve peer address: ").append(this.resolvePeerAddress);
            sb.append(", disallowed methods: ").append(this.disallowedMethods);
            sb.append(", secure: ").append(this.isSecure());
            sb.append(", max post size: ").append(this.maxPostSize);
            sb.append(", buffer pipelined data: ").append(this.bufferPipelinedData);
            sb.append(", max header size: ").append(this.maxHeaderSize);
            sb.append(", max parameters: ").append(this.maxParameters);
            sb.append(", max headers: ").append(this.maxHeaders);
            sb.append(", max cookies: ").append(this.maxCookies);
            sb.append(", allow encoded slash: ").append(this.allowEncodedSlash);
            sb.append(", decode url: ").append(this.decodeUrl);
            sb.append(", url charset: ").append(this.urlCharset);
            sb.append(", always set keep alive: ").append(this.alwaysSetKeepAlive);
            sb.append(", max buffered request size: ").append(this.maxBufferedRequestSize);
            sb.append(", record request start time: ").append(this.recordRequestStartTime);
            sb.append(", allow equals in cookie value: ").append(this.allowEqualsInCookieValue);
            sb.append(", no request timeout: ").append(this.noRequestTimeout);
            sb.append(", request parse timeout: ").append(this.requestParseTimeout);
            sb.append(", rfc6265 cookie validation: ").append(this.rfc6265CookieValidation);
            return sb.toString();
        }
    }

    public static abstract class SocketOptions {
        protected int receiveBuffer = 65536;
        protected int sendBuffer = 65536;
        protected int tcpBacklog = 128;
        protected boolean tcpKeepAlive = false;
        protected int readTimeout = 0;
        protected int writeTimeout = 0;
        protected int maxConnections = Integer.MAX_VALUE;

        public int getReceiveBuffer() {
            return this.receiveBuffer;
        }

        public void setReceiveBuffer(int receiveBuffer) {
            this.receiveBuffer = receiveBuffer;
        }

        public int getSendBuffer() {
            return this.sendBuffer;
        }

        public void setSendBuffer(int sendBuffer) {
            this.sendBuffer = sendBuffer;
        }

        public int getTcpBacklog() {
            return this.tcpBacklog;
        }

        public void setTcpBacklog(int tcpBacklog) {
            this.tcpBacklog = tcpBacklog;
        }

        public boolean isTcpKeepAlive() {
            return this.tcpKeepAlive;
        }

        public void setTcpKeepAlive(boolean tcpKeepAlive) {
            this.tcpKeepAlive = tcpKeepAlive;
        }

        public int getReadTimeout() {
            return this.readTimeout;
        }

        public void setReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
        }

        public int getWriteTimeout() {
            return this.writeTimeout;
        }

        public void setWriteTimeout(int writeTimeout) {
            this.writeTimeout = writeTimeout;
        }

        public int getMaxConnections() {
            return this.maxConnections;
        }

        public void setMaxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
        }

        public String toString() {
            return "{ " + this.toStringParameters() + " }";
        }

        protected String toStringParameters() {
            return "receive buffer: " + this.receiveBuffer + ", send buffer: " + this.sendBuffer + ", tcp backlog: " + this.tcpBacklog + ", tcp KeepAlive: " + this.tcpKeepAlive + ", read timeoout: " + this.readTimeout + ", write timeoout: " + this.writeTimeout + ", max connections: " + this.maxConnections;
        }
    }
}

