/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.internal;

import java.util.Hashtable;
import org.ops4j.pax.web.service.spi.ServerControllerFactory;
import org.ops4j.pax.web.service.undertow.internal.UndertowServerControllerFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.xnio.XnioProvider;

public class Activator
implements BundleActivator,
ServiceTrackerCustomizer<XnioProvider, XnioProvider> {
    private BundleContext bundleContext;
    private ServiceTracker<XnioProvider, XnioProvider> xnioTracker;
    private ServiceRegistration<ServerControllerFactory> registration;
    private UndertowServerControllerFactory serverControllerFactory;

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.xnioTracker = new ServiceTracker(context, XnioProvider.class, (ServiceTrackerCustomizer)this);
        this.xnioTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.xnioTracker != null) {
            this.xnioTracker.close();
        }
        try {
            if (this.registration != null) {
                this.registration.unregister();
                this.registration = null;
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public XnioProvider addingService(ServiceReference<XnioProvider> reference) {
        XnioProvider provider = (XnioProvider)this.bundleContext.getService(reference);
        Bundle bundle = this.bundleContext.getBundle();
        UndertowServerControllerFactory factory = new UndertowServerControllerFactory(bundle, ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader(), provider);
        this.registration = this.bundleContext.registerService(ServerControllerFactory.class, (Object)factory, new Hashtable());
        return provider;
    }

    public void modifiedService(ServiceReference<XnioProvider> reference, XnioProvider service) {
    }

    public void removedService(ServiceReference<XnioProvider> reference, XnioProvider service) {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        this.bundleContext.ungetService(reference);
    }
}

