/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.internal;

import io.undertow.UndertowOptions;
import io.undertow.connector.ByteBufferPool;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.server.DelegateOpenListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.OpenListener;
import io.undertow.server.handlers.CookieSameSiteMode;
import io.undertow.server.handlers.DisallowedMethodsHandler;
import io.undertow.server.handlers.PeerNameResolvingHandler;
import io.undertow.server.handlers.ProxyPeerAddressHandler;
import io.undertow.server.handlers.SSLHeaderHandler;
import io.undertow.server.handlers.SameSiteCookieHandler;
import io.undertow.server.protocol.http.AlpnOpenListener;
import io.undertow.server.protocol.http.HttpOpenListener;
import io.undertow.server.protocol.http2.Http2OpenListener;
import io.undertow.server.protocol.http2.Http2UpgradeHandler;
import io.undertow.server.protocol.proxy.ProxyProtocolOpenListener;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.FilterMappingInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.handlers.MarkSecureHandler;
import io.undertow.util.HttpString;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URL;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.ops4j.pax.web.service.spi.config.Configuration;
import org.ops4j.pax.web.service.spi.config.SecurityConfiguration;
import org.ops4j.pax.web.service.spi.model.elements.FilterModel;
import org.ops4j.pax.web.service.undertow.configuration.model.IoSubsystem;
import org.ops4j.pax.web.service.undertow.configuration.model.SecurityRealm;
import org.ops4j.pax.web.service.undertow.configuration.model.Server;
import org.ops4j.pax.web.service.undertow.internal.CertificateValidator;
import org.ops4j.pax.web.service.undertow.internal.PaxWebFilterInfo;
import org.ops4j.pax.web.service.undertow.internal.RootHttpOptionsHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Sequence;
import org.xnio.SslClientAuthMode;
import org.xnio.StreamConnection;
import org.xnio.Xnio;
import org.xnio.XnioProvider;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;

public class UndertowFactory {
    public static final Option<String> PAX_WEB_CONNECTOR_NAME = Option.simple(UndertowFactory.class, (String)"PAX_WEB_CONNECTOR_NAME", String.class);
    private static final Logger LOG = LoggerFactory.getLogger(UndertowFactory.class);
    private final ClassLoader classLoader;
    private final Xnio xnio;
    private boolean http2Available;
    private long maxMemory;
    private OptionMap commonSocketOptions;
    private XnioWorker defaultWorker;
    private ByteBufferPool defaultBufferPool;

    UndertowFactory(ClassLoader classLoader, XnioProvider xnioProvider) {
        this.classLoader = classLoader;
        this.xnio = xnioProvider.getInstance();
        this.discovery();
    }

    private void discovery() {
        this.maxMemory = Runtime.getRuntime().maxMemory();
        this.commonSocketOptions = OptionMap.builder().set(Options.TCP_NODELAY, true).set(Options.REUSE_ADDRESSES, true).set(Options.BALANCING_TOKENS, 1).set(Options.BALANCING_CONNECTIONS, 2).getMap();
        IoSubsystem.BufferPool defaultBufferPoolDefinition = new IoSubsystem.BufferPool();
        defaultBufferPoolDefinition.setName("default");
        this.defaultBufferPool = this.createBufferPool(defaultBufferPoolDefinition);
        try {
            this.classLoader.loadClass("io.undertow.server.protocol.http2.Http2UpgradeHandler");
            this.http2Available = true;
        }
        catch (ClassNotFoundException e) {
            this.http2Available = false;
        }
    }

    public XnioWorker createWorker(IoSubsystem.Worker definition) throws IOException {
        return this.xnio.createWorker(OptionMap.builder().set(Options.WORKER_NAME, (Object)definition.getName()).set(Options.THREAD_DAEMON, false).set(Options.STACK_SIZE, definition.getStackSize()).set(Options.WORKER_IO_THREADS, definition.getIoThreads()).set(Options.WORKER_TASK_KEEPALIVE, definition.getTaskKeepalive()).set(Options.WORKER_TASK_CORE_THREADS, definition.getTaskCoreThreads()).set(Options.WORKER_TASK_MAX_THREADS, definition.getTaskMaxThreads()).getMap());
    }

    public ByteBufferPool createBufferPool(IoSubsystem.BufferPool definition) {
        boolean direct = this.maxMemory >= 0x4000000L;
        Integer bufferSize = definition.getBufferSize();
        if (bufferSize == null) {
            bufferSize = this.maxMemory >= 0x8000000L ? Integer.valueOf(16364) : Integer.valueOf(1024);
        }
        int leakDetectionPercent = 0;
        int threadLocalCacheSize = 12;
        int maxPoolSize = -1;
        return new DefaultByteBufferPool(direct, bufferSize.intValue(), maxPoolSize, threadLocalCacheSize, leakDetectionPercent);
    }

    public XnioWorker getDefaultWorker(Configuration configuration) {
        if (this.defaultWorker == null) {
            IoSubsystem.Worker defaultWorkerDefinition = new IoSubsystem.Worker();
            if (configuration.server().getServerThreadNamePrefix() != null) {
                defaultWorkerDefinition.setName(configuration.server().getServerThreadNamePrefix());
            } else {
                defaultWorkerDefinition.setName("XNIO-default");
            }
            if (configuration.server().getServerMaxThreads() != null) {
                defaultWorkerDefinition.setTaskCoreThreads(configuration.server().getServerMaxThreads());
                defaultWorkerDefinition.setTaskMaxThreads(configuration.server().getServerMaxThreads());
            }
            try {
                this.defaultWorker = this.createWorker(defaultWorkerDefinition);
            }
            catch (IOException e) {
                throw new IllegalStateException("Can't create default worker for Undertow: " + e.getMessage(), e);
            }
        }
        return this.defaultWorker;
    }

    public void closeDefaultPoolAndBuffer() {
        if (this.defaultWorker != null) {
            this.defaultWorker.shutdown();
            this.defaultWorker = null;
        }
        if (this.defaultBufferPool != null) {
            this.defaultBufferPool.close();
            IoSubsystem.BufferPool defaultBufferPoolDefinition = new IoSubsystem.BufferPool();
            defaultBufferPoolDefinition.setName("default");
            this.defaultBufferPool = this.createBufferPool(defaultBufferPoolDefinition);
        }
    }

    public XnioWorker createLogWorker() throws IOException {
        OptionMap workerOptions = OptionMap.builder().set(Options.WORKER_NAME, (Object)"log-xnio").set(Options.WORKER_TASK_CORE_THREADS, 1).set(Options.WORKER_TASK_MAX_THREADS, 1).set(Options.THREAD_DAEMON, true).set(Options.WORKER_IO_THREADS, 1).getMap();
        return this.xnio.createWorker(workerOptions);
    }

    public ByteBufferPool getDefaultBufferPool() {
        return this.defaultBufferPool;
    }

    public AcceptingChannelWithAddress createDefaultListener(String address, HttpHandler rootHandler, Configuration configuration) {
        Server.HttpListener def = new Server.HttpListener();
        def.setEnableHttp2(true);
        def.setHttp2EnablePush(true);
        return this.createListener(address, rootHandler, configuration, def, new InetSocketAddress(address, (int)configuration.server().getHttpPort()));
    }

    public AcceptingChannelWithAddress createSecureListener(String address, HttpHandler rootHandler, Configuration configuration) {
        Server.HttpsListener def = new Server.HttpsListener();
        def.setEnableHttp2(true);
        def.setHttp2EnablePush(true);
        AcceptingChannelWithAddress listener = this.createListener(address, rootHandler, configuration, def, new InetSocketAddress(address, (int)configuration.server().getHttpSecurePort()));
        listener.setSecure(true);
        return listener;
    }

    private AcceptingChannelWithAddress createListener(String address, HttpHandler rootHandler, Configuration configuration, Server.Listener def, InetSocketAddress listenerAddress) {
        AcceptingChannel<? extends StreamConnection> listener;
        try {
            listener = this.createListener(configuration, def, rootHandler, null, this.getDefaultWorker(configuration), this.defaultBufferPool, listenerAddress);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return new AcceptingChannelWithAddress(listener, listenerAddress);
    }

    public AcceptingChannel<? extends StreamConnection> createListener(Configuration config, Server.Listener definition, HttpHandler rootHandler, SecurityRealm realm, XnioWorker workerForListener, ByteBufferPool bufferPoolForListener, InetSocketAddress listenerAddress) throws IOException {
        OptionMap.Builder listenerOptionsBuilder = OptionMap.builder().addAll(this.commonSocketOptions);
        this.prepareListenerOptionsBuilder(listenerOptionsBuilder, definition);
        OptionMap listenerOptions = listenerOptionsBuilder.getMap();
        OptionMap.Builder undertowOptionsBuilder = OptionMap.builder();
        HttpHandler listenerSpecificHandler = this.prepareUndertowOptionsBuilder(config, undertowOptionsBuilder, definition, rootHandler);
        OptionMap undertowOptions = undertowOptionsBuilder.getMap();
        HttpOpenListener httpListener = new HttpOpenListener(bufferPoolForListener, undertowOptions);
        httpListener.setRootHandler(listenerSpecificHandler);
        HttpOpenListener openListener = httpListener;
        if (definition instanceof Server.HttpsListener && this.http2Available && definition.isEnableHttp2()) {
            AlpnOpenListener alpnListener = new AlpnOpenListener(bufferPoolForListener, undertowOptions, (DelegateOpenListener)httpListener);
            Http2OpenListener http2Listener = new Http2OpenListener(bufferPoolForListener, undertowOptions);
            http2Listener.setRootHandler(listenerSpecificHandler);
            int weight = 10;
            alpnListener.addProtocol("h2", (DelegateOpenListener)http2Listener, weight);
            openListener = alpnListener;
        }
        HttpOpenListener finalListener = openListener;
        if (definition instanceof Server.HttpListener) {
            Server.HttpListener http = (Server.HttpListener)definition;
            if (http.isProxyProtocol()) {
                finalListener = new ProxyProtocolOpenListener((OpenListener)openListener, null, bufferPoolForListener, OptionMap.EMPTY);
            }
            ChannelListener acceptListener = ChannelListeners.openListenerAdapter((ChannelListener)finalListener);
            return workerForListener.createStreamConnectionServer((SocketAddress)listenerAddress, acceptListener, listenerOptions);
        }
        if (definition instanceof Server.HttpsListener) {
            List<String> enabledProtocols;
            List<String> enabledCipherSuites;
            Server.HttpsListener https = (Server.HttpsListener)definition;
            OptionMap.Builder sslParametersBuilder = OptionMap.builder();
            sslParametersBuilder.addAll(listenerOptions);
            if (https.getVerifyClient() != null) {
                sslParametersBuilder.set(Options.SSL_CLIENT_AUTH_MODE, (Object)https.getVerifyClient());
            }
            if (config.security().isClientAuthWanted().booleanValue()) {
                sslParametersBuilder.set(Options.SSL_CLIENT_AUTH_MODE, (Object)SslClientAuthMode.REQUESTED);
            }
            if (config.security().isClientAuthNeeded().booleanValue()) {
                sslParametersBuilder.set(Options.SSL_CLIENT_AUTH_MODE, (Object)SslClientAuthMode.REQUIRED);
            }
            if (https.getSslSessionCacheSize() > 0) {
                sslParametersBuilder.set(Options.SSL_ENABLE_SESSION_CREATION, true);
                sslParametersBuilder.set(Options.SSL_CLIENT_SESSION_CACHE_SIZE, https.getSslSessionCacheSize());
                sslParametersBuilder.set(Options.SSL_SERVER_SESSION_CACHE_SIZE, https.getSslSessionCacheSize());
            }
            sslParametersBuilder.set(Options.SSL_CLIENT_SESSION_TIMEOUT, https.getSslSessionTimeout());
            sslParametersBuilder.set(Options.SSL_SERVER_SESSION_TIMEOUT, https.getSslSessionTimeout());
            SecurityRealm.Engine engine = null;
            if (realm != null && realm.getIdentities() != null && realm.getIdentities().getSsl() != null && realm.getIdentities().getSsl().getEngine() != null) {
                engine = realm.getIdentities().getSsl().getEngine();
            }
            if ((enabledCipherSuites = https.getEnabledCipherSuites()).size() > 0 && engine != null && engine.getEnabledCipherSuites().size() > 0) {
                LOG.warn("Enabled cipher suites specified both for https-listener and ssl/engine. Cipher suites from the https-listener will be used.");
            }
            if (enabledCipherSuites.size() == 0 && engine != null) {
                enabledCipherSuites = engine.getEnabledCipherSuites();
            }
            if (enabledCipherSuites.size() == 0 && config.security().getCiphersuiteIncluded().length > 0) {
                enabledCipherSuites = Arrays.asList(config.security().getCiphersuiteIncluded());
            }
            if (enabledCipherSuites.size() > 0) {
                sslParametersBuilder.set(Options.SSL_ENABLED_CIPHER_SUITES, (Object)Sequence.of(enabledCipherSuites));
            }
            if ((enabledProtocols = https.getEnabledProtocols()).size() > 0 && engine != null && engine.getEnabledProtocols().size() > 0) {
                LOG.warn("Enabled protocols specified both for https-listener and ssl/engine. Protocols from the https-listener will be used.");
            }
            if (enabledProtocols.size() == 0 && engine != null) {
                enabledProtocols = engine.getEnabledProtocols();
            }
            if (enabledProtocols.size() == 0 && config.security().getProtocolsIncluded().length > 0) {
                enabledProtocols = Arrays.asList(config.security().getProtocolsIncluded());
            }
            if (enabledProtocols.size() > 0) {
                sslParametersBuilder.set(Options.SSL_ENABLED_PROTOCOLS, (Object)Sequence.of(enabledProtocols));
            }
            sslParametersBuilder.set(UndertowOptions.SSL_USER_CIPHER_SUITES_ORDER, true);
            OptionMap sslParameters = sslParametersBuilder.getMap();
            SSLContext sslContext = this.buildSSLContext(config, https, realm);
            UndertowXnioSsl xnioSsl = new UndertowXnioSsl(this.xnio, sslParameters, bufferPoolForListener, sslContext);
            if (https.isProxyProtocol()) {
                finalListener = new ProxyProtocolOpenListener((OpenListener)openListener, xnioSsl, bufferPoolForListener, sslParameters);
            }
            ChannelListener acceptListener = ChannelListeners.openListenerAdapter((ChannelListener)finalListener);
            return xnioSsl.createSslConnectionServer(workerForListener, listenerAddress, acceptListener, sslParameters);
        }
        throw new IllegalArgumentException("Can't handle listener definition " + definition);
    }

    private void prepareListenerOptionsBuilder(OptionMap.Builder listenerOptions, Server.Listener listener) {
        listenerOptions.set(Options.RECEIVE_BUFFER, listener.getReceiveBuffer());
        listenerOptions.set(Options.SEND_BUFFER, listener.getSendBuffer());
        listenerOptions.set(Options.BACKLOG, listener.getTcpBacklog());
        listenerOptions.set(Options.KEEP_ALIVE, listener.isTcpKeepAlive());
        listenerOptions.set(Options.READ_TIMEOUT, listener.getReadTimeout());
        listenerOptions.set(Options.WRITE_TIMEOUT, listener.getWriteTimeout());
        listenerOptions.set(Options.CONNECTION_HIGH_WATER, listener.getMaxConnections());
        listenerOptions.set(Options.CONNECTION_LOW_WATER, listener.getMaxConnections());
    }

    private HttpHandler prepareUndertowOptionsBuilder(Configuration config, OptionMap.Builder undertowOptions, Server.Listener listener, HttpHandler handler) {
        String connectorName;
        String sameSiteValue;
        undertowOptions.set(UndertowOptions.BUFFER_PIPELINED_DATA, listener.isBufferPipelinedData());
        undertowOptions.set(UndertowOptions.ENABLE_STATISTICS, false);
        undertowOptions.set(UndertowOptions.MAX_PARAMETERS, listener.getMaxParameters());
        undertowOptions.set(UndertowOptions.MAX_HEADERS, listener.getMaxHeaders());
        undertowOptions.set(UndertowOptions.MAX_COOKIES, listener.getMaxCookies());
        undertowOptions.set(UndertowOptions.MAX_ENTITY_SIZE, listener.getMaxPostSize());
        undertowOptions.set(UndertowOptions.MAX_HEADER_SIZE, listener.getMaxHeaderSize());
        undertowOptions.set(UndertowOptions.MAX_BUFFERED_REQUEST_SIZE, listener.getMaxBufferedRequestSize());
        undertowOptions.set(UndertowOptions.BUFFER_PIPELINED_DATA, listener.isBufferPipelinedData());
        undertowOptions.set(UndertowOptions.DECODE_URL, listener.isDecodeUrl());
        undertowOptions.set(UndertowOptions.ALLOW_ENCODED_SLASH, listener.isAllowEncodedSlash());
        undertowOptions.set(UndertowOptions.ALLOW_EQUALS_IN_COOKIE_VALUE, listener.isAllowEqualsInCookieValue());
        undertowOptions.set(UndertowOptions.ALLOW_UNESCAPED_CHARACTERS_IN_URL, listener.isAllowUnescapedCharactersInUrl());
        undertowOptions.set(UndertowOptions.URL_CHARSET, (Object)listener.getUrlCharset());
        undertowOptions.set(UndertowOptions.ALWAYS_SET_KEEP_ALIVE, listener.isAlwaysSetKeepAlive());
        undertowOptions.set(UndertowOptions.NO_REQUEST_TIMEOUT, listener.getNoRequestTimeout());
        undertowOptions.set(UndertowOptions.REQUEST_PARSE_TIMEOUT, listener.getRequestParseTimeout());
        undertowOptions.set(UndertowOptions.RECORD_REQUEST_START_TIME, listener.isRecordRequestStartTime());
        if (config.server().getConnectorIdleTimeout() != null) {
            undertowOptions.set(UndertowOptions.IDLE_TIMEOUT, (Object)config.server().getConnectorIdleTimeout());
        }
        undertowOptions.set(Options.SECURE, listener.isSecure());
        String defaultConnectorName = config.server().getHttpConnectorName();
        if (listener.isSecure()) {
            handler = new MarkSecureHandler(handler);
            defaultConnectorName = config.server().getHttpSecureConnectorName();
        }
        if (listener.isResolvePeerAddress()) {
            handler = new PeerNameResolvingHandler(handler);
        }
        if (listener.isProxyAddressForwarding() || config.server().checkForwardedHeaders().booleanValue()) {
            handler = new ProxyPeerAddressHandler(handler);
        }
        handler = new RootHttpOptionsHandler(handler, listener.getDisallowedMethods());
        if (listener.getDisallowedMethods().size() > 0) {
            HashSet disallowedMethods = new HashSet();
            listener.getDisallowedMethods().stream().map(HttpString::tryFromString).forEach(disallowedMethods::add);
            handler = new DisallowedMethodsHandler(handler, disallowedMethods);
        }
        if ((sameSiteValue = config.session().getSessionCookieSameSite()) != null && !"unset".equalsIgnoreCase(sameSiteValue)) {
            String mode = null;
            if ("none".equalsIgnoreCase(sameSiteValue)) {
                mode = CookieSameSiteMode.NONE.toString();
            } else if ("lax".equalsIgnoreCase(sameSiteValue)) {
                mode = CookieSameSiteMode.LAX.toString();
            } else if ("strict".equalsIgnoreCase(sameSiteValue)) {
                mode = CookieSameSiteMode.STRICT.toString();
            }
            handler = new SameSiteCookieHandler(handler, mode, config.session().getSessionCookieName());
        }
        if (listener.isCertificateForwarding()) {
            handler = new SSLHeaderHandler(handler);
        }
        undertowOptions.set(UndertowOptions.ENABLE_RFC6265_COOKIE_VALIDATION, listener.isRfc6265CookieValidation());
        undertowOptions.set(UndertowOptions.REQUIRE_HOST_HTTP11, listener.isRequireHostHttp11());
        if (listener.isEnableHttp2()) {
            if (!this.http2Available) {
                LOG.warn("HTTP2 support configured for the listener, but HTTP2 support classes not available");
            } else {
                if (listener instanceof Server.HttpListener) {
                    handler = new Http2UpgradeHandler(handler);
                }
                undertowOptions.set(UndertowOptions.ENABLE_HTTP2, true);
                undertowOptions.set(UndertowOptions.HTTP2_SETTINGS_ENABLE_PUSH, listener.isHttp2EnablePush());
                undertowOptions.set(UndertowOptions.HTTP2_SETTINGS_HEADER_TABLE_SIZE, listener.getHttp2HeaderTableSize());
                undertowOptions.set(UndertowOptions.HTTP2_SETTINGS_INITIAL_WINDOW_SIZE, listener.getHttp2InitialWindowSize());
                undertowOptions.set(UndertowOptions.HTTP2_SETTINGS_MAX_CONCURRENT_STREAMS, (Object)listener.getHttp2MaxConcurrentStreams());
                undertowOptions.set(UndertowOptions.HTTP2_SETTINGS_MAX_FRAME_SIZE, listener.getHttp2MaxFrameSize());
                undertowOptions.set(UndertowOptions.HTTP2_SETTINGS_MAX_HEADER_LIST_SIZE, (Object)listener.getHttp2MaxHeaderListSize());
            }
        }
        if ((connectorName = listener.getName()) == null || "".equals(connectorName.trim())) {
            connectorName = defaultConnectorName;
        }
        undertowOptions.set(PAX_WEB_CONNECTOR_NAME, (Object)connectorName);
        return handler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SSLContext buildSSLContext(Configuration config, Server.HttpsListener definition, SecurityRealm realm) {
        SecurityRealm.Keystore keystore;
        SecurityRealm.Truststore truststore;
        SecurityConfiguration sec = config.security();
        if (realm == null || realm.getAuthentication() == null || realm.getAuthentication().getTruststore() == null) {
            truststore = new SecurityRealm.Truststore();
            truststore.setPath(sec.getTruststore());
            truststore.setPassword(sec.getTruststorePassword());
            truststore.setType(sec.getTruststoreType());
        } else {
            truststore = realm.getAuthentication().getTruststore();
        }
        if (realm == null || realm.getIdentities() == null || realm.getIdentities().getSsl() == null || realm.getIdentities().getSsl().getKeystore() == null) {
            keystore = new SecurityRealm.Keystore();
            keystore.setPath(sec.getSslKeystore());
            keystore.setPassword(sec.getSslKeystorePassword());
            keystore.setType(sec.getTruststoreType());
            keystore.setKeyPassword(sec.getSslKeyPassword());
            keystore.setAlias(sec.getSslKeyAlias());
        } else {
            keystore = realm.getIdentities().getSsl().getKeystore();
        }
        try {
            SecureRandom random;
            String keyManagerFactoryAlgorithm;
            URL keystoreURL = this.loadResource(keystore.getPath());
            String keystoreType = keystore.getType() == null ? "JKS" : keystore.getType();
            String keyAlias = keystore.getAlias();
            KeyStore keyStore = this.getKeyStore(sec, keystoreURL, keystoreType, keystore.getPassword(), sec.getSslKeystoreProvider());
            if (keyAlias != null) {
                KeyStore newKeystore = KeyStore.getInstance(keystoreType);
                newKeystore.load(null);
                if (!keyStore.containsAlias(keyAlias)) throw new IllegalArgumentException("Entry \"" + keyAlias + "\" not found in keystore " + keystore.getPath());
                KeyStore.PasswordProtection password = new KeyStore.PasswordProtection(keystore.getKeyPassword().toCharArray());
                if (!keyStore.isKeyEntry(keyAlias)) throw new IllegalArgumentException("Entry \"" + keyAlias + "\" is not private key entry in keystore " + keystore.getPath());
                KeyStore.Entry entry = keyStore.getEntry(keyAlias, password);
                newKeystore.setEntry(keyAlias, entry, password);
                keyStore = newKeystore;
            }
            if ((keyManagerFactoryAlgorithm = sec.getSslKeyManagerFactoryAlgorithm()) == null) {
                keyManagerFactoryAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(keyManagerFactoryAlgorithm);
            keyManagerFactory.init(keyStore, keystore.getKeyPassword() == null ? null : keystore.getKeyPassword().toCharArray());
            KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
            TrustManager[] trustManagers = null;
            SecureRandom secureRandom = random = sec.getSecureRandomAlgorithm() == null ? null : SecureRandom.getInstance(sec.getSecureRandomAlgorithm());
            if (truststore.getPath() != null) {
                Collection<? extends CRL> crls;
                URL truststoreURL = this.loadResource(truststore.getPath());
                String truststoreType = truststore.getType() == null ? "JKS" : truststore.getType();
                KeyStore trustStore = this.getKeyStore(sec, truststoreURL, truststoreType, truststore.getPassword(), sec.getTruststoreProvider());
                String trustManagerFactoryAlgorithm = sec.getTrustManagerFactoryAlgorithm();
                if (trustManagerFactoryAlgorithm == null) {
                    trustManagerFactoryAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
                }
                Collection<? extends CRL> collection = crls = sec.getCrlPath() == null ? null : this.loadCRL(sec.getCrlPath());
                if (sec.isValidateCerts().booleanValue()) {
                    Certificate cert;
                    String keystoreCertAlias = keystore.getAlias();
                    if (keystoreCertAlias == null) {
                        ArrayList<String> aliases = Collections.list(keyStore.aliases());
                        keystoreCertAlias = aliases.size() == 1 ? (String)aliases.get(0) : null;
                    }
                    Certificate certificate = cert = keystoreCertAlias == null ? null : keyStore.getCertificate(keystoreCertAlias);
                    if (cert == null) {
                        throw new IllegalArgumentException("No certificate found in the keystore" + (keystoreCertAlias == null ? "" : " for alias \"" + keystoreCertAlias + "\""));
                    }
                    CertificateValidator validator = new CertificateValidator(trustStore, crls);
                    validator.setEnableCRLDP(sec.isEnableCRLDP());
                    validator.setEnableOCSP(sec.isEnableOCSP());
                    validator.setOcspResponderURL(sec.getOcspResponderURL());
                    validator.validate(keyStore, cert);
                }
                if (sec.isValidatePeerCerts().booleanValue() && trustManagerFactoryAlgorithm.equalsIgnoreCase("PKIX")) {
                    PKIXBuilderParameters pbParams = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
                    pbParams.setRevocationEnabled(true);
                    if (crls != null && !crls.isEmpty()) {
                        pbParams.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(crls)));
                    }
                    if (sec.isEnableCRLDP().booleanValue()) {
                        System.setProperty("com.sun.security.enableCRLDP", "true");
                    }
                    if (sec.isEnableOCSP().booleanValue()) {
                        Security.setProperty("ocsp.enable", "true");
                        if (sec.getOcspResponderURL() != null) {
                            Security.setProperty("ocsp.responderURL", sec.getOcspResponderURL());
                        }
                    }
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(trustManagerFactoryAlgorithm);
                    trustManagerFactory.init(new CertPathTrustManagerParameters(pbParams));
                    trustManagers = trustManagerFactory.getTrustManagers();
                } else {
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(trustManagerFactoryAlgorithm);
                    trustManagerFactory.init(trustStore);
                    trustManagers = trustManagerFactory.getTrustManagers();
                }
            }
            SSLContext context = null == sec.getSslProvider() || sec.getSslProvider().isEmpty() ? SSLContext.getInstance("TLS") : SSLContext.getInstance("TLS", sec.getSslProvider());
            context.init(keyManagers, trustManagers, random);
            context.getClientSessionContext().setSessionCacheSize(definition.getSslSessionCacheSize());
            context.getClientSessionContext().setSessionTimeout(definition.getSslSessionTimeout());
            context.getServerSessionContext().setSessionCacheSize(definition.getSslSessionCacheSize());
            context.getServerSessionContext().setSessionTimeout(definition.getSslSessionTimeout());
            return context;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to build SSL context", e);
        }
    }

    private URL loadResource(String resource) throws MalformedURLException {
        URL url;
        if (resource == null || "".equals(resource.trim())) {
            return null;
        }
        try {
            url = new URL(resource);
        }
        catch (MalformedURLException e) {
            if (!(resource.startsWith("ftp:") || resource.startsWith("file:") || resource.startsWith("jar:"))) {
                try {
                    File file = new File(resource).getCanonicalFile();
                    url = file.toURI().toURL();
                }
                catch (Exception e2) {
                    throw e;
                }
            }
            throw e;
        }
        return url;
    }

    private KeyStore getKeyStore(SecurityConfiguration sec, URL storePath, String storeType, String storePassword, String provider) throws Exception {
        KeyStore keystore = provider == null ? KeyStore.getInstance(storeType) : KeyStore.getInstance(storeType, provider);
        if (storePath != null) {
            try (InputStream is = storePath.openStream();){
                keystore.load(is, storePassword.toCharArray());
            }
        } else {
            keystore.load(null, storePassword.toCharArray());
        }
        return keystore;
    }

    public Collection<? extends CRL> loadCRL(String crlPath) throws Exception {
        URL url;
        Collection<? extends CRL> crlList = null;
        if (crlPath != null && (url = this.loadResource(crlPath)) != null) {
            try (InputStream in = url.openStream();){
                crlList = CertificateFactory.getInstance("X.509").generateCRLs(in);
            }
        }
        return crlList;
    }

    public DeploymentInfo clearFilters(DeploymentInfo existing, boolean clearDynamicFilters, boolean clearNonDynamicFilters) {
        DeploymentInfo info = new DeploymentInfo().setClassLoader(existing.getClassLoader()).setContextPath(existing.getContextPath()).setResourceManager(existing.getResourceManager()).setMajorVersion(existing.getMajorVersion()).setMinorVersion(existing.getMinorVersion()).setDeploymentName(existing.getDeploymentName()).setClassIntrospecter(existing.getClassIntrospecter());
        for (Map.Entry e : existing.getServlets().entrySet()) {
            info.addServlet(((ServletInfo)e.getValue()).clone());
        }
        HashSet<String> names = new HashSet<String>();
        for (Map.Entry e : existing.getFilters().entrySet()) {
            FilterModel fm;
            FilterInfo fi = (FilterInfo)e.getValue();
            if (!(fi instanceof PaxWebFilterInfo) || (fm = ((PaxWebFilterInfo)fi).getFilterModel()) != null && (clearDynamicFilters || !fm.isDynamic()) && (clearNonDynamicFilters || fm.isDynamic())) continue;
            info.addFilter(fi);
            names.add(fi.getName());
        }
        for (FilterMappingInfo fm : existing.getFilterMappings()) {
            if (!names.contains(fm.getFilterName())) continue;
            if (fm.getMappingType() == FilterMappingInfo.MappingType.SERVLET) {
                info.addFilterServletNameMapping(fm.getFilterName(), fm.getMapping(), fm.getDispatcher());
            }
            if (fm.getMappingType() != FilterMappingInfo.MappingType.URL) continue;
            info.addFilterUrlMapping(fm.getFilterName(), fm.getMapping(), fm.getDispatcher());
        }
        info.setDisplayName(existing.getDisplayName());
        info.getListeners().addAll(existing.getListeners());
        info.getServletContainerInitializers().addAll(existing.getServletContainerInitializers());
        info.getThreadSetupActions().addAll(existing.getThreadSetupActions());
        info.getInitParameters().putAll(existing.getInitParameters());
        info.getServletContextAttributes().putAll(existing.getServletContextAttributes());
        info.getWelcomePages().addAll(existing.getWelcomePages());
        info.getErrorPages().addAll(existing.getErrorPages());
        info.getMimeMappings().addAll(existing.getMimeMappings());
        info.setExecutor(existing.getExecutor());
        info.setAsyncExecutor(existing.getAsyncExecutor());
        info.setTempDir(existing.getTempDir());
        info.setJspConfigDescriptor(existing.getJspConfigDescriptor());
        info.setDefaultServletConfig(existing.getDefaultServletConfig());
        info.getLocaleCharsetMapping().putAll(existing.getLocaleCharsetMapping());
        info.setSessionManagerFactory(existing.getSessionManagerFactory());
        if (existing.getLoginConfig() != null) {
            info.setLoginConfig(existing.getLoginConfig().clone());
        }
        info.setIdentityManager(existing.getIdentityManager());
        info.setConfidentialPortManager(existing.getConfidentialPortManager());
        info.setDefaultEncoding(existing.getDefaultEncoding());
        info.setUrlEncoding(existing.getUrlEncoding());
        info.getSecurityConstraints().addAll(existing.getSecurityConstraints());
        info.getOuterHandlerChainWrappers().addAll(existing.getOuterHandlerChainWrappers());
        info.getInnerHandlerChainWrappers().addAll(existing.getInnerHandlerChainWrappers());
        info.setInitialSecurityWrapper(existing.getInitialSecurityWrapper());
        info.getSecurityWrappers().addAll(existing.getSecurityWrappers());
        info.getInitialHandlerChainWrappers().addAll(existing.getInitialHandlerChainWrappers());
        info.getSecurityRoles().addAll(existing.getSecurityRoles());
        info.getNotificationReceivers().addAll(existing.getNotificationReceivers());
        info.setAllowNonStandardWrappers(existing.isAllowNonStandardWrappers());
        info.setDefaultSessionTimeout(existing.getDefaultSessionTimeout());
        info.setServletContextAttributeBackingMap(existing.getServletContextAttributeBackingMap());
        info.setServletSessionConfig(existing.getServletSessionConfig());
        info.setHostName(existing.getHostName());
        info.setDenyUncoveredHttpMethods(existing.isDenyUncoveredHttpMethods());
        info.setServletStackTraces(existing.getServletStackTraces());
        info.setInvalidateSessionOnLogout(existing.isInvalidateSessionOnLogout());
        info.setDefaultCookieVersion(existing.getDefaultCookieVersion());
        info.setSessionPersistenceManager(existing.getSessionPersistenceManager());
        for (Map.Entry e : existing.getPrincipalVersusRolesMap().entrySet()) {
            info.getPrincipalVersusRolesMap().put(e.getKey(), new HashSet((Collection)e.getValue()));
        }
        info.setIgnoreFlush(existing.isIgnoreFlush());
        info.setAuthorizationManager(existing.getAuthorizationManager());
        info.getAuthenticationMechanisms().putAll(existing.getAuthenticationMechanisms());
        info.getServletExtensions().addAll(existing.getServletExtensions());
        info.setJaspiAuthenticationMechanism(existing.getJaspiAuthenticationMechanism());
        info.setSecurityContextFactory(existing.getSecurityContextFactory());
        info.setServerName(existing.getServerName());
        info.setMetricsCollector(existing.getMetricsCollector());
        info.setSessionConfigWrapper(existing.getSessionConfigWrapper());
        info.setEagerFilterInit(existing.isEagerFilterInit());
        info.setDisableCachingForSecuredPages(existing.isDisableCachingForSecuredPages());
        info.setExceptionHandler(existing.getExceptionHandler());
        info.setEscapeErrorMessage(existing.isEscapeErrorMessage());
        info.getSessionListeners().addAll(existing.getSessionListeners());
        info.getLifecycleInterceptors().addAll(existing.getLifecycleInterceptors());
        info.setAuthenticationMode(existing.getAuthenticationMode());
        info.setDefaultMultipartConfig(existing.getDefaultMultipartConfig());
        info.setContentTypeCacheSize(existing.getContentTypeCacheSize());
        info.setSessionIdGenerator(existing.getSessionIdGenerator());
        info.setSendCustomReasonPhraseOnError(existing.isSendCustomReasonPhraseOnError());
        info.setChangeSessionIdOnLogin(existing.isChangeSessionIdOnLogin());
        info.setCrawlerSessionManagerConfig(existing.getCrawlerSessionManagerConfig());
        info.setSecurityDisabled(existing.isSecurityDisabled());
        info.setUseCachedAuthenticationMechanism(existing.isUseCachedAuthenticationMechanism());
        info.setCheckOtherSessionManagers(existing.isCheckOtherSessionManagers());
        info.setDefaultRequestEncoding(existing.getDefaultRequestEncoding());
        info.setDefaultResponseEncoding(existing.getDefaultResponseEncoding());
        info.getPreCompressedResources().putAll(existing.getPreCompressedResources());
        info.setContainerMajorVersion(existing.getContainerMajorVersion());
        info.setContainerMinorVersion(existing.getContainerMinorVersion());
        info.getDeploymentCompleteListeners().addAll(existing.getDeploymentCompleteListeners());
        info.setPreservePathOnForward(existing.isPreservePathOnForward());
        return info;
    }

    public static class AcceptingChannelWithAddress {
        private final AcceptingChannel<? extends StreamConnection> acceptingChannel;
        private final InetSocketAddress address;
        private boolean secure;

        public AcceptingChannelWithAddress(AcceptingChannel<? extends StreamConnection> acceptingChannel, InetSocketAddress address) {
            this.acceptingChannel = acceptingChannel;
            this.address = address;
        }

        public AcceptingChannel<? extends StreamConnection> getAcceptingChannel() {
            return this.acceptingChannel;
        }

        public InetSocketAddress getAddress() {
            return this.address;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public void setSecure(boolean secure) {
            this.secure = secure;
        }

        public String toString() {
            return "AcceptingChannelWithAddress{acceptingChannel=" + this.acceptingChannel + ", address=" + this.address + ", secure=" + this.secure + "}";
        }
    }
}

