/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.internal.security;

import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.idm.PasswordCredential;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesIdentityManager
implements IdentityManager {
    public static final Logger LOG = LoggerFactory.getLogger(PropertiesIdentityManager.class);
    private final Map<String, String> users = new HashMap<String, String>();
    private final Map<String, Set<String>> roles = new HashMap<String, Set<String>>();

    public PropertiesIdentityManager(Map<String, String> config) {
        config.forEach((user, credentials) -> {
            String[] creds;
            String[] stringArray = creds = credentials != null ? credentials.split("\\s*,\\s*") : new String[]{};
            if (creds.length == 0) {
                return;
            }
            this.users.put((String)user, creds[0].trim());
            if (creds.length > 1) {
                HashSet<String> roles = new HashSet<String>();
                for (int i = 1; i < creds.length; ++i) {
                    roles.add(creds[i].trim());
                }
                this.roles.put((String)user, (Set<String>)roles);
            } else {
                this.roles.put((String)user, Collections.emptySet());
            }
        });
    }

    public Account verify(Account account) {
        return null;
    }

    public Account verify(Credential credential) {
        return null;
    }

    public Account verify(String id, Credential credential) {
        if (credential instanceof PasswordCredential) {
            char[] password = ((PasswordCredential)credential).getPassword();
            String pwd = this.users.get(id);
            if (pwd != null && this.compare(pwd, new String(password))) {
                return new AccountImpl(new SimplePrincipal(id), this.roles.get(id));
            }
        }
        return null;
    }

    private boolean compare(String stored, String provided) {
        if (stored.contains(":")) {
            String alg = stored.substring(0, stored.indexOf(58));
            stored = stored.substring(stored.indexOf(58) + 1).toUpperCase();
            try {
                MessageDigest md = MessageDigest.getInstance(alg);
                byte[] hash = md.digest(provided.getBytes(StandardCharsets.UTF_8));
                String encoded = PropertiesIdentityManager.encode(hash);
                return stored.equals(encoded);
            }
            catch (NoSuchAlgorithmException e) {
                LOG.warn("Can't verify credentials: {}", (Object)e.getMessage(), (Object)e);
                return false;
            }
        }
        return stored.equals(provided);
    }

    public static String encode(byte[] bytes) {
        StringWriter sw = new StringWriter();
        for (byte b : bytes) {
            sw.append(String.format("%02x", b));
        }
        return sw.toString().toUpperCase();
    }

    static class AccountImpl
    implements Account {
        private final Principal principal;
        private final Set<String> roles;

        AccountImpl(Principal principal, Set<String> roles) {
            this.principal = principal;
            this.roles = roles;
        }

        public Principal getPrincipal() {
            return this.principal;
        }

        public Set<String> getRoles() {
            return this.roles;
        }
    }

    static class SimplePrincipal
    implements Principal {
        private final String name;

        SimplePrincipal(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

