/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.common.actor;

import akka.actor.AbstractActor;
import akka.actor.ActorRef;
import akka.persistence.AbstractPersistentActor;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.common.actor.ExecuteInSelfActor;
import org.opendaylight.controller.cluster.common.actor.ExecuteInSelfMessage;
import org.opendaylight.controller.cluster.common.actor.Monitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUntypedPersistentActor
extends AbstractPersistentActor
implements ExecuteInSelfActor {
    @SuppressFBWarnings(value={"SLF4J_LOGGER_SHOULD_BE_PRIVATE"})
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());

    @SuppressFBWarnings(value={"MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR"}, justification="Akka class design")
    protected AbstractUntypedPersistentActor() {
        this.LOG.trace("Actor created {}", (Object)this.getSelf());
        this.getContext().system().actorSelection("user/termination-monitor").tell((Object)new Monitor(this.getSelf()), this.getSelf());
    }

    @Override
    public final void executeInSelf(@NonNull Runnable runnable) {
        ExecuteInSelfMessage message = new ExecuteInSelfMessage(runnable);
        this.LOG.trace("Scheduling execution of {}", (Object)message);
        this.self().tell((Object)message, ActorRef.noSender());
    }

    public final AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(ExecuteInSelfMessage.class, ExecuteInSelfMessage::run).matchAny(this::handleCommand).build();
    }

    public final AbstractActor.Receive createReceiveRecover() {
        return this.receiveBuilder().matchAny(this::handleRecover).build();
    }

    protected abstract void handleRecover(Object var1) throws Exception;

    protected abstract void handleCommand(Object var1) throws Exception;

    protected void ignoreMessage(Object message) {
        this.LOG.debug("Unhandled message {} ", message);
    }

    protected void unknownMessage(Object message) {
        this.LOG.debug("Received unhandled message {}", message);
        this.unhandled(message);
    }
}

