/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.common.actor;

import java.util.Objects;
import scala.concurrent.ExecutionContext;

public class Dispatchers {
    public static final String DEFAULT_DISPATCHER_PATH = "akka.actor.default-dispatcher";
    public static final String CLIENT_DISPATCHER_PATH = "client-dispatcher";
    public static final String TXN_DISPATCHER_PATH = "txn-dispatcher";
    public static final String SHARD_DISPATCHER_PATH = "shard-dispatcher";
    public static final String NOTIFICATION_DISPATCHER_PATH = "notification-dispatcher";
    public static final String SERIALIZATION_DISPATCHER_PATH = "serialization-dispatcher";
    private final akka.dispatch.Dispatchers dispatchers;

    public Dispatchers(akka.dispatch.Dispatchers dispatchers) {
        this.dispatchers = Objects.requireNonNull(dispatchers, "dispatchers should not be null");
    }

    public ExecutionContext getDispatcher(DispatcherType dispatcherType) {
        return dispatcherType.dispatcher(this.dispatchers);
    }

    public String getDispatcherPath(DispatcherType dispatcherType) {
        return dispatcherType.path(this.dispatchers);
    }

    public static enum DispatcherType {
        Client("client-dispatcher"),
        Transaction("txn-dispatcher"),
        Shard("shard-dispatcher"),
        Notification("notification-dispatcher"),
        Serialization("serialization-dispatcher");

        private final String path;

        private DispatcherType(String path) {
            this.path = path;
        }

        String path(akka.dispatch.Dispatchers knownDispatchers) {
            if (knownDispatchers.hasDispatcher(this.path)) {
                return this.path;
            }
            return Dispatchers.DEFAULT_DISPATCHER_PATH;
        }

        ExecutionContext dispatcher(akka.dispatch.Dispatchers knownDispatchers) {
            if (knownDispatchers.hasDispatcher(this.path)) {
                return knownDispatchers.lookup(this.path);
            }
            return knownDispatchers.defaultGlobalDispatcher();
        }
    }
}

