/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.common.actor;

import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.File;
import javax.inject.Singleton;
import org.opendaylight.controller.cluster.common.actor.AkkaConfigurationReader;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Component(immediate=true)
public class FileAkkaConfigurationReader
implements AkkaConfigurationReader {
    private static final Logger LOG = LoggerFactory.getLogger(FileAkkaConfigurationReader.class);
    private static final String CUSTOM_AKKA_CONF_PATH = "./configuration/initial/akka.conf";
    private static final String FACTORY_AKKA_CONF_PATH = "./configuration/factory/akka.conf";

    @Override
    public Config read() {
        File customConfigFile = new File(CUSTOM_AKKA_CONF_PATH);
        Preconditions.checkState((boolean)customConfigFile.exists(), (String)"%s is missing", (Object)customConfigFile);
        File factoryConfigFile = new File(FACTORY_AKKA_CONF_PATH);
        if (factoryConfigFile.exists()) {
            return ConfigFactory.parseFile((File)customConfigFile).withFallback((ConfigMergeable)ConfigFactory.parseFile((File)factoryConfigFile));
        }
        return ConfigFactory.parseFile((File)customConfigFile);
    }

    @Activate
    void activate() {
        LOG.info("File-based Akka configuration reader enabled");
    }

    @Deactivate
    void deactivate() {
        LOG.info("File-based Akka configuration reader disabled");
    }
}

