/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.common.actor;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.dispatch.BoundedDequeBasedMailbox;
import akka.dispatch.MailboxType;
import akka.dispatch.ProducesMessageQueue;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.typesafe.config.Config;
import org.opendaylight.controller.cluster.common.actor.CommonConfig;
import org.opendaylight.controller.cluster.reporting.MetricsReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.concurrent.duration.FiniteDuration;

public class MeteredBoundedMailbox
implements MailboxType,
ProducesMessageQueue<MeteredMessageQueue> {
    private static final Logger LOG = LoggerFactory.getLogger(MeteredBoundedMailbox.class);
    private static final String QUEUE_SIZE = "q-size";
    private final Integer capacity;
    private final FiniteDuration pushTimeOut;

    public MeteredBoundedMailbox(ActorSystem.Settings settings, Config config) {
        CommonConfig commonConfig = new CommonConfig(settings.config());
        this.capacity = commonConfig.getMailBoxCapacity();
        this.pushTimeOut = commonConfig.getMailBoxPushTimeout();
    }

    public MeteredMessageQueue create(Option<ActorRef> owner, Option<ActorSystem> system) {
        MeteredMessageQueue queue = new MeteredMessageQueue(this.capacity, this.pushTimeOut);
        MeteredBoundedMailbox.monitorQueueSize(owner, queue);
        return queue;
    }

    private static void monitorQueueSize(Option<ActorRef> owner, MeteredMessageQueue monitoredQueue) {
        MeteredBoundedMailbox.registerMetric(owner, QUEUE_SIZE, MeteredBoundedMailbox.getQueueSizeGuage(monitoredQueue));
    }

    private static Gauge<Integer> getQueueSizeGuage(MeteredMessageQueue monitoredQueue) {
        return () -> monitoredQueue.size();
    }

    static <T extends Metric> void registerMetric(Option<ActorRef> owner, String metricName, T metric) {
        if (owner.isEmpty()) {
            return;
        }
        String actorName = ((ActorRef)owner.get()).path().toStringWithoutAddress();
        String fullName = MetricRegistry.name((String)actorName, (String[])new String[]{metricName});
        MetricRegistry registry = MetricsReporter.getInstance("org.opendaylight.controller.actor.metric").getMetricsRegistry();
        if (registry.getMetrics().containsKey(fullName)) {
            return;
        }
        try {
            registry.register(fullName, metric);
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Unable to register '{}' in metrics registry", (Object)fullName);
        }
    }

    public static class MeteredMessageQueue
    extends BoundedDequeBasedMailbox.MessageQueue {
        private static final long serialVersionUID = 1L;

        public MeteredMessageQueue(int capacity, FiniteDuration pushTimeOut) {
            super(capacity, pushTimeOut);
        }
    }
}

