/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.common.actor;

import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.Props;
import akka.actor.UntypedAbstractActor;
import akka.cluster.Cluster;
import akka.cluster.ClusterEvent;
import akka.japi.Effect;
import akka.remote.AssociationErrorEvent;
import akka.remote.RemotingLifecycleEvent;
import akka.remote.artery.ThisActorSystemQuarantinedEvent;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuarantinedMonitorActor
extends UntypedAbstractActor {
    public static final String ADDRESS = "quarantined-monitor";
    private static final Logger LOG = LoggerFactory.getLogger(QuarantinedMonitorActor.class);
    private static final Integer MESSAGE_THRESHOLD = 10;
    private final Effect callback;
    private boolean quarantined;
    private final Set<Address> addressSet = new HashSet<Address>();
    private int count = 0;

    @SuppressFBWarnings(value={"MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR"}, justification="Akka class design")
    protected QuarantinedMonitorActor(Effect callback) {
        this.callback = callback;
        LOG.debug("Created QuarantinedMonitorActor");
        this.getContext().system().eventStream().subscribe(this.getSelf(), RemotingLifecycleEvent.class);
        this.getContext().system().eventStream().subscribe(this.getSelf(), ClusterEvent.MemberDowned.class);
    }

    public void postStop() {
        LOG.debug("Stopping QuarantinedMonitorActor");
    }

    public void onReceive(Object message) throws Exception {
        String messageType = message.getClass().getSimpleName();
        LOG.trace("onReceive {} {}", (Object)messageType, message);
        if (this.quarantined) {
            return;
        }
        if (message instanceof ThisActorSystemQuarantinedEvent) {
            ThisActorSystemQuarantinedEvent event = (ThisActorSystemQuarantinedEvent)message;
            LOG.warn("Got quarantined by {}", (Object)event.remoteAddress());
            this.quarantined = true;
            this.callback.apply();
        } else if (message instanceof AssociationErrorEvent) {
            AssociationErrorEvent event = (AssociationErrorEvent)message;
            String errorMessage = message.toString();
            LOG.trace("errorMessage:{}", (Object)errorMessage);
            if (errorMessage.contains("The remote system has a UID that has been quarantined")) {
                Address address = event.getRemoteAddress();
                this.addressSet.add(address);
                ++this.count;
                LOG.trace("address:{} addressSet: {} count:{}", new Object[]{address, this.addressSet, this.count});
                if (this.count >= MESSAGE_THRESHOLD && this.addressSet.size() > 1) {
                    this.count = 0;
                    this.addressSet.clear();
                    LOG.warn("Got quarantined via AssociationEvent by {}", (Object)event.remoteAddress());
                    this.quarantined = true;
                    this.callback.apply();
                }
            } else if (errorMessage.contains("The remote system explicitly disassociated")) {
                this.count = 0;
                this.addressSet.clear();
            }
        } else if (message instanceof ClusterEvent.MemberDowned) {
            ClusterEvent.MemberDowned event = (ClusterEvent.MemberDowned)message;
            if (Cluster.get((ActorSystem)this.getContext().system()).selfMember().equals((Object)event.member())) {
                LOG.warn("This member has been downed, restarting");
                this.callback.apply();
            }
        }
    }

    public static Props props(Effect callback) {
        return Props.create(QuarantinedMonitorActor.class, (Object[])new Object[]{callback});
    }
}

