/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.io;

import com.google.common.annotations.Beta;
import com.google.common.io.ByteSource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import net.jpountz.lz4.LZ4FrameOutputStream;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.io.LZ4InputOutputStreamSupport;
import org.opendaylight.controller.cluster.io.PlainInputOutputStreamSupport;

@Beta
public abstract class InputOutputStreamFactory {
    InputOutputStreamFactory() {
    }

    public static @NonNull InputOutputStreamFactory simple() {
        return PlainInputOutputStreamSupport.INSTANCE;
    }

    public static @NonNull InputOutputStreamFactory lz4(String blockSize) {
        return InputOutputStreamFactory.lz4(LZ4FrameOutputStream.BLOCKSIZE.valueOf((String)("SIZE_" + blockSize)));
    }

    public static @NonNull InputOutputStreamFactory lz4(LZ4FrameOutputStream.BLOCKSIZE blockSize) {
        return new LZ4InputOutputStreamSupport(Objects.requireNonNull(blockSize));
    }

    public abstract @NonNull InputStream createInputStream(ByteSource var1) throws IOException;

    public abstract @NonNull InputStream createInputStream(File var1) throws IOException;

    public abstract @NonNull OutputStream createOutputStream(File var1) throws IOException;

    public abstract @NonNull OutputStream wrapOutputStream(OutputStream var1) throws IOException;

    static @NonNull BufferedInputStream defaultCreateInputStream(File file) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(file));
    }

    static @NonNull BufferedOutputStream defaultCreateOutputStream(File file) throws FileNotFoundException {
        return new BufferedOutputStream(new FileOutputStream(file));
    }
}

