/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.io;

import com.google.common.io.ByteSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FrameInputStream;
import net.jpountz.lz4.LZ4FrameOutputStream;
import net.jpountz.xxhash.XXHashFactory;
import org.opendaylight.controller.cluster.io.InputOutputStreamFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LZ4InputOutputStreamSupport
extends InputOutputStreamFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LZ4InputOutputStreamSupport.class);
    private static final LZ4Factory LZ4_FACTORY = LZ4Factory.fastestInstance();
    private static final XXHashFactory HASH_FACTORY = XXHashFactory.fastestInstance();
    private final LZ4FrameOutputStream.BLOCKSIZE blocksize;

    LZ4InputOutputStreamSupport(LZ4FrameOutputStream.BLOCKSIZE blocksize) {
        this.blocksize = blocksize;
    }

    @Override
    public InputStream createInputStream(ByteSource input) throws IOException {
        InputStream stream = input.openStream();
        try {
            return new LZ4FrameInputStream(stream, LZ4_FACTORY.safeDecompressor(), HASH_FACTORY.hash32());
        }
        catch (IOException e) {
            stream.close();
            LOG.warn("Error loading with lz4 decompression, using default one", (Throwable)e);
            return input.openBufferedStream();
        }
    }

    @Override
    public InputStream createInputStream(File file) throws IOException {
        FileInputStream fileInput = new FileInputStream(file);
        try {
            return new LZ4FrameInputStream((InputStream)fileInput, LZ4_FACTORY.safeDecompressor(), HASH_FACTORY.hash32());
        }
        catch (IOException e) {
            fileInput.close();
            LOG.warn("Error loading file with lz4 decompression, using default one", (Throwable)e);
            return LZ4InputOutputStreamSupport.defaultCreateInputStream(file);
        }
    }

    @Override
    public OutputStream createOutputStream(File file) throws IOException {
        return new LZ4FrameOutputStream((OutputStream)new FileOutputStream(file), this.blocksize, -1L, LZ4_FACTORY.fastCompressor(), HASH_FACTORY.hash32(), new LZ4FrameOutputStream.FLG.Bits[]{LZ4FrameOutputStream.FLG.Bits.BLOCK_INDEPENDENCE});
    }

    @Override
    public OutputStream wrapOutputStream(OutputStream output) throws IOException {
        return new LZ4FrameOutputStream(output, this.blocksize, -1L, LZ4_FACTORY.fastCompressor(), HASH_FACTORY.hash32(), new LZ4FrameOutputStream.FLG.Bits[]{LZ4FrameOutputStream.FLG.Bits.BLOCK_INDEPENDENCE});
    }
}

