/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.io;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.opendaylight.controller.cluster.io.FileBackedOutputStream;

public class SharedFileBackedOutputStream
extends FileBackedOutputStream {
    private final AtomicInteger usageCount = new AtomicInteger(1);
    private Consumer onCleanupCallback;
    private Object onCleanupContext;

    public SharedFileBackedOutputStream(int fileThreshold, String fileDirectory) {
        super(fileThreshold, fileDirectory);
    }

    public void incrementUsageCount() {
        this.usageCount.getAndIncrement();
    }

    public int getUsageCount() {
        return this.usageCount.get();
    }

    public <T> void setOnCleanupCallback(Consumer<T> callback, T context) {
        this.onCleanupCallback = callback;
        this.onCleanupContext = context;
    }

    @Override
    public void cleanup() {
        Preconditions.checkState((this.usageCount.get() > 0 ? 1 : 0) != 0);
        if (this.usageCount.decrementAndGet() == 0) {
            super.cleanup();
            if (this.onCleanupCallback != null) {
                this.onCleanupCallback.accept(this.onCleanupContext);
            }
        }
    }
}

