/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.model.ri;

import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.ri.BindingTypes;
import org.opendaylight.mdsal.binding.model.ri.Types;
import org.opendaylight.yangtools.yang.common.Decimal64;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.common.Uint8;

public final class BaseYangTypes {
    public static final Type BOOLEAN_TYPE = Types.BOOLEAN;
    public static final Type EMPTY_TYPE = Types.typeForClass(Empty.class);
    public static final Type ENUM_TYPE = Types.typeForClass(Enum.class);
    public static final Type INT8_TYPE = Types.typeForClass(Byte.class);
    public static final Type INT16_TYPE = Types.typeForClass(Short.class);
    public static final Type INT32_TYPE = Types.typeForClass(Integer.class);
    public static final Type INT64_TYPE = Types.typeForClass(Long.class);
    public static final Type STRING_TYPE = Types.STRING;
    public static final Type DECIMAL64_TYPE = Types.typeForClass(Decimal64.class);
    public static final Type UINT8_TYPE = Types.typeForClass(Uint8.class);
    public static final Type UINT16_TYPE = Types.typeForClass(Uint16.class);
    public static final Type UINT32_TYPE = Types.typeForClass(Uint32.class);
    public static final Type UINT64_TYPE = Types.typeForClass(Uint64.class);
    public static final Type BINARY_TYPE = Types.BYTE_ARRAY;
    public static final Type INSTANCE_IDENTIFIER = Types.parameterizedTypeFor((Type)BindingTypes.INSTANCE_IDENTIFIER, new Type[0]);

    private BaseYangTypes() {
    }

    public static Type javaTypeForYangType(String type) {
        return switch (type) {
            case "binary" -> BINARY_TYPE;
            case "boolean" -> BOOLEAN_TYPE;
            case "decimal64" -> DECIMAL64_TYPE;
            case "empty" -> EMPTY_TYPE;
            case "enumeration" -> ENUM_TYPE;
            case "instance-identifier" -> INSTANCE_IDENTIFIER;
            case "int8" -> INT8_TYPE;
            case "int16" -> INT16_TYPE;
            case "int32" -> INT32_TYPE;
            case "int64" -> INT64_TYPE;
            case "string" -> STRING_TYPE;
            case "uint8" -> UINT8_TYPE;
            case "uint16" -> UINT16_TYPE;
            case "uint32" -> UINT32_TYPE;
            case "uint64" -> UINT64_TYPE;
            default -> null;
        };
    }
}

