/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.clustering.it.provider.impl;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.opendaylight.mdsal.binding.api.NotificationPublishService;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.target.rev170215.IdSequence;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.target.rev170215.IdSequenceBuilder;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PublishNotificationsTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(PublishNotificationsTask.class);
    private static final int SECOND_AS_NANO = 1000000000;
    private final NotificationPublishService notificationPublishService;
    private final String notificationId;
    private final long timeToTake;
    private final long delay;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private long sequenceNumber = 1L;
    private long startTime;
    private ScheduledFuture<?> scheduledFuture;
    private Exception lastError = null;

    public PublishNotificationsTask(NotificationPublishService notificationPublishService, String notificationId, long secondsToTake, long maxPerSecond) {
        this.notificationPublishService = Objects.requireNonNull(notificationPublishService);
        this.notificationId = Objects.requireNonNull(notificationId);
        Preconditions.checkArgument((secondsToTake > 0L ? 1 : 0) != 0);
        this.timeToTake = secondsToTake * 1000000000L;
        Preconditions.checkArgument((maxPerSecond > 0L ? 1 : 0) != 0);
        this.delay = 1000000000L / maxPerSecond;
        LOG.debug("Delay : {}", (Object)this.delay);
    }

    @Override
    public void run() {
        long current = System.nanoTime();
        IdSequence notification = new IdSequenceBuilder().setId(this.notificationId).setSequenceNumber(Long.valueOf(this.sequenceNumber)).build();
        ++this.sequenceNumber;
        try {
            LOG.debug("Publishing notification: {}", (Object)notification);
            this.notificationPublishService.putNotification((Notification)notification);
        }
        catch (InterruptedException e) {
            LOG.warn("Unexpected exception while publishing notification, : {}", (Object)notification, (Object)e);
            this.lastError = e;
            this.scheduledFuture.cancel(false);
            this.executor.shutdown();
            return;
        }
        LOG.debug("current {}, starttime: {}, timetotake: {}, current-start = {}", new Object[]{current, this.startTime, this.timeToTake, current - this.startTime});
        if (current - this.startTime > this.timeToTake) {
            LOG.debug("Sequence number: {}", (Object)this.sequenceNumber);
            this.scheduledFuture.cancel(false);
            this.executor.shutdown();
        }
    }

    public void start() {
        this.startTime = System.nanoTime();
        this.scheduledFuture = this.executor.scheduleAtFixedRate(this, 0L, this.delay, TimeUnit.NANOSECONDS);
    }

    public boolean isFinished() {
        return this.scheduledFuture.isCancelled();
    }

    public long getCurrentNotif() {
        return this.sequenceNumber;
    }

    public Exception getLastError() {
        return this.lastError;
    }
}

