/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.gson;

import com.google.common.base.Preconditions;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactory;
import org.opendaylight.yangtools.yang.data.util.AbstractModuleStringInstanceIdentifierCodec;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.TypeAware;
import org.opendaylight.yangtools.yang.model.util.LeafrefResolver;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class JSONInstanceIdentifierCodec
extends AbstractModuleStringInstanceIdentifierCodec
implements JSONCodec<YangInstanceIdentifier> {
    private final @NonNull DataSchemaContextTree dataContextTree;
    private final JSONCodecFactory codecFactory;
    private final EffectiveModelContext context;

    JSONInstanceIdentifierCodec(EffectiveModelContext context, JSONCodecFactory jsonCodecFactory) {
        this.context = Objects.requireNonNull(context);
        this.dataContextTree = DataSchemaContextTree.from((EffectiveModelContext)context);
        this.codecFactory = Objects.requireNonNull(jsonCodecFactory);
    }

    protected final Module moduleForPrefix(String prefix) {
        Iterator modules = this.context.findModules(prefix).iterator();
        return modules.hasNext() ? (Module)modules.next() : null;
    }

    protected final String prefixForNamespace(XMLNamespace namespace) {
        Iterator modules = this.context.findModules(namespace).iterator();
        return modules.hasNext() ? ((Module)modules.next()).getName() : null;
    }

    protected final DataSchemaContextTree getDataContextTree() {
        return this.dataContextTree;
    }

    protected final Object deserializeKeyValue(DataSchemaNode schemaNode, LeafrefResolver resolver, String value) {
        Objects.requireNonNull(schemaNode, "schemaNode cannot be null");
        if (schemaNode instanceof LeafSchemaNode) {
            LeafSchemaNode leafSchemaNode = (LeafSchemaNode)schemaNode;
            return ((JSONCodec)this.codecFactory.codecFor((TypeAware)leafSchemaNode, resolver)).parseValue(null, value);
        }
        if (schemaNode instanceof LeafListSchemaNode) {
            LeafListSchemaNode leafListSchemaNode = (LeafListSchemaNode)schemaNode;
            return ((JSONCodec)this.codecFactory.codecFor((TypeAware)leafListSchemaNode, resolver)).parseValue(null, value);
        }
        throw new IllegalArgumentException("schemaNode " + schemaNode + " must be of type LeafSchemaNode or LeafListSchemaNode");
    }

    public final Class<YangInstanceIdentifier> getDataType() {
        return YangInstanceIdentifier.class;
    }

    public final YangInstanceIdentifier parseValue(Object ctx, String str) {
        return (YangInstanceIdentifier)this.deserialize(str);
    }

    @Override
    public final void writeValue(JsonWriter ctx, YangInstanceIdentifier value) throws IOException {
        String str;
        try {
            str = (String)this.serialize(value);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Failed to encode instance-identifier", e);
        }
        ctx.value(str);
    }

    static final class RFC7951
    extends JSONInstanceIdentifierCodec {
        RFC7951(EffectiveModelContext context, JSONCodecFactory jsonCodecFactory) {
            super(context, jsonCodecFactory);
        }

        protected StringBuilder appendQName(StringBuilder sb, QName qname, QNameModule lastModule) {
            return qname.getModule().equals((Object)lastModule) ? sb.append(qname.getLocalName()) : super.appendQName(sb, qname, lastModule);
        }

        protected QName createQName(QNameModule lastModule, String localName) {
            Preconditions.checkArgument((lastModule != null ? 1 : 0) != 0, (String)"Unprefixed leading name %s", (Object)localName);
            return QName.create((QNameModule)lastModule, (String)localName);
        }
    }

    static final class Lhotka02
    extends JSONInstanceIdentifierCodec {
        Lhotka02(EffectiveModelContext context, JSONCodecFactory jsonCodecFactory) {
            super(context, jsonCodecFactory);
        }
    }
}

