/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBrokerExtension;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeService;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainListener;
import org.opendaylight.mdsal.dom.broker.AbstractDOMForwardedTransactionFactory;
import org.opendaylight.mdsal.dom.broker.DOMDataBrokerTransactionChainImpl;
import org.opendaylight.mdsal.dom.spi.PingPongMergingDOMDataBroker;
import org.opendaylight.mdsal.dom.spi.store.DOMStore;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTransactionChain;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTreeChangePublisher;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDOMDataBroker
extends AbstractDOMForwardedTransactionFactory<DOMStore>
implements PingPongMergingDOMDataBroker {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDOMDataBroker.class);
    private final AtomicLong txNum = new AtomicLong();
    private final AtomicLong chainNum = new AtomicLong();
    private final ClassToInstanceMap<DOMDataBrokerExtension> extensions;
    private volatile AutoCloseable closeable;

    protected AbstractDOMDataBroker(Map<LogicalDatastoreType, DOMStore> datastores) {
        super(datastores);
        boolean treeChange = true;
        for (DOMStore ds : datastores.values()) {
            if (ds instanceof DOMStoreTreeChangePublisher) continue;
            treeChange = false;
            break;
        }
        this.extensions = treeChange ? ImmutableClassToInstanceMap.of(DOMDataTreeChangeService.class, (Object)new DOMDataTreeChangeService(){

            public <L extends DOMDataTreeChangeListener> ListenerRegistration<L> registerDataTreeChangeListener(DOMDataTreeIdentifier treeId, L listener) {
                DOMStore publisher = (DOMStore)AbstractDOMDataBroker.this.getTxFactories().get(treeId.getDatastoreType());
                Preconditions.checkState((publisher != null ? 1 : 0) != 0, (Object)"Requested logical data store is not available.");
                return ((DOMStoreTreeChangePublisher)publisher).registerTreeChangeListener(treeId.getRootIdentifier(), listener);
            }
        }) : ImmutableClassToInstanceMap.of();
    }

    public void setCloseable(AutoCloseable closeable) {
        this.closeable = closeable;
    }

    @Override
    public void close() {
        super.close();
        if (this.closeable != null) {
            try {
                this.closeable.close();
            }
            catch (Exception e) {
                LOG.debug("Error closing instance", (Throwable)e);
            }
        }
    }

    @Override
    protected Object newTransactionIdentifier() {
        return "DOM-" + this.txNum.getAndIncrement();
    }

    public ClassToInstanceMap<DOMDataBrokerExtension> getExtensions() {
        return this.extensions;
    }

    public DOMTransactionChain createTransactionChain(DOMTransactionChainListener listener) {
        this.checkNotClosed();
        EnumMap<LogicalDatastoreType, DOMStoreTransactionChain> backingChains = new EnumMap<LogicalDatastoreType, DOMStoreTransactionChain>(LogicalDatastoreType.class);
        for (Map.Entry entry : this.getTxFactories().entrySet()) {
            backingChains.put(entry.getKey(), ((DOMStore)entry.getValue()).createTransactionChain());
        }
        long chainId = this.chainNum.getAndIncrement();
        LOG.debug("Transactoin chain {} created with listener {}, backing store chains {}", new Object[]{chainId, listener, backingChains});
        return new DOMDataBrokerTransactionChainImpl(chainId, backingChains, this, listener);
    }
}

