/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.base.Preconditions;
import com.google.common.collect.MutableClassToInstanceMap;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Singleton;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.mdsal.dom.api.DOMMountPointListener;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.mdsal.dom.spi.SimpleDOMMountPoint;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.util.ListenerRegistry;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Component(immediate=true)
public final class DOMMountPointServiceImpl
implements DOMMountPointService {
    private static final Logger LOG = LoggerFactory.getLogger(DOMMountPointServiceImpl.class);
    private final Map<YangInstanceIdentifier, DOMMountPoint> mountPoints = new HashMap<YangInstanceIdentifier, DOMMountPoint>();
    private final ListenerRegistry<DOMMountPointListener> listeners = ListenerRegistry.create();

    public Optional<DOMMountPoint> getMountPoint(YangInstanceIdentifier path) {
        return Optional.ofNullable(this.mountPoints.get(path));
    }

    public DOMMountPointService.DOMMountPointBuilder createMountPoint(YangInstanceIdentifier path) {
        Preconditions.checkState((!this.mountPoints.containsKey(path) ? 1 : 0) != 0, (Object)"Mount point already exists");
        return new DOMMountPointBuilderImpl(path);
    }

    public ListenerRegistration<DOMMountPointListener> registerProvisionListener(DOMMountPointListener listener) {
        return this.listeners.register((EventListener)listener);
    }

    @Activate
    void activate() {
        LOG.info("DOMMountPointService activated");
    }

    @Deactivate
    void deactivate() {
        LOG.info("DOMMountPointService deactivated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectRegistration<DOMMountPoint> registerMountPoint(SimpleDOMMountPoint mountPoint) {
        YangInstanceIdentifier mountPointId = mountPoint.getIdentifier();
        Map<YangInstanceIdentifier, DOMMountPoint> map = this.mountPoints;
        synchronized (map) {
            DOMMountPoint prev = this.mountPoints.putIfAbsent(mountPointId, (DOMMountPoint)mountPoint);
            Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Mount point %s already exists as %s", (Object)mountPointId, (Object)prev);
        }
        this.listeners.streamListeners().forEach(listener -> {
            try {
                listener.onMountPointCreated(mountPointId);
            }
            catch (Exception ex) {
                LOG.error("Listener {} failed on mount point {} created event", new Object[]{listener, mountPoint, ex});
            }
        });
        return new AbstractObjectRegistration<DOMMountPoint>((DOMMountPoint)mountPoint){

            protected void removeRegistration() {
                DOMMountPointServiceImpl.this.unregisterMountPoint((YangInstanceIdentifier)((DOMMountPoint)this.getInstance()).getIdentifier());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterMountPoint(YangInstanceIdentifier mountPointId) {
        Map<YangInstanceIdentifier, DOMMountPoint> map = this.mountPoints;
        synchronized (map) {
            if (this.mountPoints.remove(mountPointId) == null) {
                LOG.warn("Removing non-existent mount point {} at", (Object)mountPointId, (Object)new Throwable());
                return;
            }
        }
        this.listeners.streamListeners().forEach(listener -> {
            try {
                listener.onMountPointRemoved(mountPointId);
            }
            catch (Exception ex) {
                LOG.error("Listener {} failed on mount point {} removed event", new Object[]{listener, mountPointId, ex});
            }
        });
    }

    private final class DOMMountPointBuilderImpl
    implements DOMMountPointService.DOMMountPointBuilder {
        private final MutableClassToInstanceMap<DOMService> services = MutableClassToInstanceMap.create();
        private final YangInstanceIdentifier path;
        private SimpleDOMMountPoint mountPoint;

        DOMMountPointBuilderImpl(YangInstanceIdentifier path) {
            this.path = Objects.requireNonNull(path);
        }

        public <T extends DOMService> DOMMountPointService.DOMMountPointBuilder addService(Class<T> type, T impl) {
            this.services.putInstance(Objects.requireNonNull(type), Objects.requireNonNull(impl));
            return this;
        }

        public ObjectRegistration<DOMMountPoint> register() {
            Preconditions.checkState((this.mountPoint == null ? 1 : 0) != 0, (Object)"Mount point is already built.");
            this.mountPoint = SimpleDOMMountPoint.create((YangInstanceIdentifier)this.path, this.services);
            return DOMMountPointServiceImpl.this.registerMountPoint(this.mountPoint);
        }
    }
}

