/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import java.io.File;
import java.util.Objects;

public final class JournalSegmentFile {
    private static final char PART_SEPARATOR = '-';
    private static final char EXTENSION_SEPARATOR = '.';
    private static final String EXTENSION = "log";
    private final File file;

    public static boolean isSegmentFile(String name, File file) {
        return JournalSegmentFile.isSegmentFile(name, file.getName());
    }

    public static boolean isSegmentFile(String journalName, String fileName) {
        Objects.requireNonNull(journalName, "journalName cannot be null");
        Objects.requireNonNull(fileName, "fileName cannot be null");
        int partSeparator = fileName.lastIndexOf(45);
        int extensionSeparator = fileName.lastIndexOf(46);
        if (extensionSeparator == -1 || partSeparator == -1 || extensionSeparator < partSeparator || !fileName.endsWith(EXTENSION)) {
            return false;
        }
        for (int i = partSeparator + 1; i < extensionSeparator; ++i) {
            if (Character.isDigit(fileName.charAt(i))) continue;
            return false;
        }
        return fileName.startsWith(journalName);
    }

    static File createSegmentFile(String name, File directory, long id) {
        return new File(directory, String.format("%s-%d.log", Objects.requireNonNull(name, "name cannot be null"), id));
    }

    JournalSegmentFile(File file) {
        this.file = file;
    }

    public File file() {
        return this.file;
    }
}

