/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import io.atomix.utils.serializer.KryoJournalSerdesBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public interface JournalSerdes {
    public byte[] serialize(Object var1);

    public byte[] serialize(Object var1, int var2);

    public void serialize(Object var1, ByteBuffer var2);

    public void serialize(Object var1, OutputStream var2);

    public void serialize(Object var1, OutputStream var2, int var3);

    public <T> T deserialize(byte[] var1);

    public <T> T deserialize(ByteBuffer var1);

    public <T> T deserialize(InputStream var1);

    public <T> T deserialize(InputStream var1, int var2);

    public static Builder builder() {
        return new KryoJournalSerdesBuilder();
    }

    public static interface EntrySerdes<T> {
        public T read(EntryInput var1) throws IOException;

        public void write(EntryOutput var1, T var2) throws IOException;
    }

    @Beta
    public static interface EntryOutput {
        public void writeBytes(byte[] var1) throws IOException;

        public void writeLong(long var1) throws IOException;

        public void writeObject(Object var1) throws IOException;

        public void writeString(String var1) throws IOException;

        @VisibleForTesting
        public void writeVarInt(int var1) throws IOException;
    }

    @Beta
    public static interface EntryInput {
        public byte[] readBytes(int var1) throws IOException;

        public long readLong() throws IOException;

        public String readString() throws IOException;

        public Object readObject() throws IOException;

        @VisibleForTesting
        public int readVarInt() throws IOException;
    }

    public static interface Builder {
        public JournalSerdes build();

        public JournalSerdes build(String var1);

        public Builder register(EntrySerdes<?> var1, Class<?> ... var2);

        public Builder setClassLoader(ClassLoader var1);
    }
}

