/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft;

import akka.japi.Procedure;
import java.util.Objects;
import org.opendaylight.controller.cluster.DataPersistenceProvider;
import org.opendaylight.controller.cluster.DelegatingPersistentDataProvider;
import org.opendaylight.controller.cluster.PersistentDataProvider;
import org.opendaylight.controller.cluster.raft.ReplicatedLogEntry;
import org.opendaylight.controller.cluster.raft.messages.Payload;
import org.opendaylight.controller.cluster.raft.messages.PersistentPayload;

class RaftActorDelegatingPersistentDataProvider
extends DelegatingPersistentDataProvider {
    private final PersistentDataProvider persistentProvider;

    RaftActorDelegatingPersistentDataProvider(DataPersistenceProvider delegate, PersistentDataProvider persistentProvider) {
        super(delegate);
        this.persistentProvider = Objects.requireNonNull(persistentProvider);
    }

    public <T> void persist(T entry, Procedure<T> procedure) {
        this.doPersist(entry, procedure, false);
    }

    public <T> void persistAsync(T entry, Procedure<T> procedure) {
        this.doPersist(entry, procedure, true);
    }

    private <T> void doPersist(T entry, Procedure<T> procedure, boolean async) {
        ReplicatedLogEntry replicatedLogEntry;
        Payload payload;
        if (!this.getDelegate().isRecoveryApplicable() && entry instanceof ReplicatedLogEntry && (payload = (replicatedLogEntry = (ReplicatedLogEntry)entry).getData()) instanceof PersistentPayload) {
            PersistentPayload payload2 = (PersistentPayload)((Object)payload);
            if (async) {
                this.persistentProvider.persistAsync((Object)payload2, p -> procedure.apply(entry));
            } else {
                this.persistentProvider.persist((Object)payload2, p -> procedure.apply(entry));
            }
        } else if (async) {
            super.persistAsync(entry, procedure);
        } else {
            super.persist(entry, procedure);
        }
    }
}

