/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.messages;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.opendaylight.controller.cluster.raft.messages.AbstractRaftRPC;
import org.opendaylight.controller.cluster.raft.messages.RV;

public final class RequestVote
extends AbstractRaftRPC {
    private static final long serialVersionUID = -6967509186297108657L;
    private final String candidateId;
    private final long lastLogIndex;
    private final long lastLogTerm;

    public RequestVote(long term, String candidateId, long lastLogIndex, long lastLogTerm) {
        super(term);
        this.candidateId = candidateId;
        this.lastLogIndex = lastLogIndex;
        this.lastLogTerm = lastLogTerm;
    }

    public String getCandidateId() {
        return this.candidateId;
    }

    public long getLastLogIndex() {
        return this.lastLogIndex;
    }

    public long getLastLogTerm() {
        return this.lastLogTerm;
    }

    public String toString() {
        return "RequestVote [term=" + this.getTerm() + ", candidateId=" + this.candidateId + ", lastLogIndex=" + this.lastLogIndex + ", lastLogTerm=" + this.lastLogTerm + "]";
    }

    @Override
    Object writeReplace() {
        return new RV(this);
    }

    @Deprecated(since="7.0.0", forRemoval=true)
    private static class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private RequestVote requestVote;

        @Override
        public void writeExternal(ObjectOutput out) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            long term = in.readLong();
            String candidateId = (String)in.readObject();
            long lastLogIndex = in.readLong();
            long lastLogTerm = in.readLong();
            this.requestVote = new RequestVote(term, candidateId, lastLogIndex, lastLogTerm);
        }

        private Object readResolve() {
            return this.requestVote;
        }
    }
}

